### Name: sieve
### Title: Extended Sieve Plots
### Aliases: sieve sieve.default sieve.formula
### Keywords: hplot

### ** Examples

data(HairEyeColor)

## aggregate over 'sex':
(tab <- margin.table(HairEyeColor, c(2,1)))

## plot expected values:
sieve(tab, sievetype = "expected", shade = TRUE)

## plot observed table:
sieve(tab, shade = TRUE)

## plot complete diagram:
sieve(HairEyeColor, shade = TRUE)

## an example for the formula interface:
data(VisualAcuity)
sieve(Freq ~ right + left,  data = VisualAcuity)

## example with observed values in the cells:
sieve(Titanic, pop = FALSE, shade = TRUE)
labeling_cells(text = Titanic, gp = gpar(fontface = 2))(Titanic)



