### Name: structable
### Title: Structured Contingency Tables
### Aliases: structable.default structable.formula structable
###   Extract.structable t.structable is.structable as.matrix.structable
###   as.vector.structable dim.structable dimnames.structable
###   as.table.structable
### Keywords: hplot

### ** Examples

structable(Titanic)
structable(Titanic, split_vertical = c(TRUE, TRUE, FALSE, FALSE))
structable(Titanic, direction = c("h","h","v","v"))
structable(Sex + Class ~ Survived + Age, data = Titanic)

## subsetting of structable objects
(hec <- structable(aperm(HairEyeColor)))

## subset _dimensions_ sequentially
hec[1]
hec[2]
hec["Male"]
hec[c("Male","Brown")]

## subset _rows_ and/or _columns_ sequentially
hec["Male","Hazel"]
hec[c("Male","Brown"),]
hec[c("Male","Brown"),"Hazel"]

## a few other operations
t(hec)
dim(hec)
dimnames(hec)
as.matrix(hec)

as.vector(hec) ## computed on the _multiway_ table
as.vector(unclass(hec))



