###################################################
### chunk number 1: 
###################################################
 library(BARD)


###################################################
### chunk number 2: 
###################################################
 # read in a shapefile with demographic data
 suffolk.map <- importBardShape(
      file.path(system.file("shapefiles", package="BARD"),"suffolk_tracts")
 )


###################################################
### chunk number 3: 
###################################################
  kplan <- createKmeansPlan(suffolk.map,5)
  rplan <- createRandomPlan(suffolk.map,5)


###################################################
### chunk number 4: rplot1 eval=FALSE
###################################################
##  plot(kplan,cols=colorRampPalette(c("red","grey"))(5),axes=F)


###################################################
### chunk number 5: plot1a
###################################################
 plot(kplan,cols=colorRampPalette(c("red","grey"))(5),axes=F)


###################################################
### chunk number 6: 
###################################################
reportPlans(plans=list("kmeans"=kplan,"random 1"=rplan))


###################################################
### chunk number 7: rplot2 eval=FALSE
###################################################
##  plot(diff(kplan,rplan),plotall=TRUE,cols=colorRampPalette(c("red","grey"))(5),axes=FALSE
##  ,horizontal=FALSE)


###################################################
### chunk number 8: plot2a
###################################################
 plot(diff(kplan,rplan),plotall=TRUE,cols=colorRampPalette(c("red","grey"))(5),axes=FALSE
 ,horizontal=FALSE)


###################################################
### chunk number 9: 
###################################################
myScore<-function(plan,...)combineDynamicScores(plan,scorefuns=list(calcPopScore,calcLWCompactScore))

samples<-samplePlans(list(kplan), score.fun=
	myScore, ngenplans=20, gen.fun = "createRandomPlan", refine.fun="refineNelderPlan",refine.args=list(maxit=200,dynamicscoring=TRUE))


###################################################
### chunk number 10: rplot3 eval=FALSE
###################################################
## plot(summary(samples))


###################################################
### chunk number 11: plot3a
###################################################
plot(summary(samples))


###################################################
### chunk number 12: 
###################################################
  myCombinedS<-function(plan,lastscore=NULL,...) {
  
    plast<-NULL
    ctlast<-NULL
    if (!is.null(lastscore)) {
      plast<-attr(lastscore,"plast")
      ctlast<-attr(lastscore,"ctlast")
    }
    
    pscore<-calcPopScore(plan,lastscore=plast,...)
    ctscore<-calcContiguityScore(plan,lastscore=ctlast,...)
    
    combined <- exp(ctscore)*attr(plan,"ndists")*2+exp(pscore)
    
    attr(combined,"plast")<-pscore
    attr(combined,"ctlast")<-ctscore
    return(combined)
  }


###################################################
### chunk number 13: 
###################################################
cs<-function(...) {
  mc<-substitute(list(...))
  if (length(mc)==0) {
    return(list())
  }
  listlength<-0
  for (i in seq(from=2, length.out=length(mc)-1)) {
      listlength<-listlength+length(eval.parent(mc[[i]]))
  }
  lastpos<-0
  retval<-vector(length=listlength,mode="list")
  for (i in seq(from=2, length.out=length(mc)-1)) {
      tmp<-eval.parent(mc[[i]])
      for (j in seq(from=1, length.out=length(tmp))) {
        retval[lastpos+j] <- tmp[j]
      }
      lastpos<-lastpos+length(tmp)
  }
  return(retval)
}


