###################################################
### chunk number 1: 
###################################################
## attach the package, checking that it is installed
stopifnot(require("SOAR"))

## create some dummy data
X <- matrix(rnorm(1000*50), 1000, 50)
S <- var(X)
Xb <- colMeans(X)

## and store part of it in the default cache
Store(X)


###################################################
### chunk number 2: 
###################################################
objects()   ## or ls()
find("X")


###################################################
### chunk number 3: 
###################################################
Store(Xb, S)
Search()
Objects()


###################################################
### chunk number 4: 
###################################################
vc <- gc(); vc ; v0 <- vc["Vcells", "used"]


###################################################
### chunk number 5: 
###################################################
Vcells <- function()
  c(Vcells = gc()["Vcells", "used"])            ; Vcells()-v0
bigX <- matrix(rnorm(1000^2), 1000, 1000)       ; Vcells()-v0
Store(bigX)                                     ; Vcells()-v0
d <- dim(bigX)                                  ; Vcells()-v0
bigX[1,1] <- 0                                  ; Vcells()-v0
Attach()                                        ; Vcells()-v0
Store(bigX)                                     ; Vcells()-v0


###################################################
### chunk number 6: 
###################################################
Remove(bigX)                                   ; (Vcells()-v0)


###################################################
### chunk number 7:  eval=FALSE
###################################################
## Store(objects())


###################################################
### chunk number 8:  eval=FALSE
###################################################
## objs <- objects()
## Store(list = objs)


###################################################
### chunk number 9:  eval=FALSE
###################################################
## objs <- ls()
## Store(objs, list = objs)


###################################################
### chunk number 10:  eval=FALSE
###################################################
## Remove(Objects())


###################################################
### chunk number 11:  eval=FALSE
###################################################
## cat("\nR_LOCAL_CACHE=.R_Store\n",
##     file = "~/.Renviron", append=TRUE)


###################################################
### chunk number 12:  eval=FALSE
###################################################
## Attach(lib = ".R_Store")
## Attach(lib = .R_Store)


###################################################
### chunk number 13:  eval=FALSE
###################################################
## lib <- ".R_Store"
## Store(X, Y, Z, lib = lib)


###################################################
### chunk number 14:  eval=FALSE
###################################################
## Attach(lib.loc = "..")


###################################################
### chunk number 15:  eval=FALSE
###################################################
## `%ni%` <- Negate(`%in%`)


###################################################
### chunk number 16:  eval=FALSE
###################################################
## lsCache <- Objects


###################################################
### chunk number 17:  eval=FALSE
###################################################
## StoreUtils(Vcells, `%ni%`, lsCache)


###################################################
### chunk number 18:  eval=FALSE
###################################################
## AttachUtils()


###################################################
### chunk number 19:  eval=FALSE
###################################################
## AttachData()


###################################################
### chunk number 20:  eval=FALSE
###################################################
## if(require("SOAR")) {
##     lst <- paste('autoload("', objects("package:SOAR"),
##                  '", "SOAR")\n', sep="")
##     cat("\n", lst, sep="", file = "~/.Rprofile", append = TRUE)
## }


###################################################
### chunk number 21:  eval=FALSE
###################################################
## x <- 1
## Store(x, lib = "A")
## x <- 2
## Store(x, lib = "a")


###################################################
### chunk number 22:  eval=FALSE
###################################################
## Remove(Objects())


###################################################
### chunk number 23: 
###################################################
bad <- c(" ", "<", ">", ":", "\"", "/", "\\", "|", "?", "*")
rpl <- paste("@", 0:9, sep = "")

out <- rbind("Code:" = rpl, "Character:" = bad)
colnames(out) <- rep("    ", 10)
noquote(format(out, justify = "right"))
rm(bad, rpl, f, out)


