###################################################
### chunk number 1: 
###################################################
library(actuar)


###################################################
### chunk number 2: 
###################################################
deductible <- 5
limit <- 13


###################################################
### chunk number 3: 
###################################################
pgammaL <- coverage(cdf = pgamma, deductible = deductible, limit = limit,
                     per.loss = TRUE)
dgammaL <- coverage(dgamma, pgamma, deductible = deductible, limit = limit,
                     per.loss = TRUE)
pgammaP <- coverage(cdf = pgamma, deductible = deductible, limit = limit)
dgammaP <- coverage(dgamma, pgamma, deductible = deductible, limit = limit)

formals(pgammaL)[c("shape", "rate")] <- c(5, 0.6)
formals(dgammaL)[c("shape", "rate")] <- c(5, 0.6)
formals(pgammaP)[c("shape", "rate")] <- c(5, 0.6)
formals(dgammaP)[c("shape", "rate")] <- c(5, 0.6)

d <- deductible
u <- limit - d
e <- 0.001
ylim <- c(0, dgammaL(0))


###################################################
### chunk number 4: 
###################################################
par(mar = c(2, 3, 1, 1))
curve(pgammaP(x), from = 0, to = u - e,
      xlim = c(0, limit), ylim = c(0, 1),
      xlab = "", ylab = "", xaxt = "n", lwd = 2)
curve(pgammaP(x), from = u, add = TRUE, lwd = 2)
axis(1, at = c(0, u), labels = c("0", "u - d"))


###################################################
### chunk number 5: 
###################################################
par(mar = c(2, 3, 1, 1))
curve(dgammaP(x), from = 0 + e, to = u - e,
      xlim = c(0, limit), ylim = ylim,
      xlab = "", ylab = "", xaxt = "n", lwd = 2)
points(u, dgammaP(u), pch = 16)
axis(1, at = c(0, u), labels = c("0", "u - d"))


###################################################
### chunk number 6: 
###################################################
par(mar = c(2, 3, 1, 1))
curve(pgammaL(x), from = 0, to = u - e,
      xlim = c(0, limit), ylim = c(0, 1),
      xlab = "", ylab = "", xaxt = "n", lwd = 2)
curve(pgammaL(x), from = u, add = TRUE, lwd = 2)
axis(1, at = c(0, u), labels = c("0", "u - d"))


###################################################
### chunk number 7: 
###################################################
par(mar = c(2, 3, 1, 1))
curve(dgammaL(x), from = 0 + e, to = u - e,
      xlim = c(0, limit), ylim = ylim,
      xlab = "", ylab = "", xaxt = "n", lwd = 2)
points(c(0, u), dgammaL(c(0, u)), pch = 16)
axis(1, at = c(0, u), labels = c("0", "u - d"))


###################################################
### chunk number 8: 
###################################################
pgammaL <- coverage(cdf = pgamma, deductible = deductible, limit = limit,
                     per.loss = TRUE, franchise = TRUE)
dgammaL <- coverage(dgamma, pgamma, deductible = deductible, limit = limit,
                     per.loss = TRUE, franchise = TRUE)
pgammaP <- coverage(cdf = pgamma, deductible = deductible, limit = limit,
                    franchise = TRUE)
dgammaP <- coverage(dgamma, pgamma, deductible = deductible, limit = limit,
                    franchise = TRUE)

formals(pgammaL)[c("shape", "rate")] <- c(5, 0.6)
formals(dgammaL)[c("shape", "rate")] <- c(5, 0.6)
formals(pgammaP)[c("shape", "rate")] <- c(5, 0.6)
formals(dgammaP)[c("shape", "rate")] <- c(5, 0.6)

d <- deductible
u <- limit
e <- 0.001
ylim <- c(0, dgammaL(0))


###################################################
### chunk number 9: 
###################################################
par(mar = c(2, 3, 1, 1))
curve(pgammaP(x), from = 0, to = u - e,
      xlim = c(0, limit + d), ylim = c(0, 1),
      xlab = "", ylab = "", xaxt = "n", lwd = 2)
curve(pgammaP(x), from = u, add = TRUE, lwd = 2)
axis(1, at = c(0, d, u), labels = c("0", "d", "u"))


###################################################
### chunk number 10: 
###################################################
par(mar = c(2, 3, 1, 1))
curve(dgammaP(x), from = d + e, to = u - e,
      xlim = c(0, limit + d), ylim = ylim,
      xlab = "", ylab = "", xaxt = "n", lwd = 2)
curve(dgammaL(x), from = 0 + e, to = d, add = TRUE, lwd = 2)
points(u, dgammaP(u), pch = 16)
axis(1, at = c(0, d, u), labels = c("0", "d", "u"))


###################################################
### chunk number 11: 
###################################################
par(mar = c(2, 3, 1, 1))
curve(pgammaL(x), from = 0, to = u - e,
      xlim = c(0, limit + d), ylim = c(0, 1),
      xlab = "", ylab = "", xaxt = "n", lwd = 2)
curve(pgammaL(x), from = u, add = TRUE, lwd = 2)
axis(1, at = c(0, d, u), labels = c("0", "d", "u"))


###################################################
### chunk number 12: 
###################################################
par(mar = c(2, 3, 1, 1))
curve(dgammaL(x), from = d + e, to = u - e,
      xlim = c(0, limit + d), ylim = ylim,
      xlab = "", ylab = "", xaxt = "n", lwd = 2)
curve(dgammaL(x), from = 0 + e, to = d, add = TRUE, lwd = 2)
points(c(0, u), dgammaL(c(0, u)), pch = 16)
axis(1, at = c(0, d, u), labels = c("0", "d", "u"))


