###################################################
### chunk number 1: 
###################################################
library(actuar)
options(width = 68, digits = 4)


###################################################
### chunk number 2: 
###################################################
data(hachemeister)
hachemeister


###################################################
### chunk number 3: 
###################################################
X <- cbind(cohort = c(1, 2, 1, 2, 2), hachemeister)
fit <- cm(~cohort + cohort:state, data = X, ratios = ratio.1:ratio.12,
          weights = weight.1:weight.12, method = "iterative")
fit


###################################################
### chunk number 4: 
###################################################
predict(fit)


###################################################
### chunk number 5: 
###################################################
summary(fit)


###################################################
### chunk number 6: 
###################################################
summary(fit, levels = "cohort")
predict(fit, levels = "cohort")


###################################################
### chunk number 7: 
###################################################
cm(~state, hachemeister, ratios = ratio.1:ratio.12)


###################################################
### chunk number 8: 
###################################################
cm(~state, hachemeister, ratios = ratio.1:ratio.12,
   weights = weight.1:weight.12)


###################################################
### chunk number 9: 
###################################################
fit <- cm(~state, hachemeister,
          regformula = ~ time, regdata = data.frame(time = 1:12),
          ratios = ratio.1:ratio.12, weights = weight.1:weight.12)
fit


###################################################
### chunk number 10: 
###################################################
predict(fit, newdata = data.frame(time = 13))


###################################################
### chunk number 11: 
###################################################
plot(NA, xlim = c(1, 13), ylim = c(1000, 2000), xlab = "", ylab = "")
x <- cbind(1, 1:12)
lines(1:12, x %*% fit$means$portfolio,
      col = "blue", lwd = 2)
lines(1:12, x %*% fit$means$state[, 4],
      col = "red", lwd = 2, lty = 2)
lines(1:12, x %*% coefficients(fit$adj.models[[4]]),
      col = "darkgreen", lwd = 2, lty = 3)
points(13, predict(fit, newdata = data.frame(time = 13))[4],
       pch = 8, col = "darkgreen")
legend("bottomright",
       legend = c("collective", "individual", "credibility"),
       col = c("blue", "red", "darkgreen"), lty = 1:3)


###################################################
### chunk number 12: 
###################################################
fit2 <- cm(~state, hachemeister,
           regformula = ~ time, regdata = data.frame(time = 1:12),
           adj.intercept = TRUE,
           ratios = ratio.1:ratio.12, weights = weight.1:weight.12)
summary(fit2, newdata = data.frame(time = 13))


###################################################
### chunk number 13: 
###################################################
plot(NA, xlim = c(1, 13), ylim = c(1000, 2000), xlab = "", ylab = "")
x <- cbind(1, 1:12)
R <- fit2$transition
lines(1:12, x %*% solve(R, fit2$means$portfolio),
      col = "blue", lwd = 2)
lines(1:12, x %*% solve(R, fit2$means$state[, 4]),
      col = "red", lwd = 2, lty = 2)
lines(1:12, x %*% solve(R, coefficients(fit2$adj.models[[4]])),
      col = "darkgreen", lwd = 2, lty = 3)
points(13, predict(fit2, newdata = data.frame(time = 13))[4],
       pch = 8, col = "darkgreen")
legend("bottomright",
       legend = c("collective", "individual", "credibility"),
       col = c("blue", "red", "darkgreen"), lty = 1:3)


