###################################################
### chunk number 1: 
###################################################
library(actuar)
options(width = 62, digits = 4)


###################################################
### chunk number 2: 
###################################################
x <- grouped.data(Group = c(0, 25, 50, 100, 150, 250, 500),
                  Line.1 = c(30, 31, 57, 42, 65, 84),
                  Line.2 = c(26, 33, 31, 19, 16, 11))


###################################################
### chunk number 3: 
###################################################
class(x)


###################################################
### chunk number 4: 
###################################################
x


###################################################
### chunk number 5: 
###################################################
x[, 1]                                  # group boundaries


###################################################
### chunk number 6: 
###################################################
x[, -1]                                 # group frequencies


###################################################
### chunk number 7: 
###################################################
x[1:3,]                                 # first 3 groups


###################################################
### chunk number 8: 
###################################################
x[1, 2] <- 22; x                        # frequency replacement
x[1, c(2, 3)] <- c(22, 19); x           # frequency replacement


###################################################
### chunk number 9: 
###################################################
x[1, 1] <- c(0, 20); x                  # boundary replacement
x[c(3, 4), 1] <- c(55, 110, 160); x


###################################################
### chunk number 10: 
###################################################
mean(x)


###################################################
### chunk number 11: 
###################################################
hist(x[, -3])


###################################################
### chunk number 12: 
###################################################
hist(x[, -3])


###################################################
### chunk number 13: 
###################################################
Fnt <- ogive(x)
knots(Fnt)                              # group boundaries
Fnt(knots(Fnt))                         # ogive at group boundaries
plot(Fnt)                               # plot of the ogive


###################################################
### chunk number 14: 
###################################################
plot(Fnt)


###################################################
### chunk number 15: 
###################################################
quantile(x)
Fnt(quantile(x))


###################################################
### chunk number 16: 
###################################################
data("dental"); dental
data("gdental"); gdental


###################################################
### chunk number 17: 
###################################################
emm(dental, order = 1:3)                # first three moments
emm(gdental, order = 1:3)               # idem


###################################################
### chunk number 18: 
###################################################
lev <- elev(dental)
lev(knots(lev))                         # ELEV at data points
plot(lev, type = "o", pch = 19)         # plot of the ELEV function

lev <- elev(gdental)
lev(knots(lev))                         # ELEV at data points
plot(lev, type = "o", pch = 19)         # plot of the ELEV function


###################################################
### chunk number 19: 
###################################################
par(mfrow = c(1, 2))
plot(elev(dental), type = "o", pch = 19)
plot(elev(gdental), type = "o", pch = 19)


###################################################
### chunk number 20: 
###################################################
op <- options(warn = -1)                # hide warnings from mde()


###################################################
### chunk number 21: 
###################################################
mde(gdental, pexp, start = list(rate = 1/200), measure = "CvM")
mde(gdental, pexp, start = list(rate = 1/200), measure = "chi-square")
mde(gdental, levexp, start = list(rate = 1/200), measure = "LAS")


###################################################
### chunk number 22: 
###################################################
options(op)                             # restore warnings


###################################################
### chunk number 23:  eval=FALSE
###################################################
## mde(gdental, ppareto, start = list(shape = 3, scale = 600),
##         measure = "CvM") # no convergence


###################################################
### chunk number 24: 
###################################################
out <- try(mde(gdental, ppareto, start = list(shape = 3, scale = 600),
        measure = "CvM"))
cat(sub(", measure", ",\n             measure", out))


###################################################
### chunk number 25: 
###################################################
pparetolog <- function(x, logshape, logscale)
    ppareto(x, exp(logshape), exp(logscale))
( p <- mde(gdental, pparetolog, start = list(logshape = log(3),
                                logscale = log(600)), measure = "CvM") )


###################################################
### chunk number 26: 
###################################################
exp(p$estimate)


###################################################
### chunk number 27: 
###################################################
f <- coverage(pdf = dgamma, cdf = pgamma, deductible = 1, limit = 10)
f
f(0, shape = 5, rate = 1)
f(5, shape = 5, rate = 1)
f(9, shape = 5, rate = 1)
f(12, shape = 5, rate = 1)


###################################################
### chunk number 28: 
###################################################
x <- rgamma(100, 2, 0.5)
y <- pmin(x[x > 1], 9)
op <- options(warn = -1)                # hide warnings from fitdistr()


###################################################
### chunk number 29: 
###################################################
library(MASS)
fitdistr(y, f, start = list(shape = 2, rate = 0.5))


###################################################
### chunk number 30: 
###################################################
options(op)                             # restore warnings


