###################################################
### chunk number 1: 
###################################################
library(actuar)
options(width = 62, digits = 4)


###################################################
### chunk number 2:  eval=FALSE
###################################################
## rpois(n, rgamma(n, 3, rgamma(n, 2, 2)))


###################################################
### chunk number 3: 
###################################################
set.seed(3)


###################################################
### chunk number 4: 
###################################################
nodes <- list(cohort = 2,
              contract = c(4, 3),
              year = c(4, 4, 4, 4, 5, 5, 5))
mf <- expression(cohort = rexp(2),
                 contract = rgamma(cohort, 1),
                 year = rpois(weights * contract))
ms <- expression(cohort = rnorm(2, sqrt(0.1)),
                 contract = rnorm(cohort, 1),
                 year = rlnorm(contract, 1))
wijt <- runif(31, 0.5, 2.5)
pf <- simul(nodes = nodes, model.freq = mf, model.sev = ms, weights = wijt)


###################################################
### chunk number 5: 
###################################################
class(pf)
pf$data
pf$classification


###################################################
### chunk number 6: 
###################################################
pf


###################################################
### chunk number 7: 
###################################################
aggregate(pf)
aggregate(pf, by = c("cohort", "year"), FUN = mean)


###################################################
### chunk number 8: 
###################################################
frequency(pf)
frequency(pf, by = "cohort")


###################################################
### chunk number 9: 
###################################################
severity(pf)
severity(pf, splitcol = 1)


###################################################
### chunk number 10: 
###################################################
weights(pf)


###################################################
### chunk number 11: 
###################################################
aggregate(pf, classif = FALSE) / weights(pf, classif = FALSE)


###################################################
### chunk number 12: 
###################################################
set.seed(123)
options(width = 55)


###################################################
### chunk number 13: 
###################################################
wit <- rgamma(15, rep(runif(3, 0, 100), each = 5),
              rep(runif(3, 0, 100), each = 5))


###################################################
### chunk number 14: 
###################################################
frequency(simul(list(entity = 3, year = 5),
      expression(entity = rgamma(rgamma(1, 5, 5), rgamma(1, 25, 1)),
          year = rpois(weights * entity)),
      weights = wit))


