###################################################
### chunk number 1: 
###################################################
options(width=80, prompt='R> ')


###################################################
### chunk number 2: 
###################################################
library(archetypes)


###################################################
### chunk number 3:  eval=FALSE
###################################################
## data("toy")
## plot(toy)


###################################################
### chunk number 4: 
###################################################
data("toy")

par(mar = c(2,2,0,0) + 0.1, ps = 9)
plot(toy, xlab = "", ylab = "", xlim = c(0,20), ylim = c(0,20),
     pch = 19, col = gray(0.7), cex = 0.6)


###################################################
### chunk number 5: 
###################################################
set.seed(1986)
a <- archetypes(toy, 3, verbose = TRUE)


###################################################
### chunk number 6: 
###################################################
a


###################################################
### chunk number 7: 
###################################################
parameters(a)


###################################################
### chunk number 8:  eval=FALSE
###################################################
## xyplot(a, toy, chull = chull(toy))
## xyplot(a, toy, adata.show = TRUE)


###################################################
### chunk number 9: 
###################################################
par(mfrow = c(1,2), mar = c(2,2,0,0)+0.1, ps = 9)
xyplot(a, toy, chull = chull(toy),
       xlab = "", ylab = "", xlim = c(0, 20), ylim = c(0, 20), cex = 0.6)
xyplot(a, toy, adata.show = TRUE,
       xlab = "", ylab = "", xlim = c(0, 20), ylim = c(0, 20), cex = 0.6)


###################################################
### chunk number 10:  eval=FALSE
###################################################
## movieplot(a, toy)


###################################################
### chunk number 11: 
###################################################
par(mfrow = c(2, 4), mar = c(0, 0, 0, 0) + 0.1, ps = 9)
movieplot(a, toy, xlim = c(0, 20), ylim = c(0, 20), cex = 0.6, axes = FALSE,
          postfn = function(iter) {
            box()
            text(1, 19, paste(iter + 1, ".", sep = ""), cex = 1)
          })


###################################################
### chunk number 12: 
###################################################
set.seed(1986)
a4 <- stepArchetypes(data = toy, k = 3, verbose = FALSE, nrep = 4)


###################################################
### chunk number 13: 
###################################################
a4


###################################################
### chunk number 14: 
###################################################
summary(a4)


###################################################
### chunk number 15:  eval=FALSE
###################################################
## xyplot(a4, toy)


###################################################
### chunk number 16: 
###################################################
par(mar = c(2, 2, 0, 0) + 0.1, ps = 9)
xyplot(a4, toy, cex = 0.6, xlim = c(0, 20), ylim = c(0, 20),
       xlab = "", ylab = "")


###################################################
### chunk number 17:  eval=FALSE
###################################################
## bestModel(a4)


###################################################
### chunk number 18: 
###################################################
print(bestModel(a4), full = FALSE)


###################################################
### chunk number 19: 
###################################################
file <- "as.RData"
if ( file.exists(file) ) {
  load(file = file)
} else {
  set.seed(1986)
  as <- stepArchetypes(data = toy, k = 1:10, verbose = FALSE, nrep = 4)
  save(as, file = file)
}


###################################################
### chunk number 20: 
###################################################
rss(as)


###################################################
### chunk number 21: 
###################################################
t(sapply(as, function(a) sapply(a, '[[', 'iters')))


###################################################
### chunk number 22:  eval=FALSE
###################################################
## screeplot(as)


###################################################
### chunk number 23: 
###################################################
par(mar = c(3, 4, 0.1, 0) + 0.1, ps = 9)
screeplot(as, cex = 0.6, ylim = c(0, 0.08), axes = FALSE)
mtext("Archetypes", side = 1, line = 2)
axis(2, las = 2)
box()


###################################################
### chunk number 24:  eval=FALSE
###################################################
## a7 <- bestModel(as[[7]])
## xyplot(a7, toy, chull = chull(toy))
## xyplot(a7, toy, adata.show = TRUE)


###################################################
### chunk number 25: 
###################################################
a7 <- bestModel(as[[7]])

par(mfrow = c(1, 2), mar = c(2, 2, 0, 0) + 0.1, ps = 9)
xyplot(a7, toy, chull = chull(toy),
       xlim = c(0, 20), ylim = c(0, 20), cex = 0.6, xlab = "", ylab = "")
xyplot(a7, toy, adata.show = TRUE,
       xlim = c(0, 20), ylim = c(0, 20), cex = 0.6, xlab = "", ylab = "")


###################################################
### chunk number 26: 
###################################################
file <- "gas.RData"
if ( file.exists(file) ) {
  load(file = file)
} else {
  set.seed(1986)
  gas <- stepArchetypes(data = toy, k = 1:10,
                        family = archetypesFamily("original",
                        zalphasfn = archetypes:::ginv.zalphasfn),
                        verbose = FALSE, nrep = 4)
  save(gas, file = file)
}


###################################################
### chunk number 27: 
###################################################
rss(gas)


###################################################
### chunk number 28:  eval=FALSE
###################################################
## movieplot(gas[[9]][[3]], toy)


###################################################
### chunk number 29: 
###################################################
par(mfrow = c(1, 4), mar = c(0, 0, 0, 0) + 0.1, ps = 9)
movieplot(gas[[9]][[3]], toy, xlim = c(0, 20), ylim = c(0, 20), cex = 0.6,
          axes = FALSE, postfn = function(iter) {
            box()
            text(1, 19, paste(iter + 1, ".", sep = ""), cex = 1)
          })


###################################################
### chunk number 30:  eval=FALSE
###################################################
## ga7 <- bestModel(gas[[7]])
## xyplot(ga7, toy, chull = chull(toy))
## xyplot(ga7, toy, adata.show = TRUE)


###################################################
### chunk number 31: 
###################################################
ga7 <- bestModel(gas[[7]])

par(mfrow = c(1, 2), mar = c(2, 2, 0, 0) + 0.1, ps = 9)
xyplot(ga7, toy, chull = chull(toy),
       xlim = c(0, 20), ylim = c(0, 20), cex = 0.6, xlab = "", ylab = "")
xyplot(ga7, toy, adata.show = TRUE,
       xlim = c(0, 20), ylim = c(0, 20), cex = 0.6, xlab = "", ylab = "")


###################################################
### chunk number 32: 
###################################################
apply(coef(ga7, 'alphas'), 2, range)


###################################################
### chunk number 33: 
###################################################
data("skel")
skel2 <- subset(skel, select = -Gender)


###################################################
### chunk number 34:  eval=FALSE
###################################################
## jd()


###################################################
### chunk number 35: 
###################################################
par(mar = c(1, 4, 0, 0) + 0.1, ps = 9)
jd()


###################################################
### chunk number 36:  eval=FALSE
###################################################
## pcplot(skel2)


###################################################
### chunk number 37: 
###################################################
datacol <- rgb(178, 178, 178, maxColorValue = 255,
               alpha = round(255 * 0.2))


###################################################
### chunk number 38:  eval=FALSE
###################################################
## par(mar = c(5, 0.4, 0, 0.4) + 0.1, ps = 9)
## pcplot(skel2, las = 2, col = datacol)


###################################################
### chunk number 39: 
###################################################
png(filename = "body-pcplot-raw.png", units = "px",
    width = 590, height = 430, pointsize = 12)
par(mar = c(5.5, 0.4, 0, 0.4) + 0.1)
pcplot(skel2, las = 2, col = datacol)
graphics.off()
cat("\\includegraphics{body-pcplot-raw.png}\n")


###################################################
### chunk number 40: 
###################################################
file <- "bas.RData"
if ( file.exists(file) ) {
  load(file = file)
} else {
  set.seed(1981)
  as <- stepArchetypes(skel2, k = 1:15, verbose = FALSE)
  save(as, file = file)
}


###################################################
### chunk number 41:  eval=FALSE
###################################################
## screeplot(as)


###################################################
### chunk number 42: 
###################################################
par(mar = c(3, 4, 0.4, 0) + 0.1, ps = 9)
screeplot(as, cex = 0.6, axes = FALSE)
mtext("Archetypes", side = 1, line = 2)
axis(2, las = 2)
box()


###################################################
### chunk number 43: 
###################################################
a3 <- bestModel(as[[3]])


###################################################
### chunk number 44: 
###################################################
t(parameters(a3))


###################################################
### chunk number 45:  eval=FALSE
###################################################
## barplot(a3, skel2, percentiles = TRUE)


###################################################
### chunk number 46: 
###################################################
par(mar = c(5, 4, 0.4, 0) + 0.1, ps = 9)
barplot(a3, skel2, percentiles = TRUE,
        below.compressed.height = 0.4,
        below.compressed.srt = 90)


###################################################
### chunk number 47:  eval=FALSE
###################################################
## pcplot(a3, skel2, data.col = as.numeric(skel$Gender))


###################################################
### chunk number 48: 
###################################################
datacol <- c(rgb(0, 205, 0, maxColorValue = 255,
                 alpha = round(255 * 0.2)),
             rgb(0, 0, 255, maxColorValue = 255,
                 alpha=round(255 * 0.2)))


###################################################
### chunk number 49:  eval=FALSE
###################################################
## par(mar = c(5, 0.4, 0, 0.4) + 0.1, ps = 9)
## pcplot(a3, skel2, las = 2, data.col = datacol[skel$Gender])


###################################################
### chunk number 50: 
###################################################
png(filename = "body-pcplot-gender.png", units = "px",
    width = 590, height = 430, pointsize = 12)
par(mar = c(5.5, 0.4, 0, 0.4) + 0.1)
pcplot(a3, skel2, las = 2, data.col = datacol[skel$Gender])
graphics.off()
cat("\\includegraphics{body-pcplot-gender.png}\n")


###################################################
### chunk number 51:  eval=FALSE
###################################################
## ternaryplot(coef(a3, 'alphas'), col = as.numeric(skel$Gender))


###################################################
### chunk number 52: 
###################################################
library("vcd")
ternaryplot(coef(a3, 'alphas'), dimnames = 1:3, cex = 0.3,
            col = datacol[skel$Gender], main = NULL,
            labels = "none", grid = FALSE)
grid.text("1", x = 3, y = 3)


###################################################
### chunk number 53:  eval=FALSE
###################################################
## skeletonplot(parameters(a3))


###################################################
### chunk number 54: 
###################################################
par(mar = c(1, 4, 0, 0) + 0.1, ps = 9)
skeletonplot(parameters(a3), skel.height = 190)


###################################################
### chunk number 55: 
###################################################
sessionInfo()


