###################################################
### chunk number 1: preliminaries
###################################################
set.seed(1071)
old.opts <- options(width=85, digits=6, useFancyQuotes = FALSE, continue="  ")
library(heplots)
library(candisc)


###################################################
### chunk number 2: plastic-mod
###################################################
plastic.mod <- lm(cbind(tear, gloss, opacity) ~ rate*additive, data=Plastic)
Anova(plastic.mod, test.statistic="Roy")


###################################################
### chunk number 3: plastic-univar
###################################################
Anova(update(plastic.mod, tear ~ .))
Anova(update(plastic.mod, gloss ~ .))
Anova(update(plastic.mod, opacity ~ .))


###################################################
### chunk number 4: plastic1a eval=FALSE
###################################################
## # Compare evidence and effect scaling 
## colors = c("red", "darkblue", "darkgreen", "brown")
## heplot(plastic.mod, size="evidence", col=colors, cex=1.25)
## heplot(plastic.mod, size="effect", add=TRUE, lwd=4, term.labels=FALSE, col=colors)


###################################################
### chunk number 5: plastic1b eval=FALSE
###################################################
## ## add interaction means
## intMeans <- termMeans(plastic.mod, 'rate:additive', abbrev.levels=2)
## #rownames(intMeans) <- apply(expand.grid(c('Lo','Hi'), c('Lo', 'Hi')), 1, paste, collapse=':')
## points(intMeans[,1], intMeans[,2], pch=18, cex=1.2, col="brown")
## text(intMeans[,1], intMeans[,2], rownames(intMeans), adj=c(0.5,1), col="brown")
## lines(intMeans[c(1,3),1], intMeans[c(1,3),2], col="brown")
## lines(intMeans[c(2,4),1], intMeans[c(2,4),2], col="brown")


###################################################
### chunk number 6: plastic1
###################################################
# Compare evidence and effect scaling 
colors = c("red", "darkblue", "darkgreen", "brown")
heplot(plastic.mod, size="evidence", col=colors, cex=1.25)
heplot(plastic.mod, size="effect", add=TRUE, lwd=4, term.labels=FALSE, col=colors)
## add interaction means
intMeans <- termMeans(plastic.mod, 'rate:additive', abbrev.levels=2)
#rownames(intMeans) <- apply(expand.grid(c('Lo','Hi'), c('Lo', 'Hi')), 1, paste, collapse=':')
points(intMeans[,1], intMeans[,2], pch=18, cex=1.2, col="brown")
text(intMeans[,1], intMeans[,2], rownames(intMeans), adj=c(0.5,1), col="brown")
lines(intMeans[c(1,3),1], intMeans[c(1,3),2], col="brown")
lines(intMeans[c(2,4),1], intMeans[c(2,4),2], col="brown")


###################################################
### chunk number 7: plastic-mod
###################################################
plastic.mod


###################################################
### chunk number 8: plastic-tests
###################################################
print(linearHypothesis(plastic.mod, c("rateHigh", "additiveHigh"), title="Main effects"), SSP=FALSE)

print(linearHypothesis(plastic.mod, c("rateHigh", "additiveHigh", "rateHigh:additiveHigh"), title="Groups"), SSP=FALSE)


###################################################
### chunk number 9: plastic2
###################################################
heplot(plastic.mod, hypotheses=list("Group" = 
       c("rateHigh", "additiveHigh", "rateHigh:additiveHigh ")),
       col=c(colors, "purple"),
       lwd=c(2, 3, 3, 3, 2), cex=1.25)
heplot(plastic.mod, hypotheses=list("Main effects" = 
       c("rateHigh", "additiveHigh")), add=TRUE,
       col=c(colors, "darkgreen"), cex=1.25)


###################################################
### chunk number 10: plastic1-HE3D eval=FALSE
###################################################
## colors = c("pink", "darkblue", "darkgreen", "brown")
## heplot3d(plastic.mod, col=colors)


###################################################
### chunk number 11: MJdata
###################################################
str(MockJury)


###################################################
### chunk number 12: MJdata1
###################################################
table(MockJury$Attr)
table(MockJury$Attr, MockJury$Crime)


###################################################
### chunk number 13: jury.mod1
###################################################
(jury.mod1 <- lm( cbind(phyattr, happy, independent, sophisticated) ~ Attr, data=MockJury))
Anova(jury.mod1, test="Roy")


###################################################
### chunk number 14: jury-mod1-HE
###################################################
heplot(jury.mod1, main="HE plot for manipulation check")


###################################################
### chunk number 15: jury-mod1-pairs
###################################################
pairs(jury.mod1)


###################################################
### chunk number 16: jury-can1a
###################################################
jury.can <- candisc(jury.mod1)
jury.can


###################################################
### chunk number 17: jury-can1
###################################################
opar <- par(xpd=TRUE)
heplot(jury.can, prefix="Canonical dimension", main="Canonical HE plot")
par(opar)


###################################################
### chunk number 18: jury-mod2
###################################################
# influence of Attr of photo and nature of crime on Serious and Years
jury.mod2 <- lm( cbind(Serious, Years) ~ Attr * Crime, data=MockJury)
Anova(jury.mod2, test="Roy")


###################################################
### chunk number 19: jury-mod2-HE
###################################################
heplot(jury.mod2)


###################################################
### chunk number 20: jury-mod3-HE
###################################################
# stepdown test (ANCOVA), controlling for Serious
jury.mod3 <- lm( Years ~ Serious + Attr * Crime, data=MockJury)
t(coef(jury.mod3))
Anova(jury.mod3)


###################################################
### chunk number 21: jury-mod3-eff
###################################################
library(effects)
jury.eff <- allEffects(jury.mod3)
plot(jury.eff, ask=FALSE)


###################################################
### chunk number 22: tidyup
###################################################
options(old.opts )


