###################################################
### chunk number 1: ctdplot eval=FALSE
###################################################
## library(oce)
## data(ctd)
## plot(ctd)


###################################################
### chunk number 2: ctdsummary eval=FALSE
###################################################
## summary(ctd)


###################################################
### chunk number 3: ctdnames eval=FALSE
###################################################
## names(ctd)


###################################################
### chunk number 4: ctdnames2 eval=FALSE
###################################################
## names(ctd$data)


###################################################
### chunk number 5: ctdfig
###################################################
library(oce)
data(ctd)
plot(ctd)


###################################################
### chunk number 6: ctdrawplot eval=FALSE
###################################################
## data(ctd.raw)
## plot.ctd.scan(ctd.raw)


###################################################
### chunk number 7: ctdrawfig
###################################################
data(ctd.raw)
plot.ctd.scan(ctd.raw)


###################################################
### chunk number 8: ctdscaneg eval=FALSE
###################################################
## plot.ctd.scan(ctd.trim(ctd.raw, "scan", c(140,250)))
## plot.ctd.scan(ctd.trim(ctd.raw, "scan", c(150,250)))


###################################################
### chunk number 9: ctdtrimeg eval=FALSE
###################################################
## ctd.trimmed <- ctd.trim(ctd.raw)


###################################################
### chunk number 10: ctddectrim eval=FALSE
###################################################
## plot(ctd.decimate(ctd.trim(read.ctd("stn123.cnv"))))


###################################################
### chunk number 11: ctdfix1 eval=FALSE
###################################################
## x <- read.ctd("nnsa_00934_00001_ct1.csv", type="WOCE")
## x$metadata$institute <- "SIO" # bad way
## x$metadata$scientist <- "DAM" # bad way


###################################################
### chunk number 12: ctdfix2 eval=FALSE
###################################################
## x <- read.ctd("nnsa_00934_00001_ct1.csv", type="WOCE")
## x <- oce.edit(x, "institute", "SIO") # better way
## x <- oce.edit(x, "scientist", "DAM") # better way


###################################################
### chunk number 13: ctdfix3 eval=FALSE
###################################################
## x <- read.ctd("nnsa_00934_00001_ct1.csv", type="WOCE")
## x <- oce.edit(x, "institute", "SIO", "human-parsed","Dan Kelley") # best way
## x <- oce.edit(x, "scientist", "DAM", "human-parsed","Dan Kelley") # best way


###################################################
### chunk number 14: arcticeg eval=FALSE
###################################################
## library(oce)
## # Source: http://cchdo.ucsd.edu/data_access?ExpoCode=58JH199410
## files <- system("ls *.csv", intern=TRUE)
## for (i in 1:length(files)) {
##     cat(files[i], "\n")
##     x <- read.ctd(files[i])
##     if (i == 1) {
##         plot.TS(x, xlim=c(31, 35.5), ylim=c(-1, 10), type='l', col="red")
##     } else {
##         lines(x$data$salinity, x$data$temperature, col="red")
##     }
## }


###################################################
### chunk number 15: rangeg eval=FALSE
###################################################
## print(range(x$data$temperature))
## print(range(x$data$salinity))


###################################################
### chunk number 16: sectionplot eval=FALSE
###################################################
## data(section)
## data(coastline.hal)
## plot(section, coastline=coastline.hal)


###################################################
### chunk number 17: sectionplota03 eval=FALSE
###################################################
## # File source -- http://cchdo.ucsd.edu/data_access?ExpoCode=90CT40_1
## # a03 <- read.section("a03_hy1.csv")
## data(a03)
## Gulf.Stream <- subset(a03, indices=124:102)
## Gulf.Stream.gridded <- section.grid(Gulf.Stream, p=seq(0, 1600, 25))
## data(coastline.world)
## plot(Gulf.Stream.gridded, coastline=coastline.world, map.xlim=c(-80,-60))


###################################################
### chunk number 18: sectionfiga03
###################################################
# File source -- http://cchdo.ucsd.edu/data_access?ExpoCode=90CT40_1
# a03 <- read.section("a03_hy1.csv")
data(a03)
Gulf.Stream <- subset(a03, indices=124:102)
Gulf.Stream.gridded <- section.grid(Gulf.Stream, p=seq(0, 1600, 25))
data(coastline.world)
plot(Gulf.Stream.gridded, coastline=coastline.world, map.xlim=c(-80,-60))


###################################################
### chunk number 19: topoplot eval=FALSE
###################################################
## library(oce)
## data(topo.maritimes)
## plot(topo.maritimes, xlim=c(-66, -58), ylim=c(44, 50),
##      water.z=c(  -50, -100, -150, -200, -300, -400, -500, -1000, -2000),
##      water.lwd=c(  1,    1,    1,    1,    1,   1,   1.5,   1.5,   1.5))


###################################################
### chunk number 20: topofig
###################################################
library(oce)
data(topo.maritimes)
plot(topo.maritimes, xlim=c(-66, -58), ylim=c(44, 50),
     water.z=c(  -50, -100, -150, -200, -300, -400, -500, -1000, -2000),
     water.lwd=c(  1,    1,    1,    1,    1,   1,   1.5,   1.5,   1.5))


###################################################
### chunk number 21: sealevelplot eval=FALSE
###################################################
## library(oce)
## #sealevel <- read.oce("../../tests/h275a96.dat")
## data(sealevel.hal)
## plot(sealevel.hal)


###################################################
### chunk number 22: sealevelfig
###################################################
library(oce)
#sealevel <- read.oce("../../tests/h275a96.dat")
data(sealevel.hal)
plot(sealevel.hal)


###################################################
### chunk number 23: ptplot eval=FALSE
###################################################
## library(oce)
## data(pt)
## plot(pt)


###################################################
### chunk number 24: ptfig
###################################################
library(oce)
data(pt)
plot(pt)


###################################################
### chunk number 25: adpplot eval=FALSE
###################################################
## library(oce)
## data(adp)
## e <- adp.xyz2enu(adp.beam2xyz(adp))
## plot(e, which=1:2,
##      adorn=expression({
##        lines(x$data$ts$time, x$data$ts$pressure, lwd=3, col='green')
##      }))


###################################################
### chunk number 26: adpfig
###################################################
library(oce)
data(adp)
e <- adp.xyz2enu(adp.beam2xyz(adp))
plot(e, which=1:2,
     adorn=expression({
       lines(x$data$ts$time, x$data$ts$pressure, lwd=3, col='green')
     }))


###################################################
### chunk number 27: 
###################################################
library(oce)
sw.rho(S=34, t=10, p=100)
sw.theta(S=34, t=10, p=100)
sw.rho(S=34, t=sw.theta(S=34, t=10, p=100), p=0)
sw.rho(S=34, t=sw.theta(S=34, t=10, p=100, pref=200), p=200)
plot.TS(as.ctd(c(30,40),c(-2,20),rep(0,2)), grid=TRUE, col="white")


###################################################
### chunk number 28: 
###################################################
library(oce)
data(ctd)
pycnocline <- ctd.trim(ctd, "pressure", c(5,12))
plot.profile(pycnocline, type="density+N2")


###################################################
### chunk number 29: 
###################################################
library(oce)
data(ctd)
pycnocline <- subset(ctd, 5<=pressure & pressure<=12)
plot.profile(pycnocline, type="density+N2")


###################################################
### chunk number 30: 
###################################################
library(oce)
data(section)
SS <- TT <- pp <- id <- NULL
n <- length(section$data$station)
for (i in 1:n) {
	stn <- section$data$station[[i]] # save typing
	SS <- c(SS, stn$data$salinity)
	TT <- c(TT, stn$data$temperature)
	pp <- c(pp, stn$data$pressure)
	id <- c(id, rep(i, length(stn$data$pressure)))
}
ctd <- as.ctd(SS, TT, pp)
plot.TS(ctd, col=hsv(0.7*id/n), cex=2, pch=21)


###################################################
### chunk number 31: 
###################################################
library(oce)
data(a03)
Gulf.Stream <- subset(a03, indices=124:102)
dh <- sw.dynamic.height(Gulf.Stream)
par(mfrow=c(2,1))
plot(dh$distance, dh$height, type='b', xlab="", ylab="Dyn. Height [m]")
grid()
# 1e3 metres per kilometre
f <- coriolis(Gulf.Stream$data$station[[1]]$metadata$latitude)
g <- gravity(Gulf.Stream$data$station[[1]]$metadata$latitude)
v <- diff(dh$height)/diff(dh$distance) * g / f / 1e3
plot(dh$distance[-1], v, type='l', col="blue", xlab="Distance [km]", ylab="Velocity [m/s]")
grid()
abline(h=0)


###################################################
### chunk number 32: 
###################################################
library(oce)
data(sealevel.hal)
# Focus on 2003-Sep-28 to 29th, the time when Hurricane Juan caused flooding
plot(sealevel.hal,which=1,xlim=as.POSIXct(c("2003-09-24","2003-10-05"), tz="UTC"))
abline(v=as.POSIXct("2003-09-29 04:00:00", tz="UTC"), col="red")
mtext("Hurricane\nJuan", at=as.POSIXct("2003-09-29 04:00:00", tz="UTC"), col="red")


###################################################
### chunk number 33: 
###################################################
library(oce)
data(sealevel.hal)
spectrum(sealevel.hal$data$elevation, spans=c(3,7))
abline(v=1/12.42)
mtext("M2",at=1/12.42,side=3)


###################################################
### chunk number 34: 
###################################################
library(oce)
data(pt)
# First, get an idea for the data
plot(pt, which=c(1,3))

pt.trim.auto <- pt.trim(pt)
plot(pt.trim.auto)
print(range(pt.trim.auto$data$time)) # gives a starting point

abline(v=as.POSIXct("2008-06-25 00:00:00"),col="red")
abline(v=as.POSIXct("2008-06-26 00:00:00"),col="red")
abline(v=as.POSIXct("2008-06-25 15:00:00"),col="red")

abline(v=as.POSIXct("2008-07-04 00:00:00"),col="blue")
abline(v=as.POSIXct("2008-07-05 10:00:00"),col="blue")
abline(v=as.POSIXct("2008-07-04 12:00:00"),col="blue")
pt.trim <- subset(pt, as.POSIXct("2008-06-25 15:00:00") <= time &
                  time <= as.POSIXct("2008-07-04 12:00:00"))
print(pt.patm(pt)) # take 10.2dbar from this
pt.trim <- oce.edit(pt.trim, action="x$data$pressure <- x$data$pressure - 10.2", reason="remove atm pressure", person="DK")
plot(pt.trim)


