###################################################
### chunk number 1: prep
###################################################
options(width=90,digits=2)


###################################################
### chunk number 2:  eval=FALSE
###################################################
## vignette('vegdata')


###################################################
### chunk number 3: load
###################################################
library(vegdata)


###################################################
### chunk number 4: db
###################################################
db1 <- 'taxatest'


###################################################
### chunk number 5: metainfo eval=FALSE
###################################################
## ## Plot data
## tv.metainfo(db1, sysPath=TRUE)


###################################################
### chunk number 6: site.echo
###################################################
site <- tv.site(db1, sysPath=TRUE)


###################################################
### chunk number 7: obs
###################################################
## Load data
obs <- tv.obs(db1, sysPath=TRUE)
head(obs)


###################################################
### chunk number 8: tax
###################################################
tax('ACERNEG', sysPath=TRUE)
tax(27, tax=TRUE, sysPath=TRUE)


###################################################
### chunk number 9: taxval
###################################################
obs <- tv.taxval(db1, obs, sysPath=TRUE)


###################################################
### chunk number 10: taxatest1 eval=FALSE
###################################################
## tv.taxval('taxatest', sysPath=TRUE)                           
## tv.taxval('taxatest', concept='korneck1996', sysPath=TRUE)


###################################################
### chunk number 11: cover
###################################################
obs <- tv.coverperc(db1, obs, sysPath=TRUE)
head(obs)


###################################################
### chunk number 12: pseudo
###################################################
lc.1


###################################################
### chunk number 13: layer
###################################################
veg <- tv.veg(db1, lc = "sum", comb = list(lc.1,c('LAYER')), dec = 1, quiet=TRUE, sysPath=TRUE)


###################################################
### chunk number 14: layerdiff
###################################################
veg[,1:7]


###################################################
### chunk number 15: pres-abs
###################################################
veg[veg > 0] <- 1


###################################################
### chunk number 16: elbaue
###################################################
db2 <- 'elbaue'
veg <- tv.veg(db2, quiet=TRUE, sysPath=TRUE)
site <- tv.site(db2, sysPath=TRUE)


###################################################
### chunk number 17: metdb2 eval=FALSE
###################################################
## tv.metainfo(db2)


###################################################
### chunk number 18: cluster
###################################################
cluster <- rep(NA, nrow(site))
cluster[site$MGL < -100] <- 'dry'
cluster[site$MGL < -25 & site$MGL >= -100] <- 'wet'
cluster[site$MGL >= -25] <- 'very.wet'


###################################################
### chunk number 19: freqtab
###################################################
freqtab(veg, cluster, limit = 30, sort=c('dry', 'wet', 'very.wet'), relfr = TRUE, sysPath=TRUE)


###################################################
### chunk number 20: nmds
###################################################
## Data analyses
library(vegan)
veg.nmds <- metaMDS(veg, distance = "bray", trymax = 5, autotransform =FALSE, noshare = 1, expand = TRUE, trace = 2)
plot(veg.nmds)


###################################################
### chunk number 21: nmdsplotfun
###################################################
library(labdsv)
library(akima)
color = function(x)rev(topo.colors(x))
nmds.plot <- function(nmds, site, var1, var2, disp, ...) {
 lplot <- nrow(nmds$points);  lspc <- nrow(nmds$species)
 stems <- colSums(veg)
 filled.contour(interp(nmds$points[, 1], nmds$points[, 2], site[, var1]), ylim = c(-1, 1.1), xlim = c(-1.4, 1.4),
   color.palette = color, xlab = var1, ylab = var2, main = paste("NMDS of vegetation"),
    key.title = title(main = var1, cex.main = 0.8, line = 1, xpd = NA),
    plot.axes = { axis(1);  axis(2)
      points(veg.nmds$points[, 1], veg.nmds$points[, 2], xlab = "", ylab = "", cex= .5, col = 2, pch = '+')
      points(veg.nmds$species[, 1], veg.nmds$species[, 2], xlab = "", ylab = "", cex=.2, pch = 19)
      ordisurf(veg.nmds, site[, var2], col = 'black', choices = c(1, 2), add = TRUE)
      orditorp(veg.nmds, display = disp, pch = " ")
      legend("topright", paste("GAM of ", var2), col = 'black', lty = 1)
   }
  ,...)
}


###################################################
### chunk number 22: nmdsplot
###################################################
print(nmds.plot(veg.nmds, site, disp='species', var1="MGL", var2="SDGL"))


