###################################################
### chunk number 1: 
###################################################
options("digits"=4)
options("width"=70)
options("show.signif.stars" = FALSE)
set.seed(12345)


###################################################
### chunk number 2: 
###################################################
require(Amelia)
data(freetrade)


###################################################
### chunk number 3: 
###################################################
summary(freetrade)


###################################################
### chunk number 4: 
###################################################
summary(lm(tariff ~ polity + pop + gdp.pc + year + country, 
          data = freetrade)) 


###################################################
### chunk number 5: 
###################################################
a.out <- amelia(freetrade, m = 5, ts = "year", cs = "country")
a.out


###################################################
### chunk number 6: hist1plot
###################################################
hist(a.out$imputations[[3]]$tariff, col="grey", border="white")


###################################################
### chunk number 7: 
###################################################
options(SweaveHooks = list(fig = function() par(mfrow=c(1,1))))


###################################################
### chunk number 8: hist1
###################################################
hist(a.out$imputations[[3]]$tariff, col="grey", border="white")


###################################################
### chunk number 9: 
###################################################
a.out.more <- amelia(freetrade, m = 10, ts = "year", cs = "country", p2s=0)
a.out.more


###################################################
### chunk number 10: 
###################################################
a.out.more <- ameliabind(a.out, a.out.more)
a.out.more


###################################################
### chunk number 11: 
###################################################
amelia(freetrade, m = 1, ts = "year", cs = "country", p2s = 2)


###################################################
### chunk number 12: 
###################################################
table(a.out$imputations[[3]]$polity)


###################################################
### chunk number 13: 
###################################################
a.out1 <- amelia(freetrade, m = 5, ts = "year", cs = "country", ords =
                 "polity", p2s = 0)
table(a.out1$imputations[[3]]$polity)


###################################################
### chunk number 14: 
###################################################
table(a.out1$imputations[[3]]$signed)


###################################################
### chunk number 15: 
###################################################
a.out2 <- amelia(freetrade, m = 5, ts = "year", cs = "country", noms =
                 "signed", p2s = 0)
table(a.out2$imputations[[3]]$signed)


###################################################
### chunk number 16: logshist
###################################################
hist(freetrade$tariff, col="grey", border="white")
hist(log(freetrade$tariff), col="grey", border="white")


###################################################
### chunk number 17: 
###################################################
options(SweaveHooks = list(fig = function() par(mfrow=c(1,2))))


###################################################
### chunk number 18: hist2
###################################################
hist(freetrade$tariff, col="grey", border="white")
hist(log(freetrade$tariff), col="grey", border="white")


###################################################
### chunk number 19: 
###################################################
options(SweaveHooks = list(fig = function() par(mfrow=c(1,1))))


###################################################
### chunk number 20: 
###################################################
amelia(freetrade, idvars = c("year", "country"))


###################################################
### chunk number 21: 
###################################################
a.out2 <- amelia(freetrade, idvars = c("year"))


###################################################
### chunk number 22: 
###################################################
a.out2 <- amelia(freetrade, ts = "year", cs = "country", polytime = 2)


###################################################
### chunk number 23: 
###################################################
a.out.time <- amelia(freetrade, ts = "year", cs = "country", polytime = 2,
                 intercs = TRUE, p2s = 2)


###################################################
### chunk number 24: tcomp1
###################################################
tscsPlot(a.out, cs = "Malaysia", main = "Malaysia (no time settings)", 
         var = "tariff", ylim = c(-10, 60))

tscsPlot(a.out.time, cs = "Malaysia", main = "Malaysia (with time settings)", 
         var = "tariff", ylim = c(-10, 60))


###################################################
### chunk number 25: 
###################################################
options(SweaveHooks = list(fig = function() par(mfrow=c(1,2))))


###################################################
### chunk number 26: timecompare
###################################################
tscsPlot(a.out, cs = "Malaysia", main = "Malaysia (no time settings)", 
         var = "tariff", ylim = c(-10, 60))

tscsPlot(a.out.time, cs = "Malaysia", main = "Malaysia (with time settings)", 
         var = "tariff", ylim = c(-10, 60))


###################################################
### chunk number 27: 
###################################################
a.out2 <- amelia(freetrade, ts = "year", cs = "country", lags = "tariff",
                 leads = "tariff")


###################################################
### chunk number 28: 
###################################################
a.out.time


###################################################
### chunk number 29: 
###################################################
a.out.time2 <- amelia(freetrade, ts = "year", cs = "country", polytime = 2,
                 intercs = TRUE, p2s = 0, empri = .01*nrow(freetrade))
a.out.time2


###################################################
### chunk number 30: tcomp2
###################################################
tscsPlot(a.out.time, cs = "Malaysia", main = "Malaysia (no ridge prior)", 
         var = "tariff", ylim = c(-10, 60))

tscsPlot(a.out.time2, cs = "Malaysia", main = "Malaysia (with ridge prior)", 
         var = "tariff", ylim = c(-10, 60))


###################################################
### chunk number 31: 
###################################################
options(SweaveHooks = list(fig = function() par(mfrow=c(1,2))))


###################################################
### chunk number 32: timecomp2
###################################################
tscsPlot(a.out.time, cs = "Malaysia", main = "Malaysia (no ridge prior)", 
         var = "tariff", ylim = c(-10, 60))

tscsPlot(a.out.time2, cs = "Malaysia", main = "Malaysia (with ridge prior)", 
         var = "tariff", ylim = c(-10, 60))


###################################################
### chunk number 33: 
###################################################
freetrade[freetrade$country == "Thailand", c("year","country","tariff")]


###################################################
### chunk number 34:  eval=FALSE
###################################################
## #$


###################################################
### chunk number 35: 
###################################################
pr <- matrix(c(158,159,160,3,3,3,40,40,40,3,3,3), nrow=3, ncol=4) 
pr


###################################################
### chunk number 36: 
###################################################
a.out.pr <- amelia(freetrade, ts = "year", cs = "country", priors = pr)


###################################################
### chunk number 37: 
###################################################
pr.2 <- matrix(c(158,159,160,3,3,3,34,34,34,46,46,46,.95,.95,.95), nrow=3, ncol=5)
pr.2


###################################################
### chunk number 38: 
###################################################
pr.3 <- matrix(c(158,159,160,0,3,3,3,3,40,40,40,20,3,3,3,5), nrow=4, ncol=4)
pr.3


###################################################
### chunk number 39: 
###################################################
bds <- matrix(c(3, 30, 40), nrow = 1, ncol = 3)
bds


###################################################
### chunk number 40: 
###################################################
a.out.bds <- amelia(freetrade, ts = "year", cs = "country", bounds = bds,
                    max.resample = 1000)


###################################################
### chunk number 41: bounds
###################################################
tscsPlot(a.out, cs = "Malaysia", main = "No logical bounds", var =
         "tariff", ylim = c(-10,60))

tscsPlot(a.out.bds, cs = "Malaysia", main = "Bounded between 30 and 40", var =
         "tariff", ylim = c(-10,60))


###################################################
### chunk number 42: 
###################################################
options(SweaveHooks = list(fig = function() par(mfrow=c(1,2))))


###################################################
### chunk number 43: boundscomp
###################################################
tscsPlot(a.out, cs = "Malaysia", main = "No logical bounds", var =
         "tariff", ylim = c(-10,60))

tscsPlot(a.out.bds, cs = "Malaysia", main = "Bounded between 30 and 40", var =
         "tariff", ylim = c(-10,60))


###################################################
### chunk number 44: plotmeth
###################################################
plot(a.out, which.vars = 3:6)


###################################################
### chunk number 45: plot1
###################################################
plot(a.out, which.vars = 3:6)


###################################################
### chunk number 46: 
###################################################
compare.density(a.out, var = "signed")


###################################################
### chunk number 47: 
###################################################
options(SweaveHooks = list(fig = function() par(mfrow=c(1,1))))


###################################################
### chunk number 48: overimp
###################################################
overimpute(a.out, var = "tariff")


###################################################
### chunk number 49: 
###################################################
options(SweaveHooks = list(fig = function() par(mfrow=c(1,1))))


###################################################
### chunk number 50: oi2
###################################################
overimpute(a.out, var = "tariff")


###################################################
### chunk number 51: disp1d
###################################################
disperse(a.out, dims = 1, m = 5)
disperse(a.out, dims = 2, m = 5)


###################################################
### chunk number 52: 
###################################################
options(SweaveHooks = list(fig = function() par(mfrow=c(1,2))))


###################################################
### chunk number 53: disp1dfig
###################################################
disperse(a.out, dims = 1, m = 5)
disperse(a.out, dims = 2, m = 5)


###################################################
### chunk number 54: 
###################################################
freetrade2 <- freetrade
freetrade2$tariff2 <- freetrade2$tariff*2+3


###################################################
### chunk number 55: 
###################################################
a.out.bad <- amelia(freetrade2, ts = "year", cs = "country")
a.out.bad


###################################################
### chunk number 56: dispbad
###################################################
disperse(a.out.bad, dims = 1, m = 5)


###################################################
### chunk number 57: 
###################################################
options(SweaveHooks = list(fig = function() par(mfrow=c(1,1))))


###################################################
### chunk number 58: dispbadfig
###################################################
disperse(a.out.bad, dims = 1, m = 5)


###################################################
### chunk number 59: tsplot1
###################################################
tscsPlot(a.out.time, cs = "Malaysia", main = "Malaysia (with time settings)", 
         var = "tariff", ylim = c(-10, 60))


###################################################
### chunk number 60: tsplot2
###################################################
tscsPlot(a.out.time, cs = "Malaysia", main = "Malaysia (with time settings)", 
         var = "tariff", ylim = c(-10, 60))


###################################################
### chunk number 61: mmap1
###################################################
missmap(a.out) 


###################################################
### chunk number 62: mmap2
###################################################
missmap(a.out) 


###################################################
### chunk number 63: 
###################################################
require(Zelig)
z.out <- zelig(tariff ~ polity + pop + gdp.pc + year +country, data = freetrade, model = "ls")


###################################################
### chunk number 64: 
###################################################
summary(z.out)


###################################################
### chunk number 65: 
###################################################
z.out.imp <- zelig(tariff ~ polity + pop + gdp.pc + year +country, data =
                   a.out$imputations, model = "ls")


###################################################
### chunk number 66: 
###################################################
summary(z.out.imp)


