###################################################
### chunk number 1: 
###################################################
library("OAIHarvester")
baseurl <- "http://epub.wu.ac.at/cgi/oai2"


###################################################
### chunk number 2: 
###################################################
require("XML")
options(warnPartialMatchArgs = FALSE)
options(width = 80)


###################################################
### chunk number 3: 
###################################################
x <- oaih_identify(baseurl)
rbind(x, deparse.level = 0)


###################################################
### chunk number 4: 
###################################################
sapply(x$description, xmlName)


###################################################
### chunk number 5: 
###################################################
oaih_transform(x$description[[1L]])


###################################################
### chunk number 6: 
###################################################
oaih_list_metadata_formats(baseurl)
sets <- oaih_list_sets(baseurl)
rbind(head(sets, 3L), tail(sets, 3L))


###################################################
### chunk number 7: 
###################################################
spec <- unlist(sets[sets[, "setName"] == "Type = Thesis", "setSpec"])


###################################################
### chunk number 8: 
###################################################
x <- oaih_list_records(baseurl, set = spec)


###################################################
### chunk number 9: 
###################################################
dim(x)
colnames(x)


###################################################
### chunk number 10: 
###################################################
m <- x[, "metadata"]
m <- oaih_transform(m[sapply(m, length) > 0L])
dim(m)


###################################################
### chunk number 11: 
###################################################
colnames(m)


###################################################
### chunk number 12: 
###################################################
m[c(1L, 6L, 7L), "subject"]


###################################################
### chunk number 13: 
###################################################
sep <- "[[:space:]]*/[[:space:]]*"
keywords_by_thesis <-
    strsplit(unlist(lapply(m[, "subject"],  paste, collapse = " / ")),
             sep)
keywords <- unlist(keywords_by_thesis)


###################################################
### chunk number 14: 
###################################################
counts <- table(keywords)
table(counts)


###################################################
### chunk number 15: 
###################################################
sort(counts[counts >= 3L], decreasing = TRUE)


###################################################
### chunk number 16: 
###################################################
counts["R"]


###################################################
### chunk number 17: 
###################################################
lapply(m[sapply(keywords_by_thesis, function(kw) any(kw == "R")),
         c("title", "creator")],
       strwrap)


###################################################
### chunk number 18: 
###################################################
m[grep("^Feinerer", unlist(m[, "creator"])),
  c("title", "creator", "subject")]


