/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.sql.event;

import java.util.EventObject;
import weka.gui.sql.DbUtils;

public class ConnectionEvent
extends EventObject {
    public static final int CONNECT = 0;
    public static final int DISCONNECT = 1;
    protected int m_Type;
    protected DbUtils m_DbUtils;
    protected Exception m_Exception;

    public ConnectionEvent(Object object, int n, DbUtils dbUtils) {
        this(object, n, dbUtils, null);
    }

    public ConnectionEvent(Object object, int n, DbUtils dbUtils, Exception exception) {
        super(object);
        this.m_Type = n;
        this.m_DbUtils = dbUtils;
        this.m_Exception = exception;
    }

    public int getType() {
        return this.m_Type;
    }

    public boolean failed() {
        return this.getException() != null;
    }

    public boolean isConnected() {
        return this.m_DbUtils.isConnected();
    }

    public Exception getException() {
        return this.m_Exception;
    }

    public DbUtils getDbUtils() {
        return this.m_DbUtils;
    }

    public String toString() {
        String string = super.toString();
        string = string.substring(0, string.length() - 1);
        string = string + ",url=" + this.m_DbUtils.getDatabaseURL() + ",user=" + this.m_DbUtils.getUsername() + ",password=" + this.m_DbUtils.getPassword().replaceAll(".", "*") + ",connected=" + this.isConnected() + ",exception=" + this.getException() + "]";
        return string;
    }
}

