###################################################
### chunk number 1: 
###################################################
options(width = 75)
### for sampling
set.seed <- 1234


###################################################
### chunk number 2: 
###################################################
library("RKEA")


###################################################
### chunk number 3: 
###################################################
library("tm")
data("crude")

keywords <- list(c("Diamond", "crude oil", "price"),
                 c("OPEC", "oil", "price"),
                 c("Texaco", "oil", "price", "decrease"),
                 c("Marathon Petroleum", "crude", "decrease"),
                 c("Houston Oil", "revenues", "decrease"),
                 c("Kuwait", "OPEC", "quota"))

tmpdir <- tempfile()
dir.create(tmpdir)
model <- file.path(tmpdir, "crudeModel")

createModel(crude[1:6], keywords, model)


###################################################
### chunk number 4: 
###################################################
extractKeywords(crude, model)

unlink(tmpdir, recursive = TRUE)


