###################################################
### chunk number 1: cnet
###################################################
library(catnet)
cnet <- cnNew(
	nodes = c("a", "b", "c"),
	cats = list(c("1","2"), c("1","2"), c("1","2")), 
	parents = list(NULL, c(1), c(1,2)), 
	probs = list(	c(0.2,0.8), 
		list(c(0.6,0.4),c(0.4,0.6)), 
		list(list(c(0.3,0.7),c(0.7,0.3)), 
		list(c(0.9,0.1),c(0.1,0.9))))  )


###################################################
### chunk number 2: cnet1
###################################################
set.seed(123)
cnet1 <- cnRandomCatnet(numnodes=4, maxParents=2, numCategories=2)
cnet1


###################################################
### chunk number 3: cnet2
###################################################
bgraph <- FALSE
try(bgraph<-require(graph), TRUE)
if(bgraph) { 
	myNodes<-c("a","s","p","q","r","t","u")
	myEdges<-list(a=list(edges=NULL), s=list(edges=c("p","q")), p=list(edges=c("q")), q=list(edges=c("r")), r=list(edges=c("u")), t=list(edges=c("q")),u=list(edges=NULL))
	g<-new("graphNEL", nodes=myNodes,edgeL=myEdges,edgemode="directed")
	cnet2 <- cnCatnetFromGraph(g)
}


###################################################
### chunk number 4: cnet3
###################################################
#cnet3 <- cnCatnetFromSif(filename)
#cnet3


###################################################
### chunk number 5: simplefuns
###################################################
cnNumNodes(cnet1)
cnNodes(cnet1)
cnEdges(cnet1)
cnParents(cnet1)


###################################################
### chunk number 6: simplefuns2
###################################################
cnMatParents(cnet1)
cnMatEdges(cnet1)


###################################################
### chunk number 7: simplefuns3
###################################################
cnProb(cnet1)


###################################################
### chunk number 8: simplefuns4
###################################################
cnComplexity(cnet1)


###################################################
### chunk number 9: ex2
###################################################
cnOrder(cnet1)
cnOrder(cnet1@parents)


###################################################
### chunk number 10: ex4
###################################################
set.seed(456)
cnet2 <- cnRandomCatnet(numnodes=10, maxParents=3, numCategories=2)
cnEdges(cnet2)
pcnet2 <- dag2cpdag(cnet2)
cnEdges(pcnet2)


###################################################
### chunk number 11: ex5
###################################################
set.seed(456)
cnet3 <- cnRandomCatnet(cnNumNodes(cnet2), maxParents=2, numCategories=2)
cnet3@nodes <- cnet2@nodes
cnCompare(object1=cnet2, object2=cnet3)


###################################################
### chunk number 12: ex6
###################################################
samples1 <- cnSamples(object=cnet1, numsamples=100, output="matrix")
dim(samples1)
samples1 <- cnSamples(object=cnet1, numsamples=100, output="frame")
dim(samples1)


###################################################
### chunk number 13: ex7
###################################################
samples2 <- cnSamples(object=cnet1, numsamples=10, perturbations=c(0,0,1,2))


###################################################
### chunk number 14: ex8
###################################################
  ## generate a sample of size 12 and set the last 3 nodes as not-available
  numnodes <- cnNumNodes(cnet2)
  samples3 <- cnSamples(object=cnet2, numsamples=12, output="matrix")
  ## predict the last three nodes in 'cnet2' from the rest
  ## by setting their values in 'samples3' as NA
  samples3[numnodes-2, ] <- rep(NA, 12)
  samples3[numnodes-1, ] <- rep(NA, 12)
  samples3[numnodes, ] <- rep(NA, 12)
  ## predict the values of the last 3 nodes
  newsamples <- cnPredict(object=cnet2, data=samples3)


###################################################
### chunk number 15: ex12
###################################################
set.seed(789)
cnet2 <- cnRandomCatnet(numnodes=10, maxParents=2, numCategories=2)
nodeOrder <- order(runif(cnNumNodes(cnet2)))
cnet2
## generate a 100-size sample from cnet2
samples <- cnSamples(object=cnet2, numsamples=100, output="frame")
netlist <- cnSearchOrder(data=samples, perturbations=NULL, maxParentSet=2, maxComplexity=20, 
	nodeOrder, parentsPool=NULL, fixedParents=NULL)
## find the recostructed network with the true complexity
bnet <- cnFind(netlist, 20)
bnet


###################################################
### chunk number 16: ex14
###################################################
set.seed(123)
nnodes <- 12
cnet <- cnRandomCatnet(numnodes=nnodes, maxParents=5, numCategories=2)
norder <- cnOrder(cnet)
parPool <- vector("list", nnodes)
for(i in 1:nnodes) parPool[[i]] <- 1:(nnodes-1)
fixparPool <- vector("list", nnodes)
for(i in 3:nnodes) fixparPool[[i]] <- c(1,2)
samples <- cnSamples(cnet, numsamples=200)
eval <- cnSearchOrder(data=samples, perturbations=NULL, maxParentSet=2, maxComplexity=200, 
	nodeOrder=norder, parentsPool=parPool, fixedParents=fixparPool)
eval
## plot likelihood vs complexity for the resulting list of networks
plot(eval@complexity, eval@loglik, xlab="Complexity", ylab = "Log-likelihood", 
main="Model selection curve for the list of networks")


###################################################
### chunk number 17: ex16
###################################################
## generate a 1000-size sample from cnet
numsamples <- 500
samples <- cnSamples(object=cnet, numsamples, output="frame")
maxComplexity <- cnComplexity(cnet)
##perturbations <- as.data.frame(t(matrix(rep(0, cnet@numnodes*numsamples), nrow=cnet@numnodes)))
netlist <- cnEvaluate(object=cnet, data=samples, perturbations=NULL, maxComplexity)
## diagnostic plots
cnPlot(netlist)
## find the reconstructed network with the true complexity
bnet <- cnFind(netlist, maxComplexity)
bnet
cnCompare(cnet, bnet)
bnet2 <- cnFind(netlist, maxComplexity/2)
bnet2
cnCompare(cnet, bnet2)


###################################################
### chunk number 18: ex20
###################################################
set.seed(345)
## generate a 100-size sample from cnet6
cnet6 <- cnRandomCatnet(numnodes=12, maxParents=5, numCategories=2)
samples <- cnSamples(object=cnet6, numsamples=100, output="matrix")
eval <- cnSearchOrder(data=samples, perturbations=NULL, maxParentSet=2, parentSizes=NULL, maxComplexity=0, 
	nodeOrder=order(runif(1:dim(samples)[1])), parentsPool=NULL, fixedParents=NULL, 
	echo=FALSE)
## now select a network based on AIC and plot it
anet <- cnFindAIC(object=eval)
anet
## or BIC
bnet <- cnFindBIC(object=eval, numsamples=dim(samples)[2])
bnet
## plot likelihood vs complexity for the resulting list of networks
plot(eval@complexity, eval@loglik, 
xlab="Complexity", ylab = "Log-likelihood", 
main="Model selection: AIC and BIC complexities in red and blue.")
abline(v=anet@complexity,lty=2,col="red")
abline(v=bnet@complexity,lty=3,col="blue")


###################################################
### chunk number 19: ex18
###################################################
set.seed(345)
netlist <- cnSearchSA(data=samples, perturbations=NULL, 
	maxParentSet=2, parentSizes=NULL, maxComplexity=20, 
	parentsPool=NULL, fixedParents=NULL, 
	tempStart=1, tempCoolFact = 0.9, tempCheckOrders = 4, maxIter = 40, 
	orderShuffles = 1, stopDiff = 0.0001,
	priorSearch=NULL)
bnet <- cnFind(netlist@nets, cnComplexity(cnet))
bnet


###################################################
### chunk number 20: ex20
###################################################
set.seed(678)
numnodes <- 16
numcats <- 3
maxpars <- 2
cnet8 <- cnRandomCatnet(numnodes, maxpars, numcats)
ps <- cnSamples(cnet8, 500)
## next, a variable number of categories scanario is demonstrated
## find a node with descendants and reduce its number of categories
mpars <- cnMatParents(cnet8)
for(j in 1:numnodes)
	if(sum(mpars[,j]) > 0)
		break
if(j < numnodes)
	cnet8@categories[[j]] <- cnet8@categories[[j]][1:(numcats-1)]
## now resets cnet8's probability table
cnet8 <- cnSetProb(cnet8, ps)
## generate a new sample from the updated network
ps <- cnSamples(cnet8, 500)
res8 <- cnSearchOrder(data=ps, perturbations = NULL,
                      maxParentSet = maxpars, parentSizes = NULL, 
                      maxComplexity = 0,
                      nodeOrder = cnOrder(cnet8),  
                      parentsPool = NULL, fixedParents = NULL,
                      edgeProb = NULL, 
                      echo = FALSE)
anet8 <- cnFind(res8, cnComplexity(cnet8))
cnCompare(cnet8, anet8)
## perform a stochastic search with a prior that favors the true edges (given by mpars)
edgeHisto <- 0.5 + mpars / 4
res9 <- cnSearchSA(data=ps, perturbations=NULL,
                    maxParentSet=1, parentSizes = NULL, 
                    maxComplexity = 0,
                    parentsPool = NULL, fixedParents = NULL, edgeProb = edgeHisto, 
                    selectMode = "BIC", 
                    tempStart = 1, tempCoolFact = 0.9, tempCheckOrders = 20, 
                    maxIter = 100, orderShuffles = -1, stopDiff = 1,
                    numThreads = 2, 
                    priorSearch = NULL,
                    echo=FALSE)
anet9 <- cnFind(res9, cnComplexity(cnet8))
cnCompare(cnet8, anet9)


