###################################################
### chunk number 1: 
###################################################
options( prompt = "R> ", ctinue = "+  " )


###################################################
### chunk number 2: 
###################################################
library( "censReg" )


###################################################
### chunk number 3: 
###################################################
data( "Affairs", package = "AER" )


###################################################
### chunk number 4: 
###################################################
estResult <- censReg( affairs ~ age + yearsmarried + religiousness +
   occupation + rating, data = Affairs )


###################################################
### chunk number 5: 
###################################################
summary( estResult )


###################################################
### chunk number 6: 
###################################################
estResultMinus <- censReg( I( - affairs ) ~ age + yearsmarried + religiousness +
   occupation + rating, left = -Inf, right = 0, data = Affairs )


###################################################
### chunk number 7: 
###################################################
cbind( coef( estResult ), coef( estResultMinus ) )


###################################################
### chunk number 8: 
###################################################
set.seed( 123 )
pData <- data.frame(
   id = rep( paste( "F", 1:15, sep = "_" ), each = 4 ),
   time = rep( 1981:1984, 15 ) )
pData$mu <- rep( rnorm( 15 ), each = 4 )
pData$x1 <- rnorm( 60 )
pData$x2 <- runif( 60 )
pData$ys <- -1 + pData$mu + 2 * pData$x1 + 3 * pData$x2 + rnorm( 60 )
pData$y <- ifelse( pData$ys > 0, pData$ys, 0 )
library( plm )
pData <- pdata.frame( pData, c( "id", "time" ) )


###################################################
### chunk number 9: 
###################################################
system.time( panelResult <- censReg( y ~ x1 + x2, data = pData, method = "BHHH" ) )
summary( panelResult )


###################################################
### chunk number 10: 
###################################################
nGHQ <- 2^(2:6)
times <- numeric( length( nGHQ ) )
results <- list()
for( i in 1:length (nGHQ ) ) {
   times[i] <- system.time( results[[i]] <- censReg( y ~ x1 + x2, data = pData,
   method = "BHHH", nGHQ = nGHQ[i] ) )[1]
}
names(results)<-nGHQ
round( rbind(sapply( results, coef ),times),4)


