###################################################
### chunk number 1: 
###################################################
library(cgdsr)
# Create CGDS object
mycgds = CGDS("http://cbio.mskcc.org/cgds-public/")


###################################################
### chunk number 2: 
###################################################
# Test the CGDS endpoint URL using a few simple API tests
test(mycgds) 


###################################################
### chunk number 3: 
###################################################
# Get list of cancer types at server
getCancerTypes(mycgds)[,c(1,2)]


###################################################
### chunk number 4: 
###################################################
getGeneticProfiles(mycgds,'gbm')[,c(1:2)]


###################################################
### chunk number 5: 
###################################################
getCaseLists(mycgds,'gbm')[,c(1:2)]


###################################################
### chunk number 6: 
###################################################
getProfileData(mycgds, "NF1", c("gbm_cna_rae","gbm_mrna"), "gbm_all")[c(1:5),]


###################################################
### chunk number 7: 
###################################################
getProfileData(mycgds, c("MDM2","MDM4"), "gbm_mrna", "gbm_all")[c(1:5),]


###################################################
### chunk number 8: NF1plot1
###################################################
df = getProfileData(mycgds, "NF1", c("gbm_cna_rae","gbm_mrna"), "gbm_all")
head(df)
boxplot(df[,2] ~ df[,1], main="NF1 : CNA status vs mRNA expression", xlab="CNA status", ylab="mRNA expression", outpch = NA)
stripchart(df[,2] ~ df[,1], vertical=T, add=T, method="jitter",pch=1,col='red')


###################################################
### chunk number 9: NF1plot2
###################################################
plot(mycgds, "gbm", "NF1", c("gbm_cna_rae","gbm_mrna"), "gbm_all", skin = 'disc_cont')


###################################################
### chunk number 10: MDM2plot1
###################################################
df = getProfileData(mycgds, c("MDM2","MDM4"), "gbm_mrna", "gbm_all")
head(df)
plot(df, main="MDM2 and MDM4 mRNA expression", xlab="MDM2 mRNA expression", ylab="MDM4 mRNA expression")


###################################################
### chunk number 11: MDMplot2
###################################################
plot(mycgds, "gbm", c("MDM2","MDM4"), "gbm_mrna" ,"gbm_all")


###################################################
### chunk number 12: PTENplot
###################################################
df.pri = getProfileData(mycgds, "PTEN", "pca_mrna", "pca_primary")
head(df.pri)
df.met = getProfileData(mycgds, "PTEN", "pca_mrna", "pca_mets")
head(df.met)
boxplot(list(t(df.pri),t(df.met)), main="PTEN expression in primary and metastatic tumors", xlab="Tumor type", ylab="PTEN mRNA expression",names=c('primary','metastatic'), outpch = NA)
stripchart(list(t(df.pri),t(df.met)), vertical=T, add=T, method="jitter",pch=1,col='red')


