###################################################
### chunk number 1: 
###################################################
options(width = 60)
library("clue")


###################################################
### chunk number 2: 
###################################################
cl_class_ids.glvq <-
function(x)
    as.cl_class_ids(x$class_ids)
is.cl_partition.glvq <-
function(x)
    TRUE
is.cl_hard_partition.glvq <-
function(x)
    TRUE


###################################################
### chunk number 3: Cassini-data eval=FALSE
###################################################
## data("Cassini")
## plot(Cassini$x, col = as.integer(Cassini$classes),
##      xlab = "", ylab = "")


###################################################
### chunk number 4: 
###################################################
data("Cassini")
plot(Cassini$x, col = as.integer(Cassini$classes),
     xlab = "", ylab = "")


###################################################
### chunk number 5: CKME eval=FALSE
###################################################
## data("CKME")
## plot(hclust(cl_dissimilarity(CKME)), labels = FALSE)


###################################################
### chunk number 6: 
###################################################
data("CKME")
plot(hclust(cl_dissimilarity(CKME)), labels = FALSE)


###################################################
### chunk number 7: 
###################################################
m1 <- cl_medoid(CKME)
table(Medoid = cl_class_ids(m1), "True Classes" = Cassini$classes)


###################################################
### chunk number 8: Cassini-medoid eval=FALSE
###################################################
## plot(Cassini$x, col = cl_class_ids(m1), xlab = "", ylab = "")


###################################################
### chunk number 9: 
###################################################
plot(Cassini$x, col = cl_class_ids(m1), xlab = "", ylab = "")


###################################################
### chunk number 10: 
###################################################
set.seed(1234)
m2 <- cl_consensus(CKME)


###################################################
### chunk number 11: 
###################################################
table(Consensus = cl_class_ids(m2), "True Classes" = Cassini$classes)


###################################################
### chunk number 12: Cassini-mean eval=FALSE
###################################################
## plot(Cassini$x, col = cl_class_ids(m2), xlab = "", ylab = "")


###################################################
### chunk number 13: 
###################################################
plot(Cassini$x, col = cl_class_ids(m2), xlab = "", ylab = "")


###################################################
### chunk number 14: 
###################################################
data("GVME")
GVME
set.seed(1)
m1 <- cl_consensus(GVME, method = "GV1",
                   control = list(k = 3, verbose = TRUE))


###################################################
### chunk number 15: 
###################################################
mean(cl_dissimilarity(GVME, m1, "GV1") ^ 2)


###################################################
### chunk number 16: 
###################################################
data("GVME_Consensus")
m2 <- GVME_Consensus[["MF1/3"]]
mean(cl_dissimilarity(GVME, m2, "GV1") ^ 2)
table(CLUE = cl_class_ids(m1), GV2001 = cl_class_ids(m2))


###################################################
### chunk number 17: 
###################################################
set.seed(1)
m1 <- cl_consensus(GVME, method = "GV1",
                   control = list(k = 2, verbose = TRUE))


###################################################
### chunk number 18: 
###################################################
mean(cl_dissimilarity(GVME, m1, "GV1") ^ 2)
m2 <- GVME_Consensus[["MF1/2"]]
mean(cl_dissimilarity(GVME, m2, "GV1") ^ 2)


###################################################
### chunk number 19: 
###################################################
max(abs(cl_membership(m1) - cl_membership(m2)))


###################################################
### chunk number 20: 
###################################################
m3 <- cl_consensus(GVME, method = "GV1",
                   control = list(k = 2, verbose = TRUE))


###################################################
### chunk number 21: 
###################################################
table(GV1 = cl_class_ids(m1), Euclidean = cl_class_ids(m3))


###################################################
### chunk number 22: 
###################################################
rownames(m1)[cl_class_ids(m1) != cl_class_ids(m3)]


###################################################
### chunk number 23: 
###################################################
data("Kinship82")
Kinship82
set.seed(1)
m1 <- cl_consensus(Kinship82, method = "GV3",
                   control = list(k = 3, verbose = TRUE))


###################################################
### chunk number 24: 
###################################################
mean(cl_dissimilarity(Kinship82, m1, "comem") ^ 2)


###################################################
### chunk number 25: 
###################################################
data("Kinship82_Consensus")
m2 <- Kinship82_Consensus[["JMF"]]
mean(cl_dissimilarity(Kinship82, m2, "comem") ^ 2)


###################################################
### chunk number 26: 
###################################################
cl_dissimilarity(m1, m2, "comem")
table(CLUE = cl_class_ids(m1), GV2001 = cl_class_ids(m2))


###################################################
### chunk number 27: 
###################################################
cl_fuzziness(cl_ensemble(m1, m2))


###################################################
### chunk number 28: 
###################################################
data("Phonemes")
d <- as.dist(1 - Phonemes)


###################################################
### chunk number 29: 
###################################################
u <- ls_fit_ultrametric(d, control = list(verbose = TRUE))


###################################################
### chunk number 30: Phonemes eval=FALSE
###################################################
## plot(u)


###################################################
### chunk number 31: 
###################################################
plot(u)


###################################################
### chunk number 32: 
###################################################
round(cl_dissimilarity(d, u), 4)


###################################################
### chunk number 33: 
###################################################
hclust_methods <- c("ward", "single", "complete", "average", "mcquitty")
hens <- cl_ensemble(list = lapply(hclust_methods,
                                  function(m) hclust(d, m)))
names(hens) <- hclust_methods
round(sapply(hens, cl_dissimilarity, d), 4)


###################################################
### chunk number 34: 
###################################################
ahens <- c(L2opt = cl_ensemble(u), hens)
round(cl_dissimilarity(ahens, method = "gamma"), 2)


