###################################################
### chunk number 1: 
###################################################
library(nlstools)


###################################################
### chunk number 2: 
###################################################
data(survivalcurve2)
preview(formula=mafart, data=survivalcurve2,
start=list(p = 1, delta = 1, LOG10N0 = 7))


###################################################
### chunk number 3: 
###################################################
preview(formula=mafart, data=survivalcurve2,
start=list(p = 1, delta = 10, LOG10N0 = 7))


###################################################
### chunk number 4: 
###################################################
preview(formula=mafart, data=survivalcurve2,
start=list(p = 2, delta = 10, LOG10N0 = 7.5))


###################################################
### chunk number 5: 
###################################################
nlsmaf <- nls(mafart, survivalcurve2, list(p = 2, delta = 10, LOG10N0 = 7.5))
plotfit(nlsmaf,smooth=TRUE)


###################################################
### chunk number 6: 
###################################################
model <- LOG10N ~ LOG10N0 - (t/delta)^p
nlsmaf <- nls(model, survivalcurve2, list(p = 2, delta = 10, LOG10N0 = 7.5))


###################################################
### chunk number 7: 
###################################################
data(ross)
d6<-subset(ross, select = c(T, pH, aw, sqrtmumax))
nls6 <- nls(cpm_T_pH_aw, d6, list(muopt = 2, Tmin = 4,
Topt = 40, Tmax = 49,pHmin = 4, pHopt = 6.5, pHmax = 9,
awmin = 0.95, awopt = 0.995))
plotfit(nls6, variable = 1)


###################################################
### chunk number 8: 
###################################################
plotfit(nls6, variable = 2)


###################################################
### chunk number 9: 
###################################################
overview(nlsmaf)


###################################################
### chunk number 10: 
###################################################
resmaf<-nlsResiduals(nlsmaf)
plot(resmaf)


###################################################
### chunk number 11: 
###################################################
test.nlsResiduals(resmaf)


###################################################
### chunk number 12: 
###################################################
contmaf <- nlsContourRSS(nlsmaf)


###################################################
### chunk number 13: 
###################################################
plot(contmaf, col=FALSE, nlev=10)


###################################################
### chunk number 14: 
###################################################
rcmaf <- nlsConfRegions(nlsmaf, length=500, exp=1)


###################################################
### chunk number 15: 
###################################################
plot(rcmaf, bounds=T)


###################################################
### chunk number 16: 
###################################################
rcmaf <- nlsConfRegions(nlsmaf, length=500, exp=2)


###################################################
### chunk number 17: 
###################################################
plot(rcmaf,bounds=T)


###################################################
### chunk number 18: 
###################################################
rcmaf <- nlsConfRegions(nlsmaf, length=2000, exp=2)


###################################################
### chunk number 19: 
###################################################
plot(rcmaf, bounds=F)


###################################################
### chunk number 20: 
###################################################
plot(rcmaf$cr[,1], rcmaf$cr[,3], pch=16, xlab='p', ylab='LOG10N')
contour(contmaf$seqPara[, 1], contmaf$seqPara[, 3], contmaf$lrss[[2]], 
                labels = "", levels = contmaf$lrss95, lty = 1, col = "red",add=T,lwd=5)


###################################################
### chunk number 21: 
###################################################
jackmaf <- nlsJack(nlsmaf)


###################################################
### chunk number 22: 
###################################################
summary(jackmaf)


###################################################
### chunk number 23: 
###################################################
plot(jackmaf)


###################################################
### chunk number 24: 
###################################################
boomaf <- nlsBoot(nlsmaf, niter=2000) 


###################################################
### chunk number 25: 
###################################################
summary(boomaf)


###################################################
### chunk number 26: 
###################################################
plot(boomaf, type="pairs")


