###################################################
### chunk number 1: 
###################################################
options(width = 80)
library("registry")


###################################################
### chunk number 2: 
###################################################
library(registry)
R <- registry()
print(R)


###################################################
### chunk number 3: 
###################################################
checkAge <- function(x) stopifnot(is.na(x) || x > 0 && x < 100)


###################################################
### chunk number 4: 
###################################################
checkPhone <- function(x) stopifnot(!is.na(x$mobile) || !is.na(x$home))


###################################################
### chunk number 5: 
###################################################
R <- registry(registry_class = "Addressbook", entry_class = "Address",
              validity_FUN = checkPhone)


###################################################
### chunk number 6: 
###################################################
print.Addressbook <-
function(x, ...) {
    writeLines(sprintf("An address book with %i entries.\n", length(x)))
    invisible(x)
}
print(R)


###################################################
### chunk number 7: 
###################################################
R$set_field("last", type = "character", is_key = TRUE, index_FUN = match_partial_ignorecase)
R$set_field("first", type = "character", is_key = TRUE, index_FUN = match_partial_ignorecase)


###################################################
### chunk number 8: 
###################################################
R$set_field("address", type = "character")


###################################################
### chunk number 9: 
###################################################
R$set_field("mobile", type = "character")
R$set_field("home", type = "character")


###################################################
### chunk number 10: 
###################################################
R$set_field("age", type = "integer", validity_FUN = checkAge)


###################################################
### chunk number 11: 
###################################################
R$set_field("type", type = "character",
            alternatives = c("Business", "Private"),
            default = "Business")


###################################################
### chunk number 12: 
###################################################
R$get_field("type")


###################################################
### chunk number 13: 
###################################################
R$set_entry(last = "Smith", first = "Mary", address = "Vienna",
            home = "734 43 34", type = "Private", age = 44L)
R$set_entry(last = "Smith", first = "Peter", address = "New York",
            mobile = "878 78 87")


###################################################
### chunk number 14: 
###################################################
R$set_entry("Myers", "John", "Washington", "52 32 34", "898 89 99",
            33L, "Business")


###################################################
### chunk number 15: 
###################################################
TRY <- function(expr) tryCatch(expr, error = print)
TRY(R$set_entry(last = "Smith", first = "Mary"))
TRY(R$set_entry(last = "Miller", first = "Henry"))
TRY(R$set_entry(last = "Miller", first = "Henry", age = 12.5))
TRY(R$set_entry(last = "Miller", first = "Henry", age = 999L))


###################################################
### chunk number 16: 
###################################################
R$get_entry(last = "Smith", first = "mar")


###################################################
### chunk number 17: 
###################################################
print.Address <- function(x) with(x,
    writeLines(sprintf("%s %s, %s; home: %s, mobile: %s; age: %i (%s)", first, last, address, home, mobile, age, type)))
R$get_entry(last = "Smith", first = "mar")


###################################################
### chunk number 18: 
###################################################
R[["Myers"]]


###################################################
### chunk number 19: 
###################################################
R$set_entry(last = "Frears", first = c("Joe", "Jonathan"),
            address = "Washington", home = "721 42 34")


###################################################
### chunk number 20: 
###################################################
identical(R[["Frears", "Jonathan"]], R[["Frears", "Joe"]])


###################################################
### chunk number 21: 
###################################################
R$get_entries("Smith")


###################################################
### chunk number 22: 
###################################################
R$grep_entries("Priv")


###################################################
### chunk number 23:  eval=FALSE
###################################################
## R$get_entries()
## R[]


###################################################
### chunk number 24: 
###################################################
summary(R)


###################################################
### chunk number 25: 
###################################################
R[["Smith", "Peter"]]
R$modify_entry(last = "Smith", first = "Peter", age = 22L)
R[["Smith", "Peter"]]


###################################################
### chunk number 26: 
###################################################
R$delete_entry(last = "Smith", first = "Peter")
R[["Smith", "Peter"]]


###################################################
### chunk number 27: 
###################################################
R$seal_entries()
TRY(R$delete_entry("Smith", "Mary"))
R$set_entry(last = "Slater", first = "Christian", address = "Boston",
            mobile = "766 23 88")
R[["Slater"]]


###################################################
### chunk number 28: 
###################################################
R$get_permissions()
R$restrict_permissions(delete_entries = FALSE)
TRY(R$delete_entry("Slater"))
R$modify_entry(last = "Slater", first = "Christian", age = 44L)
R[["Slater"]]


