###################################################
### chunk number 1: 
###################################################
options(width=70)


###################################################
### chunk number 2: 
###################################################
require(grDevices)
options(device = function(...) {     
.Call("R_GD_nullDevice", PACKAGE = "grDevices") 
}) 


###################################################
### chunk number 3: plotSetup
###################################################
par(mai=c(0,0,0.2,0),xaxs="i",yaxs="i")


###################################################
### chunk number 4: 
###################################################
require(rworldmap)
library(rworldmap)


###################################################
### chunk number 5: showExampleCountryData
###################################################
data(countryExData)
countryExData[5:10,1:5]


###################################################
### chunk number 6: joinCountryData2Map1
###################################################
data(countryExData)
sPDF <- joinCountryData2Map( countryExData,
                           joinCode = "ISO3",
                           nameJoinColumn = "ISO3V10")


###################################################
### chunk number 7: mapCountryData1
###################################################
par(mai=c(0,0,0.2,0),xaxs="i",yaxs="i")
mapCountryData( sPDF, nameColumnToPlot="BIODIVERSITY" )


###################################################
### chunk number 8: mapCountryData2
###################################################
mapParams <- mapCountryData( sPDF, nameColumnToPlot="BIODIVERSITY", addLegend=FALSE )
do.call( addMapLegend, c(mapParams, legendWidth=0.5, legendMar = 2))


###################################################
### chunk number 9: mapGriddedData1
###################################################
par(mai=c(0,0,0.2,0),xaxs="i",yaxs="i")
data(gridExData)
mapGriddedData(gridExData)


###################################################
### chunk number 10: mapHalfDegreeGridToCountries1
###################################################
par(mai=c(0,0,0.2,0),xaxs="i",yaxs="i")
mapParams <- mapHalfDegreeGridToCountries(gridExData, addLegend=FALSE)
do.call( addMapLegend, c(mapParams, legendWidth=0.5, legendMar = 2))


###################################################
### chunk number 11: country2Region1
###################################################
#Using country2Region to calculate mean Environmental Health index in Stern regions.
sternEnvHealth <- country2Region(inFile=countryExData,
                nameDataColumn="ENVHEALTH",
                joinCode="ISO3",
                nameJoinColumn="ISO3V10",
                regionType="Stern",
                FUN="mean"
                )

print(sternEnvHealth)


###################################################
### chunk number 12: mapByRegion1
###################################################
par(mai=c(0,0,0.2,0),xaxs="i",yaxs="i")
mapByRegion(countryExData,
                        nameDataColumn="CLIMATE",
                        joinCode="ISO3",
                        nameJoinColumn="ISO3V10",
                        regionType="Stern",
                        FUN="mean"
                        )


###################################################
### chunk number 13: finalFigure1
###################################################
par(mai=c(0,0,0.2,0),xaxs="i",yaxs="i")

#joining the data to a map
sPDF <- joinCountryData2Map(countryExData,
              joinCode = "ISO3",
              nameJoinColumn = "ISO3V10",
              projection = "none",
              )            
#creating a user defined colour palette
op <- palette(c('green','yellow','orange','red')) 
#find quartile breaks
cutVector <- quantile(sPDF@data[["BIODIVERSITY"]],na.rm=TRUE)
#classify the data to a factor
sPDF@data[["BIOcategories"]] <- cut(sPDF@data[["BIODIVERSITY"]], cutVector, include.lowest=TRUE)
#rename the categories
levels(sPDF@data[["BIOcategories"]]) <- c('low', 'med', 'high', 'vhigh')
#mapping
mapCountryData(sPDF, nameColumnToPlot='BIOcategories', catMethod='categorical', 
mapTitle='Biodiversity categories',colourPalette='palette', oceanCol='lightblue',
missingCountryCol='white')


###################################################
### chunk number 14: finalFigure2
###################################################
par(mai=c(0,0,0.2,0),xaxs="i",yaxs="i")
         
mapCountryData(sPDF, nameColumnToPlot='BIOcategories', catMethod='categorical', 
mapTitle='Biodiversity categories',colourPalette='palette', oceanCol='lightblue',
missingCountryCol='white', mapRegion='Eurasia', borderCol='black')

## At end of plotting, reset palette to previous settings:
palette(op)  



###################################################
### chunk number 15: bubblePlot
###################################################
par(mai=c(0,0,0.2,0),xaxs="i",yaxs="i")

mapBubbles(dF=getMap(), nameZSize="POP2005", nameZColour="REGION",colourPalette='rainbow', oceanCol='lightblue', landCol='wheat') 


###################################################
### chunk number 16: classInt_RColorBrewer
###################################################
par(mai=c(0,0,0.2,0),xaxs="i",yaxs="i")

library(classInt)
library(RColorBrewer)

#getting example data and joining to a map
data("countryExData",envir=environment(),package="rworldmap")
sPDF <- joinCountryData2Map(countryExData,joinCode = "ISO3",nameJoinColumn = "ISO3V10",mapResolution='coarse')

#getting class intervals using a 'jenks' classification in classInt package
classInt <- classIntervals( sPDF[["EPI"]], n=5, style="jenks")
catMethod = classInt[["brks"]]

#getting a colour scheme from the RColorBrewer package
colourPalette <- brewer.pal(5,'RdPu')

#calling mapCountryData with the parameters from classInt and RColorBrewer
mapParams <- mapCountryData(sPDF,nameColumnToPlot="EPI", addLegend=FALSE, catMethod = catMethod, colourPalette=colourPalette )
do.call(addMapLegend, c(mapParams,legendLabels="all",legendWidth=0.5,legendIntervals="data",legendMar = 2))


###################################################
### chunk number 17: margins
###################################################
oldPar <- par(mar=c(0, 0, 0, 0)) 
par(oldPar)


###################################################
### chunk number 18: layout1
###################################################

#set margins to zero for the subplots
oldPar <- par(mar=c(0, 0, 0, 0)) 
nPanels <- layout(cbind(c(0,1,2,3,4,5),c(0,6,7,8,9,10))
       ,heights=c(lcm(0.5),1,1,1,1,1)
       ,respect=F)      
       
layout.show(nPanels)
par(oldPar)


###################################################
### chunk number 19: layoutMonthly
###################################################

#set margins to zero for the subplots
oldPar <- par(mar=c(0, 0, 0, 0)) 
nPanels <- layout(rbind(c(0,0,0),c(1,2,3),c(4,5,6),c(7,8,9),c(10,11,12))
       ,heights=c(lcm(0.5),1,1,1,1)
       ,respect=F)    
       
layout.show(nPanels)
par(oldPar)


###################################################
### chunk number 20: linesLatLon
###################################################
abline(h=0) 
abline(v=0)   
abline(h=c(-20,20),lty=2,col='grey')  


