###################################################
### chunk number 1: 
###################################################
library(solaR)
oopt <- options() 
options("digits"=4) 
options("width"=80)


###################################################
### chunk number 2: 
###################################################
#Calculo para un único día 
BTd=fBTd(mode='serie')

lat=37.2
SolD<-fSolD(lat,BTd[100])
SolI<-fSolI(SolD, sample='hour', keep.night=FALSE)
head(SolI)


###################################################
### chunk number 3: 
###################################################
#Calculo para un varios días
SolD<-fSolD(lat,BTd[c(10, 50, 100)])
print(SolD)


###################################################
### chunk number 4: 
###################################################
lat=37.2;
SolD<-fSolD(lat,BTd=fBTd(mode='prom'))
SolI<-fSolI(SolD, sample='10 min', keep.night=FALSE)


###################################################
### chunk number 5: 
###################################################
mon=month.abb
p<-xyplot(r2d(AlS)~r2d(AzS),
    groups=month,
    data=SolI, type='l', col='black',
    xlab=expression(psi[s]),ylab=expression(gamma[s]))
plab=p+glayer(panel.text(0, y[x==0], mon[group.value], pos=4, cex=0.8))
print(plab)



###################################################
### chunk number 6: 
###################################################
BTd=fBTd(mode='serie')
solD <- fSolD(lat, BTd)
summary(solD)


###################################################
### chunk number 7: 
###################################################
p <- xyplot(solD$decl)
print(p)


###################################################
### chunk number 8: 
###################################################
BTd=fBTd(mode='serie')
SolD<-fSolD(lat, BTd[100])
SolI<-fSolI(SolD, sample='hour')

G0d=zoo(5000, index(SolD))
fCompD(SolD, G0d, corr = "Page") 
fCompD(SolD, G0d, corr = "CPR") 


###################################################
### chunk number 9: 
###################################################
lat=37.2;
G0dm=c(2.766,3.491,4.494,5.912,6.989,7.742,7.919,7.027,5.369,3.562,2.814,2.179)*1000; 
Rad=readG0dm(G0dm, lat)
solD<-fSolD(lat,fBTd(mode='prom'))
fCompD(solD, Rad, corr = 'Page') 


###################################################
### chunk number 10: 
###################################################
fKTd=function(x){(0.99*(x<=0.17))+(x>0.17)*(1.188-2.272*x+9.473*x^2-21.856*x^3+14.648*x^4)}
fCompD(SolD,G0d, corr="user",f=fKTd)


###################################################
### chunk number 11: 
###################################################
lat=37.2;
sol<-calcSol(lat, fBTd(mode='prom'), sample='hour', keep.night=FALSE)

G0dm=c(2.766,3.491,4.494,5.912,6.989,7.742,7.919,7.027,5.369,3.562,2.814,2.179)*1000;
Ta=c(10, 14.1, 15.6, 17.2, 19.3, 21.2, 28.4, 29.9, 24.3, 18.2, 17.2, 15.2)
BD<-readG0dm(G0dm=G0dm, Ta=Ta, lat=37.2)
compD<-fCompD(sol, BD, corr = 'Page') 
compI<-fCompI(sol, compD)


###################################################
### chunk number 12: 
###################################################
p <- xyplot(G0+B0+D0~w|month, data=compI, type='l',auto.key=list(space='right'))
print(p)


###################################################
### chunk number 13: 
###################################################
data(helios)
names(helios)=c('date', 'G0', 'TempMax', 'TempMin')

bd=df2Meteo(helios, dates.col='date', lat=41, source='helios-IES', format='%Y/%m/%d')

summary(getData(bd))


###################################################
### chunk number 14: 
###################################################
data(RedEstaciones)
Madrid<-subset(RedEstaciones,NomProv=='Madrid')
print(Madrid)


###################################################
### chunk number 15: 
###################################################
Aranjuez<-readMAPA(28,3,'01/01/2009','31/12/2009')


###################################################
### chunk number 16: 
###################################################
p=xyplot(G0~TempMedia|month, data=Aranjuez, type=c('p', 'r'))
print(p)


###################################################
### chunk number 17: 
###################################################
lat=41; 
sol=calcSol(lat, BTd=indexD(Aranjuez), sample='hour')
Temp<-fTemp(sol,Aranjuez)


###################################################
### chunk number 18: 
###################################################
wTemp=window(Temp, start=as.POSIXct('2009-03-01'), end=as.POSIXct('2009-03-31'))
p=xyplot(wTemp, col='black', ylab='T')+layer_(panel.xblocks(x, DoY, col=c('lightgray', 'white')))
print(p)


###################################################
### chunk number 19: 
###################################################
g0<-calcG0(lat=37.2,
	modeRad='mapa',
	mapa=list(prov=28,est=3,
	start='01/01/2009', end='31/12/2009'))
print(g0)


###################################################
### chunk number 20: 
###################################################
p=xyplot(g0)
print(p)


###################################################
### chunk number 21: 
###################################################
file='http://www.nrel.gov/midc/apps/plot.pl?site=LANAI&start=20090722&edy=19&emo=11&eyr=2010&zenloc=19&year=2010&month=11&day=1&endyear=2010&endmonth=11&endday=19&time=1&inst=3&inst=4&inst=5&inst=10&type=data&first=3&math=0&second=-1&value=0.0&global=-1&direct=-1&diffuse=-1&user=0&axis=1'

dat <- read.table(file, header=TRUE, sep=',')

lat=20.77
lon=-156.9339


###################################################
### chunk number 22: 
###################################################
names(dat) <- c('date', 'hour', 'G0', 'B', 'D0', 'Ta')
dat$B0 <- dat$G0-dat$D0


###################################################
### chunk number 23: 
###################################################
idxLocal <- with(dat, as.POSIXct(paste(date, hour), format='%m/%d/%Y %H:%M', tz='HST'))
idx <- local2Solar(idxLocal, lon=lon)


###################################################
### chunk number 24: 
###################################################
z <- zoo(dat[,c('G0', 'D0', 'B0', 'Ta')], idx)
NRELMeteo <- zoo2Meteo(z, lat=lat)


###################################################
### chunk number 25: 
###################################################
p <- xyplot(NRELMeteo)
print(p)


###################################################
### chunk number 26: 
###################################################
g0NREL <- calcG0(lat=lat, modeRad='bdI', bdI=NRELMeteo, corr='none')


###################################################
### chunk number 27: 
###################################################
g0BRL <- calcG0(lat=lat, modeRad='bdI', bdI=NRELMeteo, corr='BRL')


###################################################
### chunk number 28: 
###################################################
p <- xyplot(fd~kt, data=g0BRL, pch=19, alpha=0.3, cex=0.5)
print(p)


###################################################
### chunk number 29: 
###################################################
gef<-calcGef(lat=37.2, modeRad='prev', prev=g0, beta=30)
print(gef)


###################################################
### chunk number 30: 
###################################################
p<-xyplot(Gef/G~cosTheta|month, data=gef, type=c('p', 'smooth'), cex=0.4, alpha=0.5)
print(p)


###################################################
### chunk number 31: 
###################################################
G0dm=c(2766, 3491, 4494, 5912, 6989, 7742, 7919, 7027, 5369, 3562, 2814,
2179)
Ta=c(10, 14.1, 15.6, 17.2, 19.3, 21.2, 28.4, 29.9, 24.3, 18.2, 17.2, 15.2)
prom=list(G0dm=G0dm, Ta=Ta)


###################################################
### chunk number 32: 
###################################################
structHoriz=list(L=4.83);
distHoriz=data.frame(Lew=structHoriz$L*4,H=0);

gefBT=calcGef(lat=37.2, prom=prom, sample='10 min',
  modeTrk='horiz',
  modeShd='bt', betaLim=60,
  distances=distHoriz,
  struct=structHoriz)


###################################################
### chunk number 33: 
###################################################
p <- xyplot(r2d(Beta)~r2d(w),
     data=gefBT,
     type='l',
     xlab=expression(omega),
     ylab=expression(beta))
print(p)


###################################################
### chunk number 34: 
###################################################
inclin=data.frame(Gef=c(200,400,600,800,1000),Ta=25)
fProd(inclin)


###################################################
### chunk number 35: 
###################################################
inclin=data.frame(Gef=800,Ta=30)
gen1 = list(Nms = 10, Nmp = 11)
inv1=list(Ki = c(0.01,0.025,0.05), Pinv=25000, Vmin=420, Vmax=750, Gumb=20)
prod=fProd(inclin, generator=gen1, inverter=inv1)
print(prod)


###################################################
### chunk number 36: 
###################################################
with(prod,Vdc*Idc/(Vmpp*Impp))


###################################################
### chunk number 37: 
###################################################
lat=37.2;
G0dm=c(2766, 3491, 4494, 5912, 6989, 7742, 7919, 7027, 5369, 3562, 2814,
2179)
Ta=c(10, 14.1, 15.6, 17.2, 19.3, 21.2, 28.4, 29.9, 24.3, 18.2, 17.2, 15.2)
prom=list(G0dm=G0dm, Ta=Ta)


###################################################
### chunk number 38: 
###################################################
ProdFixed<-prodGCPV(lat=lat, prom=prom, keep.night=FALSE)
Prod2x<-prodGCPV(lat=lat, prom=prom, modeTrk='two', keep.night=FALSE)
ProdHoriz<-prodGCPV(lat=lat,prom=prom, modeTrk='horiz', keep.night=FALSE)


###################################################
### chunk number 39: 
###################################################
ComparePac<-CBIND(two=as.zooI(Prod2x)$Pac, 
     horiz=as.zooI(ProdHoriz)$Pac, 
     fixed=as.zooI(ProdFixed)$Pac)
AngSol=as.zooI(as(ProdFixed, 'Sol'))
ComparePac=CBIND(AngSol, ComparePac)
mon=month(index(ComparePac))

p=xyplot(two+horiz+fixed~AzS|mon, data=ComparePac,
     type='l', auto.key=list(space='right', lines=TRUE, points=FALSE),ylab='Pac')
print(p)


###################################################
### chunk number 40: 
###################################################
EstMadrid <- subset(RedEstaciones, NomProv=='Madrid')
nEstMadrid <- nrow(EstMadrid)
namesMadrid <- EstMadrid$NomEst

prodMadrid <- lapply(1:nEstMadrid,
                     function(x){try(prodGCPV(lat=41, modeRad='mapa',
                                                  mapa=list(prov=28, est=x,
                                                    start='01/01/2009', end='31/12/2010'))
                                     )})
names(prodMadrid) <- namesMadrid
okMadrid <- lapply(prodMadrid, class)!='try-error'
prodMadrid <- prodMadrid[okMadrid]


###################################################
### chunk number 41: 
###################################################
YfMadrid <- do.call(mergesolaR, prodMadrid)
summary(YfMadrid)


###################################################
### chunk number 42: 
###################################################
print(
      horizonplot(YfMadrid-rowMeans(YfMadrid),
            origin=0,
            scales=list(y=list(relation='same')),
            colorkey=TRUE)
      )


###################################################
### chunk number 43: 
###################################################
sol<-calcSol(lat=37.2, fBTd(mode='serie'), sample='10 min', keep.night=FALSE)
angGen<-fTheta(sol, beta=35);
Angles=CBIND(as.zooI(sol), angGen)

distances=data.frame(Lew=40,Lns=30,H=0)
struct=list(W=23.11, L=9.8, Nrow=2, Ncol=8)

ShdFactor<-fSombra6(Angles, distances, struct, prom=FALSE)

Angles$FS=ShdFactor


###################################################
### chunk number 44: 
###################################################
p <- levelplot(FS~w*day, data=Angles, par.settings=custom.theme(region=brewer.pal('YlOrBr', n=9)))
print(p)


###################################################
### chunk number 45: 
###################################################
distances=data.frame(Lew=c(-40,0,40,-40,40),Lns=c(30,30,30,0,0),H=0)
ShdFactor2<-fSombra6(Angles, distances, struct,prom=FALSE)

identical(coredata(ShdFactor), coredata(ShdFactor2))


###################################################
### chunk number 46: 
###################################################
struct2x=list(W=23.11, L=9.8, Nrow=2, Ncol=8)
dist2x=data.frame(Lew=40, Lns=30, H=0)

prod2xShd<-prodGCPV(lat=lat, prom=prom, modeTrk='two', 
    modeShd='area', struct=struct2x, distances=dist2x)


###################################################
### chunk number 47: 
###################################################
#Horizontal N-S tracker
structHoriz=list(L=4.83);
distHoriz=data.frame(Lew=structHoriz$L*4,H=0);

#Without Backtracking
prodHorizShd<-prodGCPV(lat=lat, prom=prom, sample='10 min', 
    modeTrk='horiz',
    modeShd='area', betaLim=60,
    distances=distHoriz,
    struct=structHoriz)


###################################################
### chunk number 48: 
###################################################
#With Backtracking
prodHorizBT<-prodGCPV(lat=lat, prom=prom, sample='10 min', 
    modeTrk='horiz',
    modeShd='bt', betaLim=60,
    distances=distHoriz,
    struct=structHoriz)


###################################################
### chunk number 49: 
###################################################
comp <- compare(ProdFixed, Prod2x, ProdHoriz, prod2xShd, prodHorizShd, prodHorizBT)
head(comp)


###################################################
### chunk number 50: 
###################################################
compL <- compareLosses(ProdFixed, Prod2x, ProdHoriz, prod2xShd, prodHorizShd, prodHorizBT)
head(compL)


###################################################
### chunk number 51: 
###################################################
lat=37.2;
G0dm=c(2766, 3491, 4494, 5912, 6989, 7742, 7919, 7027, 5369, 3562, 2814,
2179)
Ta=c(10, 14.1, 15.6, 17.2, 19.3, 21.2, 28.4, 29.9, 24.3, 18.2, 17.2, 15.2)
prom=list(G0dm=G0dm, Ta=Ta)


###################################################
### chunk number 52: 
###################################################
structHoriz=list(L=4.83);
distHoriz=list(Lew=structHoriz$L*c(2,5));

Shd12Horiz<-optimShd(lat=lat, prom=prom,
                     modeTrk='horiz',
                     betaLim=60,
                     distances=distHoriz, res=2,
                     struct=structHoriz,
                     modeShd='area',
                     prog=FALSE)


###################################################
### chunk number 53: 
###################################################
shadeplot(Shd12Horiz)


###################################################
### chunk number 54: 
###################################################
structFixed=list(L=5);
distFixed=list(D=structFixed$L*c(1,3));
Shd12Fixed<-optimShd(lat=lat, prom=prom,
                     modeTrk='fixed',
                     distances=distFixed, res=1,
                     struct=structFixed,
                     modeShd='area',
                     prog=FALSE)


###################################################
### chunk number 55: 
###################################################
shadeplot(Shd12Fixed)


###################################################
### chunk number 56: 
###################################################
struct2x=list(W=23.11, L=9.8, Nrow=2, Ncol=8)


###################################################
### chunk number 57: 
###################################################
dist2x=list(Lew=c(30,50),Lns=c(20,50))


###################################################
### chunk number 58: 
###################################################
ShdM2x<-optimShd(lat=lat, prom=prom, modeTrk='two', 
                 modeShd=c('area','prom'), distances=dist2x, struct=struct2x, 
                 res=5, prog=FALSE)


###################################################
### chunk number 59: 
###################################################
shadeplot(ShdM2x)


###################################################
### chunk number 60: 
###################################################
data(pumpCoef) 
CoefSP8A44<-subset(pumpCoef, Qn==8&stages==44)

fSP8A44<-fPump(pump=CoefSP8A44,H=40)


###################################################
### chunk number 61: 
###################################################
SP8A44=with(fSP8A44,{
		Pac=seq(lim[1],lim[2],by=100)
		Pb=fPb(Pac)
		etam=Pb/Pac
		Ph=fPh(Pac)
		etab=Ph/Pb
		f=fFreq(Pac)
		Q=fQ(Pac)
		result=data.frame(Q,Pac,Pb,Ph,etam,etab,f)})


SP8A44$etamb=with(SP8A44,etab*etam)



###################################################
### chunk number 62: 
###################################################
lab=c(expression(eta[motor]), expression(eta[pump]), expression(eta[mp]))
p<-xyplot(etam+etab+etamb~Pac,data=SP8A44,type='l', ylab='Eficiencia')
print(p+glayer(panel.text(x[1], y[1], lab[group.number], pos=3)))


###################################################
### chunk number 63: 
###################################################
lab=c(expression(P[pump]), expression(P[hyd]))
p<-xyplot(Pb+Ph~Pac,data=SP8A44,type='l', ylab='Power (W)', xlab='AC power (W)')
print(p+glayer(panel.text(x[length(x)], y[length(x)], lab[group.number], pos=3)))


###################################################
### chunk number 64: 
###################################################
Pg=seq(3000,5500,by=500);
H=seq(50,80,by=5);
NmgSP8A44<-NmgPVPS(pump=CoefSP8A44, Pg=Pg, H=H, Gd=6000,
     title='Selection of Pumps', theme=custom.theme())
print(NmgSP8A44$plot)


###################################################
### chunk number 65: 
###################################################
prodSP8A44<-prodPVPS(lat=41,
             modeRad='mapa',
             mapa=list(prov=28,est=3,
               start='01/01/2009', end='31/12/2009'),
             pump=CoefSP8A44, Pg=5500, H=50)
as.zooY(prodSP8A44)


###################################################
### chunk number 66: 
###################################################
p=xyplot(Q~Gef|month, data=prodSP8A44, 
  cex=0.5, type=c('p', 'smooth'), 
  col.symbol='gray', col.line='black')
print(p)


###################################################
### chunk number 67: 
###################################################
prodSP8A44Lim<-prodPVPS(lat, modeRad='prev', prev=prodSP8A44,
                        pump=CoefSP8A44, H=50, Pg=7000)  
as.zooY(prodSP8A44Lim)


###################################################
### chunk number 68: 
###################################################
p=xyplot(Q~Gef|month, data=prodSP8A44Lim, 
  cex=0.5, type=c('p', 'smooth'), 
  col.symbol='gray', col.line='black')
print(p)


###################################################
### chunk number 69: 
###################################################
compPVPS <- mergesolaR(prodSP8A44, prodSP8A44Lim)
print(xyplot(compPVPS, superpose=TRUE, ylab='Yf'))


###################################################
### chunk number 70: 
###################################################
data(prodEx)
prodStat<-analyzeData(prodEx)


###################################################
### chunk number 71: 
###################################################
dif<-prodEx-prodStat$stat$Median;

day=as.Date('2008-8-29')
p <- horizonplot(window(dif, start=day-60, end=day),
                 origin=0, layout=c(1, 22), 
                 colorkey=TRUE, colorkey.digits=1,
                 scales=list(y=list(relation="same")))

print(p)


###################################################
### chunk number 72: 
###################################################
ndays=c(5, 10, 15, 20)
palette=brewer.pal(n=length(ndays), name='Set1')
TDColor<-TargetDiagram(prodEx, end=day, ndays=ndays,
color=palette)
print(TDColor$plot)


###################################################
### chunk number 73: 
###################################################
TDMadrid <- TargetDiagram(YfMadrid, 
                    end=as.POSIXct('2010-12-31'), 
                    ndays=c(10, 20, 30, 40, 50, 60), cex=0.5)
print(TDMadrid$plot)


