###################################################
### chunk number 1:  eval=FALSE
###################################################
## A %over% B
## over(A, B)


###################################################
### chunk number 2:  eval=FALSE
###################################################
## A[B]


###################################################
### chunk number 3:  eval=FALSE
###################################################
## A[!is.na(over(A,B))]


###################################################
### chunk number 4: 
###################################################
library(sp)
x = c(0.5, 0.5, 1.2, 1.5)
y = c(1.5, 0.5, 0.5, 0.5)
xy = cbind(x,y)
dimnames(xy)[[1]] = c("a", "b", "c", "d")
pts = SpatialPoints(xy)

xpol = c(0,1,1,0,0)
ypol = c(0,0,1,1,0)
pol = SpatialPolygons(list(
	Polygons(list(Polygon(cbind(xpol-1.05,ypol))), ID="x1"),
	Polygons(list(Polygon(cbind(xpol,ypol))), ID="x2"),
	Polygons(list(Polygon(cbind(xpol,ypol-1.05))), ID="x3"),
	Polygons(list(Polygon(cbind(xpol+1.05,ypol))), ID="x4"),
	Polygons(list(Polygon(cbind(xpol+.4, ypol+.1))), ID="x5")
	))


###################################################
### chunk number 5: 
###################################################
plot(pol, xlim = c(-1.1, 2.1), ylim = c(-1.1, 1.6), border=2:6, axes=TRUE)
points(pts, col='red')
text(c(-1,0.1,0.1,1.1,0.45), c(0,0,-1,0,0.1), c("x1", "x2", "x3", "x4", "x5"))
text(coordinates(pts), pos=1, row.names(pts))


###################################################
### chunk number 6: 
###################################################
over(pts, pol)
over(pts, pol, returnList = TRUE)
pts[pol]

over(pol, pts)
over(pol, pts, returnList = TRUE)
row.names(pol[pts])


###################################################
### chunk number 7: 
###################################################
zdf = data.frame(z1 = 1:4, z2=4:1, f = c("a", "a", "b", "b"),
	row.names = c("a", "b", "c", "d"))
zdf
ptsdf = SpatialPointsDataFrame(pts, zdf)

zpl = data.frame(z = c(10, 15, 25, 3, 0), zz=1:5, 
	f = c("z", "q", "r", "z", "q"), row.names = c("x1", "x2", "x3", "x4", "x5"))
zpl
poldf = SpatialPolygonsDataFrame(pol, zpl)


###################################################
### chunk number 8: 
###################################################
over(pts, poldf)


###################################################
### chunk number 9: 
###################################################
over(pts, poldf[1:2], fn = mean)


###################################################
### chunk number 10: 
###################################################
over(pts, poldf, returnList = TRUE)


###################################################
### chunk number 11: 
###################################################
over(pol, ptsdf)
over(pol, ptsdf[1:2], fn = mean)


###################################################
### chunk number 12: 
###################################################
data(meuse.grid)
gridded(meuse.grid) = ~x+y
off = gridparameters(meuse.grid)$cellcentre.offset + 20
gt = GridTopology(off, c(400,400), c(8,11))
SG = SpatialGrid(gt)
agg = aggregate(meuse.grid[3], SG)


###################################################
### chunk number 13: 
###################################################
image(agg)
points(meuse.grid, pch = 3, cex=.2, col = "#80808080")


###################################################
### chunk number 14: 
###################################################
gt = GridTopology(c(.5,.5), c(1,1), c(3,2))
sg = SpatialGrid(gt)
df6 = data.frame(z = 6:1, f = c("a", "a", "b", "b", "c", "c"))
sgdf = SpatialGridDataFrame(gt, df6)
over(sg, pol)
over(sg, poldf)
over(sg, poldf[1:2])

spix = as(sg, "SpatialPixels")
spixdf = as(sgdf, "SpatialPixelsDataFrame")
over(spix, pol)
over(spix, poldf)
over(spix, poldf[1:2])

over(pol, sg)
over(pol, sgdf)
over(pol, sgdf[1], fn = mean)

over(pol, spix)
over(pol, spixdf)
over(pol, spixdf[1], fn = mean)

over(pts, sg)
over(pts, spix)
over(pts, sgdf)
over(pts, spixdf)

#over(pts, sg, returnList=TRUE)
#over(pts, spix, returnList=TRUE)
#over(pts, sgdf, returnList=TRUE)
#over(pts, spixdf, returnList=TRUE)

over(sg, sg)
over(sg, spix)
over(sg, sgdf)
over(sg, spixdf)

#over(sg, sg, returnList=TRUE)
#over(sg, spix, returnList=TRUE)
#over(sg, sgdf, returnList=TRUE)
#over(sg, spixdf, returnList=TRUE)

over(spix, sg)
over(spix, spix)
over(spix, sgdf)
over(spix, spixdf)

#over(spix, sg, returnList=TRUE)
#over(spix, spix, returnList=TRUE)
#over(spix, sgdf, returnList=TRUE)
#over(spix, spixdf, returnList=TRUE)


