###################################################
### chunk number 1: foo
###################################################
options(keep.source = TRUE, width = 60)
foo <- packageDescription("sugaR")


###################################################
### chunk number 2: glucoseSimple
###################################################
library(sugaR)
myGlucose<-list(
"20090426"=h("8:47 139,11:12 75,16:18 112,19:46 71,21:48 75",ncol=2),
"20090427"=h("8:00 212,12:12 291,13:49 236,15:42 291,17:42 112,19:15 74,20:35 202,22:39 139",ncol=2)
)
sugar.over.time(myGlucose,symbol="circle")


###################################################
### chunk number 3: activities
###################################################
library(sugaR)
myGlucose<-list(
"20090426"=h("8:47 139,11:12 75,16:18 112,19:46 71,21:48 75",ncol=2),
"20090427"=h("8:00 212,12:12 291,13:49 236,15:42 291,17:42 112,19:15 74,20:35 202,22:39 139",ncol=2)
)
myActivities<-list(
  "20090426"=list(
      list(f=u("15:00"),t=u("16:15"),a=4,c="medium-crazy"),
      list(f=u("18:00"),t=u("19:15"),a=2,c="walking the dog")
  ),
  "20090427"=list(
      list(f=u("09:00"),t=u("11:30"),a=3,c="speedy inliner"),
      list(f=u("15:00"),t=u("17:00"),a=5,c="wild")
  )
)
sugar.over.time(data.glucose=myGlucose, data.activities=myActivities)


###################################################
### chunk number 4: events
###################################################
library(sugaR)
myGlucose<-list(
"20090426"=h("8:47 139,11:12 75,16:18 112,19:46 71,21:48 75",ncol=2)
)
myEvents<-list(
  "20090426"=list(
      list(t=u("17:15"),e="catheter")
  )
)
sugar.over.time(data.glucose=myGlucose, data.events=myEvents)


###################################################
### chunk number 5: fig2
###################################################
library(sugaR)
data(diabetesDiary)
sugar.over.time(myGlucose,data.basal=NULL,myIntake,myActivities,represent.carbohydrates.by.area=TRUE,symbol="circle")


###################################################
### chunk number 6: fig1area
###################################################
library(sugaR)
data(diabetesDiary)
sugar.over.time(myGlucose,data.intake=myIntake,symbol="circle",represent.carbohydrates.by.area=FALSE)


###################################################
### chunk number 7: fig1thermometer
###################################################
library(sugaR)
data(diabetesDiary)
myIntake.noInsulin<-lapply(myIntake,function(X){X[,3]<-0;X[,4]<-0;X})
sugar.over.time(myGlucose,data.basal=NULL,data.intake=myIntake.noInsulin,symbol="thermometer")


###################################################
### chunk number 8: fig3
###################################################
library(sugaR)
data(diabetesDiary)
sugar.over.time(myGlucose,myBasal,myIntake,myActivities,symbol="circle",
	labels.language="english",labels.type="adults")


###################################################
### chunk number 9: fig4insulin
###################################################
library(sugaR)
data(diabetesDiary)
sugar.over.time(data.glucose=myGlucose, data.basal=NULL,
	data.intake=myIntake, data.activities=myActivities,
	data.factors=myFactors,
	symbol="thermometer",
	labels.language="german",labels.type="kids")


