###################################################
### chunk number 1: 
###################################################
#line 119 "d:/Rcompile/CRANpkg/local/2.12/AdMit/inst/doc/AdMit.Rnw"
rm(list = ls())
library("AdMit")
options(digits = 4, max.print = 40, prompt = "R> ", continue = "+   ")


###################################################
### chunk number 2: 
###################################################
#line 606 "d:/Rcompile/CRANpkg/local/2.12/AdMit/inst/doc/AdMit.Rnw"
GelmanMeng <- function(x, A = 1, B = 0, C1 = 3, C2 = 3, log = TRUE)
{
  if (is.vector(x))
    x <- matrix(x, nrow = 1)
  r <- -0.5 * (A * x[,1]^2 * x[,2]^2 + x[,1]^2 + x[,2]^2 - 2 * B * x[,1] * x[,2] - 2 * C1 * x[,1] - 2 * C2 * x[,2])
  if (!log)
    r <- exp(r)
  as.vector(r)
}


###################################################
### chunk number 3: 
###################################################
#line 622 "d:/Rcompile/CRANpkg/local/2.12/AdMit/inst/doc/AdMit.Rnw"
PlotGelmanMeng <- function(x1, x2)
{
  GelmanMeng(cbind(x1, x2), log = FALSE)
}
x1 <- x2 <- seq(from = -1.0, to = 6.0, by = 0.05)
z <- outer(x1, x2, FUN = PlotGelmanMeng)
image(x1, x2, z, las = 1, col = gray((20:0)/20),
      cex.axis = 1.1, cex.lab = 1.2,
      xlab = expression(X[1]), ylab = expression(X[2]))
box()
abline(a = 0, b = 1, lty = "dotted")


###################################################
### chunk number 4: 
###################################################
#line 640 "d:/Rcompile/CRANpkg/local/2.12/AdMit/inst/doc/AdMit.Rnw"
PlotGelmanMeng <- function(x1, x2)
{
  GelmanMeng(cbind(x1, x2), log = FALSE)
}
x1 <- x2 <- seq(from = -1.0, to = 6.0, by = 0.05)
z <- outer(x1, x2, FUN = PlotGelmanMeng)
image(x1, x2, z, las = 1, col = gray((20:0)/20),
      cex.axis = 1.1, cex.lab = 1.2,
      xlab = expression(X[1]), ylab = expression(X[2]))
box()
abline(a = 0, b = 1, lty = "dotted")


###################################################
### chunk number 5: 
###################################################
#line 662 "d:/Rcompile/CRANpkg/local/2.12/AdMit/inst/doc/AdMit.Rnw"
set.seed(1234)
outAdMit <- AdMit(KERNEL = GelmanMeng, mu0 = c(0.0, 0.1))
print(outAdMit)


###################################################
### chunk number 6: 
###################################################
#line 702 "d:/Rcompile/CRANpkg/local/2.12/AdMit/inst/doc/AdMit.Rnw"
PlotMit <- function(x1, x2, mit)
{
  dMit(cbind(x1, x2), mit = mit, log = FALSE)
}
z <- outer(x1, x2, FUN = PlotMit, mit = outAdMit$mit)
image(x1, x2, z, las = 1, col = gray((20:0)/20),
      cex.axis = 1.1, cex.lab = 1.2,
      xlab = expression(X[1]), ylab = expression(X[2]))
box()
abline(a = 0, b = 1, lty = "dotted")


###################################################
### chunk number 7: 
###################################################
#line 717 "d:/Rcompile/CRANpkg/local/2.12/AdMit/inst/doc/AdMit.Rnw"
PlotMit <- function(x1, x2, mit)
{
  dMit(cbind(x1, x2), mit = mit, log = FALSE)
}
z <- outer(x1, x2, FUN = PlotMit, mit = outAdMit$mit)
image(x1, x2, z, las = 1, col = gray((20:0)/20),
      cex.axis = 1.1, cex.lab = 1.2,
      xlab = expression(X[1]), ylab = expression(X[2]))
box()
abline(a = 0, b = 1, lty = "dotted")


###################################################
### chunk number 8: 
###################################################
#line 738 "d:/Rcompile/CRANpkg/local/2.12/AdMit/inst/doc/AdMit.Rnw"
par(mfrow = c(2,2))
for (h in 1:4)
{
  mith <- list(p = 1,
               mu = outAdMit$mit$mu[h,,drop = FALSE],
               Sigma = outAdMit$mit$Sigma[h,,drop = FALSE],
               df = outAdMit$mit$df)
  z <- outer(x1, x2, FUN = PlotMit, mit = mith)
  image(x1, x2, z, las = 1, col = gray((20:0)/20),
        cex.axis = 1.1, cex.lab = 1.2,
        xlab = expression(X[1]), ylab = expression(X[2]))
  box()
  abline(a = 0, b = 1, lty = "dotted")
  title(main = paste("component nr.", h))
}


###################################################
### chunk number 9: 
###################################################
#line 759 "d:/Rcompile/CRANpkg/local/2.12/AdMit/inst/doc/AdMit.Rnw"
par(mfrow = c(2,2))
for (h in 1:4)
{
  mith <- list(p = 1,
               mu = outAdMit$mit$mu[h,,drop = FALSE],
               Sigma = outAdMit$mit$Sigma[h,,drop = FALSE],
               df = outAdMit$mit$df)
  z <- outer(x1, x2, FUN = PlotMit, mit = mith)
  image(x1, x2, z, las = 1, col = gray((20:0)/20),
        cex.axis = 1.1, cex.lab = 1.2,
        xlab = expression(X[1]), ylab = expression(X[2]))
  box()
  abline(a = 0, b = 1, lty = "dotted")
  title(main = paste("component nr.", h))
}


###################################################
### chunk number 10: 
###################################################
#line 804 "d:/Rcompile/CRANpkg/local/2.12/AdMit/inst/doc/AdMit.Rnw"
set.seed(1234)
outAdMitIS <- AdMitIS(KERNEL = GelmanMeng, mit = outAdMit$mit)
print(outAdMitIS)


###################################################
### chunk number 11: 
###################################################
#line 839 "d:/Rcompile/CRANpkg/local/2.12/AdMit/inst/doc/AdMit.Rnw"
G.cov <- function(theta, mu)
{
  G.cov_sub <- function(x)
    (x - mu) %*% t(x - mu)
  theta <- as.matrix(theta)
  tmp <- apply(theta, 1, G.cov_sub)
  if (length(mu) > 1)
    t(tmp)
  else
    as.matrix(tmp)
}


###################################################
### chunk number 12: 
###################################################
#line 853 "d:/Rcompile/CRANpkg/local/2.12/AdMit/inst/doc/AdMit.Rnw"
set.seed(1234)
outAdMitIS <- AdMitIS(KERNEL = GelmanMeng, G = G.cov, mit = outAdMit$mit, mu = c(1.459, 1.459))
print(outAdMitIS)
V <- matrix(outAdMitIS$ghat, 2, 2)
print(V)


###################################################
### chunk number 13: 
###################################################
#line 867 "d:/Rcompile/CRANpkg/local/2.12/AdMit/inst/doc/AdMit.Rnw"
cov2cor(V)


###################################################
### chunk number 14: 
###################################################
#line 887 "d:/Rcompile/CRANpkg/local/2.12/AdMit/inst/doc/AdMit.Rnw"
set.seed(1234)
outAdMitMH <- AdMitMH(KERNEL = GelmanMeng, mit = outAdMit$mit)
print(outAdMitMH)


###################################################
### chunk number 15: 
###################################################
#line 910 "d:/Rcompile/CRANpkg/local/2.12/AdMit/inst/doc/AdMit.Rnw"
library("coda")


###################################################
### chunk number 16: 
###################################################
#line 913 "d:/Rcompile/CRANpkg/local/2.12/AdMit/inst/doc/AdMit.Rnw"
draws <- as.mcmc(outAdMitMH$draws[1001:1e5,])
colnames(draws) <- c("X1", "X2")
summary(draws)$stat


###################################################
### chunk number 17: 
###################################################
#line 923 "d:/Rcompile/CRANpkg/local/2.12/AdMit/inst/doc/AdMit.Rnw"
summary(draws)$stat[,3]^2 / summary(draws)$stat[,4]^2


