###################################################
### chunk number 1: SetUp
###################################################
#line 72 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
library(ChemoSpec) # these are only needed for the automatic vignette build, which occurs 
library(mvbutils) # in a clean environment
if (!file.exists("graphics")) dir.create("graphics")


###################################################
### chunk number 2: Chunk1 eval=FALSE
###################################################
## #line 108 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
## source("My First ChemoSpec.R")


###################################################
### chunk number 3: Chunk2 eval=FALSE
###################################################
## #line 123 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
## getManyCsv(gr.crit = c("sspA", "sspB"), gr.cols = c("red3", "dodgerblue4"),
## freq.unit = "ppm", int.unit = "peak intensity", descrip = "Subspecies Study",
## out.file = "subspecies")


###################################################
### chunk number 4: Chunk3 eval=FALSE
###################################################
## #line 131 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
## SubspeciesNMR <- loadObject("subspecies.RData")


###################################################
### chunk number 5: Chunk4
###################################################
#line 167 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
par(mfrow = c(2,1), mar = c(3, 1, 2, 1))
display.brewer.pal(8, "Set1")
title(main = "ChemoSpec Primary Scheme")
display.brewer.pal(8, "Set2")
title(main = "ChemoSpec Pastel Scheme")
par(mfrow = c(1,1))


###################################################
### chunk number 6: Chunk5 eval=FALSE
###################################################
## #line 183 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
## sumSpectra(SubspeciesNMR)


###################################################
### chunk number 7: Chunk6
###################################################
#line 189 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
data(CuticleIR) # makes the data available
sumSpectra(CuticleIR)


###################################################
### chunk number 8: Chunk7
###################################################
#line 200 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
check4Gaps(CuticleIR$freq, CuticleIR$data[1,], plot = TRUE)


###################################################
### chunk number 9: Chunk8
###################################################
#line 213 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
plotSpectra(CuticleIR, title = "Cuticle IR Spectra Demo",
which = c(10, 11, 40, 41, 100, 101, 140, 141, 150, 151),
yrange = c(0, 10), offset = 0.8, lab.pos = 2000)


###################################################
### chunk number 10: Chunk9
###################################################
#line 225 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
grep("GE7", CuticleIR$names)


###################################################
### chunk number 11: Chunk10
###################################################
#line 235 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
plotSpectra(CuticleIR, title = "Cuticle IR Spectra: Detail of Hydrocarbon Region",
which = c(10, 40, 100, 151), amplify = 10.0, xlim = c(2750, 3000),
yrange = c(0, 5), offset = 0.1, lab.pos = 2775)


###################################################
### chunk number 12: Chunk11
###################################################
#line 249 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
noTC138 <- removeSample(CuticleIR, rem.sam = c("TC138"))
sumSpectra(noTC138)


###################################################
### chunk number 13: Chunk12
###################################################
#line 256 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
TE2 <- grep("TE2", CuticleIR$names)
CuticleIR$names[TE2] # gives the name(s) that contain "TE2"
TE2 # gives the corresponding indicies


###################################################
### chunk number 14: Chunk13
###################################################
#line 271 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
newTE2 <- grep("TE2\\>",  CuticleIR$names)
CuticleIR$names[newTE2] # gives the name(s) found
newTE2 # gives the corresponding indices


###################################################
### chunk number 15: Chunk14
###################################################
#line 290 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
specSurvey(CuticleIR, method = "iqr", title = "Cuticle IR Spectra")


###################################################
### chunk number 16: Chunk15
###################################################
#line 298 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
noOH <- removeFreq(CuticleIR, rem.freq = CuticleIR$freq > 3100)
sumSpectra(noOH)


###################################################
### chunk number 17: Chunk16
###################################################
#line 310 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
plotSpectra(noOH, title = "Cuticle IR Spectra, No Hydroxyl Peak?",
which = c(10, 40,  100,  140 , 150),
yrange = c(0, 5), offset = 0.8, lab.pos = 2000, xlim = c(500, 3600))


###################################################
### chunk number 18: Chunk17
###################################################
#line 322 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
normCIR <- normSpectra(CuticleIR)


###################################################
### chunk number 19: Chunk19
###################################################
#line 345 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
keep <- seq(1, 157, 6) # select every 6th spectrum
someCIR <- CuticleIR # make a copy of the original data
someCIR$names <- someCIR$names[keep] # modify each piece manually
someCIR$colors <- someCIR$colors[keep]
someCIR$groups <- someCIR$groups[keep]
someCIR$sym <- someCIR$sym[keep]
someCIR$alt.sym <- someCIR$alt.sym[keep]
someCIR$data <- someCIR$data[keep,] # samples in rows, freq in columns
chkSpectra(someCIR, confirm = TRUE) # make sure we didn't screw it up!
hcaSpectra(someCIR, title = "Every 6th Sample of CuticleIR")


###################################################
### chunk number 20: Chunk10
###################################################
#line 432 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
class <- classPCA(CuticleIR, choice = "noscale")
plotScores(CuticleIR, title = "Cuticle IR Spectra", class,
pcs = c(1,2), ellipse = "rob", tol = 0.01)


###################################################
### chunk number 21: Chunk21
###################################################
#line 444 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
robust <- robPCA(CuticleIR, choice = "noscale")
plotScores(CuticleIR, title = "Cuticle IR Spectra", robust,
pcs = c(1,2), ellipse = "rob", tol = 0.01)


###################################################
### chunk number 22: Chunk22
###################################################
#line 458 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
diagnostics <- pcaDiag(CuticleIR, class, pcs = 2, plot = "OD")


###################################################
### chunk number 23: Chunk23
###################################################
#line 468 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
diagnostics <- pcaDiag(CuticleIR, class, pcs = 2, plot = "SD")


###################################################
### chunk number 24: Chunk24
###################################################
#line 482 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
plotScree(class, title = "Cuticle IR Spectra")


###################################################
### chunk number 25: Chunk25
###################################################
#line 492 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
out <- pcaBoot(CuticleIR, pcs = 5, choice = "noscale")


###################################################
### chunk number 26: Chunk26 eval=FALSE
###################################################
## #line 502 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
## plotScoresRGL(CuticleIR, class, title = "Cuticle IR Spectra",
## leg.pos = "A", t.pos = "B") # not run - it's interactive!


###################################################
### chunk number 27: Chunk27
###################################################
#line 514 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
plotScores3D(CuticleIR, class, title = "Cuticle IR Spectra")


###################################################
### chunk number 28: Chunk28 eval=FALSE
###################################################
## #line 522 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
## plotScoresG(CuticleIR, class) # not run - it's interactive!


###################################################
### chunk number 29: Chunk29
###################################################
#line 532 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
plotLoadings(CuticleIR, class, title = "Cuticle IR Spectra",
loads = c(1, 2), ref = 1)


###################################################
### chunk number 30: Chunk30
###################################################
#line 548 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
plot2Loadings(CuticleIR, class, title = "Cuticle IR Spectra",
loads = c(1, 2), tol = 0.002)


###################################################
### chunk number 31: Chunk30a
###################################################
#line 559 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
spt <- sPlotSpectra(CuticleIR, class, title = "Cuticle IR Spectra", pc = 1)


###################################################
### chunk number 32: Chunk31 eval=FALSE
###################################################
## #line 567 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
## hcaScores(CuticleIR,  class, scores = c(1:5), title = "Cuticle IR Spectra",
## method = "complete")


###################################################
### chunk number 33: Chunk30b
###################################################
#line 598 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
# Split the existing "groups" element of the Spectra object
# into two new factors with two levels each
n.groups <-list(genotype = c("G", "T"), treatment = c("C", "E"))
NewIR <- splitSpectraGroups(CuticleIR, n.groups)
# run aovPCA & plot the first score plot
mats <-aovPCA(NewIR, fac = c("genotype", "treatment"))
apca1 <- aovPCAscores(NewIR, mats, plot = 1, ellipse = "rob")


###################################################
### chunk number 34: Chunk32
###################################################
#line 615 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
data(CuticleIR)
G.only <- removeSample(CuticleIR, rem.sam = c("TE", "TC"))
G.only <- conColScheme(G.only, new = c("red", "blue"))
sumSpectra(G.only)


###################################################
### chunk number 35: Chunk33 eval=FALSE
###################################################
## #line 626 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
## mclust3dSpectra(G.only, G.only.pca) # not run - it's interactive!


###################################################
### chunk number 36: Chunk34
###################################################
#line 636 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
G.only.pca <- classPCA(G.only)
plotScores(G.only, G.only.pca, title = "Two Genotypes (Controls)",
ellipse = "rob")


###################################################
### chunk number 37: Chunk35
###################################################
#line 648 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
model <- mclustSpectra(G.only, G.only.pca, plot = "BIC",
title = "Two Genotypes (Controls)")


###################################################
### chunk number 38: Chunk36
###################################################
#line 659 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
model <- mclustSpectra(G.only, G.only.pca, plot = "proj",
title = "Two Genotypes (Controls)")


###################################################
### chunk number 39: Chunk37
###################################################
#line 671 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
model <- mclustSpectra(G.only, G.only.pca, plot = "errors",
title = "Two Genotypes (Controls)", truth = G.only$groups)


###################################################
### chunk number 40: Chunk38
###################################################
#line 701 "d:/Rcompile/CRANpkg/local/2.12/ChemoSpec/inst/doc/ChemoSpec.Rnw"
require(mvbutils)
foodweb(where = "package:ChemoSpec", charlim = 30, cex = 0.75, lwd = 1)


