###################################################
### chunk number 1: 
###################################################
#line 32 "d:/Rcompile/CRANpkg/local/2.12/FFD/inst/doc/FFD-intro.Rnw"
set.seed(1504)
#options(width=70, prompt = "R> ", continue = "+  ", useFancyQuotes = FALSE)
options(width=70, prompt = "> ", continue = "   ", useFancyQuotes = FALSE)
ps.options(family="Times")
library("FFD")
data("sheepData")


###################################################
### chunk number 2: 
###################################################
#line 162 "d:/Rcompile/CRANpkg/local/2.12/FFD/inst/doc/FFD-intro.Rnw"
nVec <- 1:300
outVec <- computeAlpha(nAnimalVec = nVec, method = "individual", herdSensitivity = 0.7, intraHerdPrevalence = 0.2, diagSensitivity = 0.9)


###################################################
### chunk number 3: 
###################################################
#line 170 "d:/Rcompile/CRANpkg/local/2.12/FFD/inst/doc/FFD-intro.Rnw"
plot(nVec, 1-outVec, type = "l", xlab = "Herd size", ylab = "Herd sensitivity")
abline(h = 0.7, lty = 2, lwd = 2, col = "red")


###################################################
### chunk number 4: 
###################################################
#line 564 "d:/Rcompile/CRANpkg/local/2.12/FFD/inst/doc/FFD-intro.Rnw"
data(sheepData)
mySurvey <- surveyData(nAnimalVec = sheepData$nSheep,
    populationData = sheepData, designPrevalence = 0.002,
    alpha = 0.05, intraHerdPrevalence = 0.2,
    diagSensitivity = 0.9, costHerd = 30, costAnimal = 7)
summary(mySurvey)


###################################################
### chunk number 5: 
###################################################
#line 585 "d:/Rcompile/CRANpkg/local/2.12/FFD/inst/doc/FFD-intro.Rnw"
myIndSamplingSummary <- indSamplingSummary(survey.Data = mySurvey,
    stepSize = 0.05)
summary(myIndSamplingSummary)


###################################################
### chunk number 6: 
###################################################
#line 601 "d:/Rcompile/CRANpkg/local/2.12/FFD/inst/doc/FFD-intro.Rnw"
plot(myIndSamplingSummary)


###################################################
### chunk number 7: 
###################################################
#line 622 "d:/Rcompile/CRANpkg/local/2.12/FFD/inst/doc/FFD-intro.Rnw"
myIndSampling <- indSampling(survey.Data = mySurvey,
    herdSensitivity = 0.7)
summary(myIndSampling)


###################################################
### chunk number 8: 
###################################################
#line 638 "d:/Rcompile/CRANpkg/local/2.12/FFD/inst/doc/FFD-intro.Rnw"
myLtdSampleSummary <- ltdSamplingSummary(survey.Data = mySurvey,
    sampleSizeLtdMax = 30)
summary(myLtdSampleSummary)


###################################################
### chunk number 9: 
###################################################
#line 654 "d:/Rcompile/CRANpkg/local/2.12/FFD/inst/doc/FFD-intro.Rnw"
plot(myLtdSampleSummary)


###################################################
### chunk number 10: 
###################################################
#line 675 "d:/Rcompile/CRANpkg/local/2.12/FFD/inst/doc/FFD-intro.Rnw"
myLtdSampling <- ltdSampling(survey.Data = mySurvey, sampleSizeLtd = 7)
summary(myLtdSampling)


###################################################
### chunk number 11: 
###################################################
#line 686 "d:/Rcompile/CRANpkg/local/2.12/FFD/inst/doc/FFD-intro.Rnw"
## Fixed sampling:
##################
sampleFixed <- sample(x = myIndSampling, size = "fixed")
## Sample Size:
length(sampleFixed$indexSample)
## Significance:
sampleFixed$aPostAlpha
## Sample:
head(sampleFixed$sample)

## Dynamic sampling:
####################
sampleDynamic <- sample(x = myIndSampling, size = "dynamic")
## Sample Size:
length(sampleDynamic$indexSample)
## Significance:
sampleDynamic$aPostAlpha
## Sample:
head(sampleFixed$sample)


###################################################
### chunk number 12: 
###################################################
#line 714 "d:/Rcompile/CRANpkg/local/2.12/FFD/inst/doc/FFD-intro.Rnw"
p.value <- computePValue(nPopulation = 15287, nSample = 1630,
    nDiseased = round(15287*0.002), sensitivity = 0.8633,
    specificity = 1)
p.value


###################################################
### chunk number 13: 
###################################################
#line 723 "d:/Rcompile/CRANpkg/local/2.12/FFD/inst/doc/FFD-intro.Rnw"
nSample <- computeOptimalSampleSize(nPopulation = 15287,
    prevalence = 0.002, alpha = 0.05, sensitivity = 0.8633,
    specificity = 1, lookupTable = FALSE)
nSample


###################################################
### chunk number 14: 
###################################################
#line 738 "d:/Rcompile/CRANpkg/local/2.12/FFD/inst/doc/FFD-intro.Rnw"
lookupTable <- computeOptimalSampleSize(nPopulation = max(sheepData$nSheep),
    prevalence = 0.2, alpha = 0.3, sensitivity = 0.9, specificity = 1,
    lookupTable = TRUE)
lookupTable


###################################################
### chunk number 15: 
###################################################
#line 752 "d:/Rcompile/CRANpkg/local/2.12/FFD/inst/doc/FFD-intro.Rnw"
alphaList <- computeAlphaLimitedSampling(stockSizeVector = sheepData$nSheep,
    sampleSizeLtd = 7, intraHerdPrevalence = 0.2, diagSensitivity = 0.9,
    diagSpecificity = 1)
str(alphaList$alphaDataFrame)
alphaList$meanAlpha


###################################################
### chunk number 16: 
###################################################
#line 770 "d:/Rcompile/CRANpkg/local/2.12/FFD/inst/doc/FFD-intro.Rnw"
sampleVec <- sample(sheepData$nSheep, 2550, replace = FALSE)
alphaVec <- computeAlpha(nAnimalVec = sampleVec, method = "limited",
    sampleSizeLtd = 9, intraHerdPrevalence = 0.2, diagSensitivity = 0.9)

system.time({
errorExact <- computeAposterioriError(alphaErrorVector = alphaVec,
    nPopulation = 5000, nDiseased = 5, method = "exact")
})
errorExact

system.time({
errorApprox <- computeAposterioriError(alphaErrorVector = alphaVec,
    nPopulation = 5000, nDiseased = 5, method = "approx")
})
errorApprox


