/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.macro.Interpreter;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Font;

public class MemoryMonitor
implements PlugIn {
    int width = 200;
    int height = 75;
    long fps;
    long startTime;
    long elapsedTime;
    ImageProcessor ip;
    int frames;
    ImageCanvas ic;
    double[] mem;
    int index;
    long value;
    double max = 1.4794752E7;
    long maxMemory = IJ.maxMemory();

    public void run(String string) {
        if (Interpreter.isBatchMode()) {
            return;
        }
        if (IJ.altKeyDown()) {
            this.width = 640;
            this.height = 480;
        }
        this.ip = new ByteProcessor(this.width, this.height, new byte[this.width * this.height], null);
        this.ip.setColor(Color.white);
        this.ip.fill();
        this.ip.setColor(Color.black);
        this.ip.setFont(new Font("SansSerif", 0, 12));
        this.ip.setAntialiasedText(true);
        this.ip.snapshot();
        ImagePlus imagePlus = new ImagePlus("Memory", this.ip);
        ImageWindow.centerNextImage();
        imagePlus.show();
        imagePlus.lock();
        ImageWindow imageWindow = imagePlus.getWindow();
        this.ic = imageWindow.getCanvas();
        this.mem = new double[this.width + 1];
        Thread.currentThread().setPriority(1);
        this.startTime = System.currentTimeMillis();
        imageWindow.running = true;
        while (imageWindow.running) {
            this.updatePixels();
            this.showValue();
            imagePlus.updateAndDraw();
            if (this.width == 640) {
                Thread.yield();
            } else {
                IJ.wait(100);
            }
            ++this.frames;
        }
        imagePlus.unlock();
    }

    void showValue() {
        double d;
        double d2 = (double)this.value / 1048576.0;
        String string = IJ.d2s(d2, d2 > 50.0 ? 0 : 2) + "MB";
        if (this.maxMemory > 0L) {
            d = this.value * 100L / this.maxMemory;
            string = string + " (" + (d < 1.0 ? "<1" : IJ.d2s(d, 0)) + "%)";
        }
        if (this.width == 640) {
            this.elapsedTime = System.currentTimeMillis() - this.startTime;
            if (this.elapsedTime > 0L) {
                d = this.ic.getMagnification();
                this.fps = (long)(this.frames * 10000) / this.elapsedTime;
                string = string + ", " + this.fps / 10L + "." + this.fps % 10L + " fps";
            }
        }
        this.ip.moveTo(2, 15);
        this.ip.drawString(string);
    }

    void updatePixels() {
        double d = IJ.currentMemory();
        if (this.frames % 10 == 0) {
            this.value = (long)d;
        }
        if (d > 0.9 * this.max) {
            this.max *= 2.0;
        }
        this.mem[this.index++] = d;
        if (this.index == this.mem.length) {
            this.index = 0;
        }
        this.ip.setLineWidth(1);
        this.ip.reset();
        int n = this.index + 1;
        if (n == this.mem.length) {
            n = 0;
        }
        double d2 = (double)this.height / this.max;
        this.ip.moveTo(0, this.height - (int)(this.mem[n] * d2));
        for (int i = 1; i < this.width; ++i) {
            if (++n == this.mem.length) {
                n = 0;
            }
            this.ip.lineTo(i, this.height - (int)(this.mem[n] * d2));
        }
    }
}

