/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Arrow;
import ij.gui.ImageCanvas;
import ij.gui.Roi;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;

public class Filler
implements PlugInFilter,
Measurements {
    String arg;
    Roi roi;
    ImagePlus imp;
    int sliceCount;
    ImageProcessor mask;
    boolean isTextRoi;

    public int setup(String string, ImagePlus imagePlus) {
        this.arg = string;
        this.imp = imagePlus;
        if (imagePlus != null) {
            this.roi = imagePlus.getRoi();
        }
        this.isTextRoi = this.roi != null && this.roi instanceof TextRoi;
        IJ.register(Filler.class);
        int n = 1055;
        if (string.equals("clear")) {
            if (this.roi != null && this.roi.getType() == 10) {
                IJ.error("Clear", "Area selection required");
                return 4096;
            }
            if (this.isTextRoi || this.isLineSelection()) {
                return n;
            }
            return IJ.setupDialog(imagePlus, n + 64);
        }
        if (string.equals("draw")) {
            return IJ.setupDialog(imagePlus, n);
        }
        if (string.equals("label")) {
            if (Analyzer.firstParticle < Analyzer.lastParticle) {
                return n - 1024;
            }
            return n;
        }
        if (string.equals("outside")) {
            return IJ.setupDialog(imagePlus, n);
        }
        if (this.roi != null && this.roi.getType() == 10 && string.equals("fill")) {
            IJ.error("Fill", "Area selection required");
            return 4096;
        }
        return IJ.setupDialog(imagePlus, n + 64);
    }

    public void run(ImageProcessor imageProcessor) {
        if (this.arg.equals("clear")) {
            this.clear(imageProcessor);
        } else if (this.isTextRoi && (this.arg.equals("draw") || this.arg.equals("fill"))) {
            this.draw(imageProcessor);
        } else if (this.arg.equals("fill")) {
            this.fill(imageProcessor);
        } else if (this.arg.equals("draw")) {
            this.draw(imageProcessor);
        } else if (this.arg.equals("label")) {
            this.label(imageProcessor);
        } else if (this.arg.equals("outside")) {
            this.clearOutside(imageProcessor);
        }
    }

    boolean isLineSelection() {
        return this.roi != null && this.roi.isLine();
    }

    boolean isStraightLine() {
        return this.roi != null && this.roi.getType() == 5;
    }

    public void clear(ImageProcessor imageProcessor) {
        imageProcessor.setColor(Toolbar.getBackgroundColor());
        if (this.isLineSelection()) {
            if (this.isStraightLine() && this.roi.getStrokeWidth() > 1.0f) {
                imageProcessor.fillPolygon(this.roi.getPolygon());
            } else {
                this.roi.drawPixels();
            }
        } else {
            imageProcessor.fill();
        }
        imageProcessor.setColor(Toolbar.getForegroundColor());
    }

    public void fill(ImageProcessor imageProcessor) {
        imageProcessor.setColor(Toolbar.getForegroundColor());
        if (this.isLineSelection()) {
            if (this.isStraightLine() && this.roi.getStrokeWidth() > 1.0f && !(this.roi instanceof Arrow)) {
                imageProcessor.fillPolygon(this.roi.getPolygon());
            } else {
                this.roi.drawPixels(imageProcessor);
            }
        } else {
            imageProcessor.fill();
        }
    }

    public void draw(ImageProcessor imageProcessor) {
        imageProcessor.setColor(Toolbar.getForegroundColor());
        this.roi.drawPixels(imageProcessor);
        if (IJ.altKeyDown()) {
            this.drawLabel(imageProcessor);
        }
    }

    public void label(ImageProcessor imageProcessor) {
        if (Analyzer.getCounter() == 0) {
            IJ.error("Label", "Measurement counter is zero");
            return;
        }
        if (Analyzer.firstParticle < Analyzer.lastParticle) {
            this.drawParticleLabels(imageProcessor);
        } else {
            double d;
            imageProcessor.setColor(Toolbar.getForegroundColor());
            ImageCanvas imageCanvas = this.imp.getCanvas();
            if (imageCanvas != null && (d = imageCanvas.getMagnification()) < 1.0) {
                int n = 1;
                n = (int)((double)n / d);
                imageProcessor.setLineWidth(n);
            }
            this.roi.drawPixels(imageProcessor);
            imageProcessor.setLineWidth(1);
            this.drawLabel(imageProcessor);
        }
    }

    void drawParticleLabels(ImageProcessor imageProcessor) {
        ResultsTable resultsTable = ResultsTable.getResultsTable();
        int n = resultsTable.getCounter();
        int n2 = Analyzer.firstParticle;
        int n3 = Analyzer.lastParticle;
        if (n == 0 || n2 >= n || n3 >= n) {
            return;
        }
        if (!resultsTable.columnExists(6)) {
            IJ.error("Label", "\"Centroids\" required to label particles");
            return;
        }
        for (int i = n2; i <= n3; ++i) {
            int n4 = (int)resultsTable.getValueAsDouble(6, i);
            int n5 = (int)resultsTable.getValueAsDouble(7, i);
            this.drawLabel(this.imp, imageProcessor, i + 1, new Rectangle(n4, n5, 0, 0));
        }
    }

    void drawLabel(ImageProcessor imageProcessor) {
        int n = Analyzer.getCounter();
        if (n > 0 && this.roi != null) {
            this.drawLabel(this.imp, imageProcessor, n, this.roi.getBounds());
        }
    }

    public void drawLabel(ImagePlus imagePlus, ImageProcessor imageProcessor, int n, Rectangle rectangle) {
        double d;
        Color color;
        Color color2 = Toolbar.getForegroundColor();
        if (color2.equals(color = Toolbar.getBackgroundColor())) {
            color2 = Color.black;
            color = Color.white;
        }
        int n2 = 9;
        ImageCanvas imageCanvas = imagePlus.getCanvas();
        if (imageCanvas != null && (d = imageCanvas.getMagnification()) < 1.0) {
            n2 = (int)((double)n2 / d);
        }
        if (n2 == 9 && rectangle.width > 50 && rectangle.height > 50) {
            n2 = 12;
        }
        imageProcessor.setFont(new Font("SansSerif", 0, n2));
        String string = "" + n;
        int n3 = imageProcessor.getStringWidth(string);
        int n4 = rectangle.x + rectangle.width / 2 - n3 / 2;
        int n5 = rectangle.y + rectangle.height / 2 + Math.max(n2 / 2, 6);
        FontMetrics fontMetrics = imageProcessor.getFontMetrics();
        int n6 = fontMetrics.getHeight();
        imageProcessor.setColor(color);
        imageProcessor.setRoi(n4 - 1, n5 - n6 + 2, n3 + 1, n6 - 3);
        imageProcessor.fill();
        imageProcessor.resetRoi();
        imageProcessor.setColor(color2);
        imageProcessor.drawString(string, n4, n5);
    }

    public synchronized void clearOutside(ImageProcessor imageProcessor) {
        if (this.isLineSelection()) {
            IJ.error("\"Clear Outside\" does not work with line selections.");
            return;
        }
        ++this.sliceCount;
        Rectangle rectangle = imageProcessor.getRoi();
        if (this.mask == null) {
            this.makeMask(imageProcessor, rectangle);
        }
        imageProcessor.setColor(Toolbar.getBackgroundColor());
        int n = this.imp.getStackSize();
        if (n > 1) {
            imageProcessor.snapshot();
        }
        imageProcessor.fill();
        imageProcessor.reset(this.mask);
        int n2 = imageProcessor.getWidth();
        int n3 = imageProcessor.getHeight();
        imageProcessor.setRoi(0, 0, rectangle.x, n3);
        imageProcessor.fill();
        imageProcessor.setRoi(rectangle.x, 0, rectangle.width, rectangle.y);
        imageProcessor.fill();
        imageProcessor.setRoi(rectangle.x, rectangle.y + rectangle.height, rectangle.width, n3 - (rectangle.y + rectangle.height));
        imageProcessor.fill();
        imageProcessor.setRoi(rectangle.x + rectangle.width, 0, n2 - (rectangle.x + rectangle.width), n3);
        imageProcessor.fill();
        imageProcessor.setRoi(rectangle);
        if (this.sliceCount == n) {
            imageProcessor.setColor(Toolbar.getForegroundColor());
            Roi roi = this.imp.getRoi();
            this.imp.killRoi();
            this.imp.updateAndDraw();
            this.imp.setRoi(roi);
        }
    }

    public void makeMask(ImageProcessor imageProcessor, Rectangle rectangle) {
        this.mask = imageProcessor.getMask();
        if (this.mask == null) {
            this.mask = new ByteProcessor(rectangle.width, rectangle.height);
            this.mask.invert();
        } else {
            this.mask = this.mask.duplicate();
        }
        this.mask.invert();
    }
}

