###################################################
### chunk number 1: 
###################################################
#line 4 "d:/Rcompile/CRANpkg/local/2.12/RecordLinkage/inst/doc/BigData.rnw"
options(width=50)


###################################################
### chunk number 2: 
###################################################
#line 48 "d:/Rcompile/CRANpkg/local/2.12/RecordLinkage/inst/doc/BigData.rnw"
library(RecordLinkage)

showClass("RLBigData")
showClass("RLBigDataDedup")
showClass("RLBigDataLinkage")


###################################################
### chunk number 3: 
###################################################
#line 65 "d:/Rcompile/CRANpkg/local/2.12/RecordLinkage/inst/doc/BigData.rnw"
# deduplicate dataset with two blocking iterations and string comparison
data(RLdata500)
data(RLdata10000)
rpairs1 <- RLBigDataDedup(RLdata500, identity = identity.RLdata500, blockfld = list(1,3),
  strcmp = 1:4)

# link two datasets with phonetic code, exclude lname_c2
s1 <- 471:500
s2 <- sample(1:10000, 300)
identity2 <- c(identity.RLdata500[s1], rep(NaN, length(s2)))
dataset <- rbind(RLdata500[s1,], RLdata10000[s2,])
rpairs2 <- RLBigDataLinkage(RLdata500, dataset, identity1 = identity.RLdata500,
  identity2 = identity2, phonetic = 1:4, exclude = "lname_c2")


###################################################
### chunk number 4: 
###################################################
#line 94 "d:/Rcompile/CRANpkg/local/2.12/RecordLinkage/inst/doc/BigData.rnw"
rpairs1 <- begin(rpairs1)
nextPairs(rpairs1, 10)
clear(rpairs1)


###################################################
### chunk number 5: 
###################################################
#line 108 "d:/Rcompile/CRANpkg/local/2.12/RecordLinkage/inst/doc/BigData.rnw"
train <- getMinimalTrain(compare.dedup(RLdata500, identity = identity.RLdata500,
  blockfld = list(1,3)))
rpairs1 <- RLBigDataDedup(RLdata500, identity = identity.RLdata500)
classif <- trainSupv(train, "rpart", minsplit=2)
result <- classifySupv(classif, rpairs1)


###################################################
### chunk number 6: 
###################################################
#line 118 "d:/Rcompile/CRANpkg/local/2.12/RecordLinkage/inst/doc/BigData.rnw"
showClass("RLResult")


###################################################
### chunk number 7: 
###################################################
#line 123 "d:/Rcompile/CRANpkg/local/2.12/RecordLinkage/inst/doc/BigData.rnw"
getTable(result)
getErrorMeasures(result)


###################################################
### chunk number 8: 
###################################################
#line 136 "d:/Rcompile/CRANpkg/local/2.12/RecordLinkage/inst/doc/BigData.rnw"
rpairs1 <- epiWeights(rpairs1)
result <- epiClassify(rpairs1, 0.5)
getTable(result)


###################################################
### chunk number 9: 
###################################################
#line 168 "d:/Rcompile/CRANpkg/local/2.12/RecordLinkage/inst/doc/BigData.rnw"
getPairs(result, min.weight=0.7, filter.link="link")


###################################################
### chunk number 10: 
###################################################
#line 176 "d:/Rcompile/CRANpkg/local/2.12/RecordLinkage/inst/doc/BigData.rnw"
getFalsePos(result)
getFalseNeg(result)



