###################################################
### chunk number 1: 
###################################################
#line 73 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
options(width = 75)
### for sampling
set.seed <- 1234


###################################################
### chunk number 2: 
###################################################
#line 1135 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
library("arules")


###################################################
### chunk number 3: epub1
###################################################
#line 1139 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
data("Epub")
Epub


###################################################
### chunk number 4: epub2
###################################################
#line 1150 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
summary(Epub)


###################################################
### chunk number 5: 
###################################################
#line 1161 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
year <- strftime(as.POSIXlt(transactionInfo(Epub)[["TimeStamp"]]), "%Y")
table(year)


###################################################
### chunk number 6: 
###################################################
#line 1171 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
Epub2003 <- Epub[year == "2003"]
length(Epub2003)
image(Epub2003)


###################################################
### chunk number 7: epub
###################################################
#line 1178 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
print(image(Epub2003))


###################################################
### chunk number 8: 
###################################################
#line 1200 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
transactionInfo(Epub2003[size(Epub2003) > 20])


###################################################
### chunk number 9: 
###################################################
#line 1213 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
inspect(Epub2003[1:5])


###################################################
### chunk number 10: 
###################################################
#line 1220 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
as(Epub2003[1:5], "list")


###################################################
### chunk number 11: 
###################################################
#line 1227 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
EpubTidLists <- as(Epub, "tidLists")
EpubTidLists


###################################################
### chunk number 12: 
###################################################
#line 1236 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
as(EpubTidLists[1:3], "list") 


###################################################
### chunk number 13: data
###################################################
#line 1267 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
data("AdultUCI")
dim(AdultUCI)
AdultUCI[1:2,]


###################################################
### chunk number 14: 
###################################################
#line 1284 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
AdultUCI[["fnlwgt"]] <- NULL
AdultUCI[["education-num"]] <- NULL


###################################################
### chunk number 15: 
###################################################
#line 1302 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
AdultUCI[[ "age"]] <- ordered(cut(AdultUCI[[ "age"]], c(15,25,45,65,100)),
    labels = c("Young", "Middle-aged", "Senior", "Old"))

AdultUCI[[ "hours-per-week"]] <- ordered(cut(AdultUCI[[ "hours-per-week"]],
      c(0,25,40,60,168)),
    labels = c("Part-time", "Full-time", "Over-time", "Workaholic"))
			    
AdultUCI[[ "capital-gain"]] <- ordered(cut(AdultUCI[[ "capital-gain"]],
      c(-Inf,0,median(AdultUCI[[ "capital-gain"]][AdultUCI[[ "capital-gain"]]>0]),Inf)),
    labels = c("None", "Low", "High"))

AdultUCI[[ "capital-loss"]] <- ordered(cut(AdultUCI[[ "capital-loss"]],
      c(-Inf,0,
	median(AdultUCI[[ "capital-loss"]][AdultUCI[[ "capital-loss"]]>0]),Inf)),
    labels = c("none", "low", "high"))


###################################################
### chunk number 16: coerce
###################################################
#line 1324 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
Adult <- as(AdultUCI, "transactions")
Adult


###################################################
### chunk number 17: summary
###################################################
#line 1337 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
summary(Adult)


###################################################
### chunk number 18: itemFrequencyPlot eval=FALSE
###################################################
## #line 1354 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
## itemFrequencyPlot(Adult, support = 0.1, cex.names=0.8)


###################################################
### chunk number 19: 
###################################################
#line 1359 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
#line 1354 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw#from line#1359#"
itemFrequencyPlot(Adult, support = 0.1, cex.names=0.8)
#line 1360 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"


###################################################
### chunk number 20: apriori
###################################################
#line 1370 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
rules <- apriori(Adult, 
                 parameter = list(support = 0.01, confidence = 0.6))
rules


###################################################
### chunk number 21: summary
###################################################
#line 1400 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
summary(rules)


###################################################
### chunk number 22: rules
###################################################
#line 1410 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
rulesIncomeSmall <- subset(rules, subset = rhs %in% "income=small" & lift > 1.2)
rulesIncomeLarge <- subset(rules, subset = rhs %in% "income=large" & lift > 1.2)


###################################################
### chunk number 23: subset
###################################################
#line 1420 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
inspect(head(SORT(rulesIncomeSmall, by = "confidence"), n = 3))
inspect(head(SORT(rulesIncomeLarge, by = "confidence"), n = 3))


###################################################
### chunk number 24: write_rules eval=FALSE
###################################################
## #line 1440 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
## WRITE(rulesIncomeSmall, file = "data.csv", sep = ",", col.names = NA)


###################################################
### chunk number 25: pmml eval=FALSE
###################################################
## #line 1450 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
## library("pmml")
## rules_pmml <- pmml(rulesIncomeSmall)
## saveXML(rules_pmml, file = "data.xml")


###################################################
### chunk number 26: 
###################################################
#line 1486 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
data("Adult")
fsets <- eclat(Adult, parameter = list(support = 0.05), 
	control = list(verbose=FALSE))


###################################################
### chunk number 27: 
###################################################
#line 1497 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
singleItems <- fsets[size(items(fsets)) == 1]

## Get the col numbers we have support for
singleSupport <- quality(singleItems)$support
names(singleSupport) <- unlist(LIST(items(singleItems),
	    decode = FALSE))
head(singleSupport, n = 5)


###################################################
### chunk number 28: 
###################################################
#line 1513 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
itemsetList <- LIST(items(fsets), decode = FALSE)

allConfidence <- quality(fsets)$support / 
    sapply(itemsetList, function(x) 
    max(singleSupport[as.character(x)]))

quality(fsets) <- cbind(quality(fsets), allConfidence)


###################################################
### chunk number 29: 
###################################################
#line 1524 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
summary(fsets)


###################################################
### chunk number 30: 
###################################################
#line 1533 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
fsetsEducation <- subset(fsets, subset = items %pin% "education")
inspect(SORT(fsetsEducation[size(fsetsEducation)>1], 
	by = "allConfidence")[1 : 3])


###################################################
### chunk number 31: 
###################################################
#line 1549 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
data("Adult")
Adult


###################################################
### chunk number 32: 
###################################################
#line 1560 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
supp <- 0.05
epsilon <- 0.1
c <- 0.1

n <- -2 * log(c)/ (supp * epsilon^2)
n


###################################################
### chunk number 33: 
###################################################
#line 1575 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
AdultSample <- sample(Adult, n, replace = TRUE)


###################################################
### chunk number 34: itemFrequencyPlot2 eval=FALSE
###################################################
## #line 1588 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
## itemFrequencyPlot(AdultSample, population = Adult, support = supp,
##     cex.names = 0.7)


###################################################
### chunk number 35: 
###################################################
#line 1594 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
#line 1588 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw#from line#1594#"
itemFrequencyPlot(AdultSample, population = Adult, support = supp,
    cex.names = 0.7)
#line 1595 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"


###################################################
### chunk number 36: itemFrequencyPlot3 eval=FALSE
###################################################
## #line 1616 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
## itemFrequencyPlot(AdultSample, population = Adult, 
##     support = supp, lift = TRUE, 
##     cex.names = 0.9)


###################################################
### chunk number 37: 
###################################################
#line 1623 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
#line 1616 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw#from line#1623#"
itemFrequencyPlot(AdultSample, population = Adult, 
    support = supp, lift = TRUE, 
    cex.names = 0.9)
#line 1624 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"


###################################################
### chunk number 38: 
###################################################
#line 1635 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
time <- system.time(itemsets <- eclat(Adult, 
    parameter = list(support = supp), control = list(verbose = FALSE)))
time

timeSample <- system.time(itemsetsSample <- eclat(AdultSample, 
    parameter = list(support = supp), control = list(verbose = FALSE)))
timeSample


###################################################
### chunk number 39: 
###################################################
#line 1651 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
# speed up
time[1] / timeSample[1]


###################################################
### chunk number 40: 
###################################################
#line 1661 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
itemsets
itemsetsSample


###################################################
### chunk number 41: 
###################################################
#line 1671 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
match <- match(itemsets, itemsetsSample, nomatch = 0)
## remove no matches
sum(match>0) / length(itemsets)


###################################################
### chunk number 42: 
###################################################
#line 1683 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
summary(quality(itemsets[which(!match)])$support)
summary(quality(itemsetsSample[-match])$support)


###################################################
### chunk number 43: 
###################################################
#line 1694 "d:/Rcompile/CRANpkg/local/2.12/arules/inst/doc/arules.Rnw"
supportItemsets <- quality(itemsets[which(match > 0)])$support
supportSample <- quality(itemsetsSample[match])$support

accuracy <- 1 - abs(supportSample - supportItemsets) / supportItemsets

summary(accuracy)


