###################################################
### chunk number 1: setup
###################################################
#line 84 "d:/Rcompile/CRANpkg/local/2.12/aylmer/inst/doc/fishervig.Rnw"
ignore <- require(aylmer,quietly=TRUE)
ignore <- require(partitions,quietly=TRUE)


###################################################
### chunk number 2: load_iqd
###################################################
#line 358 "d:/Rcompile/CRANpkg/local/2.12/aylmer/inst/doc/fishervig.Rnw"
data(iqd)  # Table 1


###################################################
### chunk number 3: test_iqd
###################################################
#line 362 "d:/Rcompile/CRANpkg/local/2.12/aylmer/inst/doc/fishervig.Rnw"
jj <- aylmer.test(iqd)


###################################################
### chunk number 4: print_iqd
###################################################
#line 366 "d:/Rcompile/CRANpkg/local/2.12/aylmer/inst/doc/fishervig.Rnw"
jj


###################################################
### chunk number 5: test_iqd_alternative
###################################################
#line 384 "d:/Rcompile/CRANpkg/local/2.12/aylmer/inst/doc/fishervig.Rnw"
jj1 <- aylmer.test(iqd, alternative=function(x){x[1,1]})


###################################################
### chunk number 6: print_iqd_test
###################################################
#line 394 "d:/Rcompile/CRANpkg/local/2.12/aylmer/inst/doc/fishervig.Rnw"
jj1


###################################################
### chunk number 7: aylmerTestA
###################################################
#line 417 "d:/Rcompile/CRANpkg/local/2.12/aylmer/inst/doc/fishervig.Rnw"
shifts
aylmer.test(shifts)


###################################################
### chunk number 8: fisherA
###################################################
#line 426 "d:/Rcompile/CRANpkg/local/2.12/aylmer/inst/doc/fishervig.Rnw"
fisher.test(shifts[-1,  ])$p.value
fisher.test(shifts[  ,-3])$p.value


###################################################
### chunk number 9: loadIcons
###################################################
#line 504 "d:/Rcompile/CRANpkg/local/2.12/aylmer/inst/doc/fishervig.Rnw"
set.seed(0)
data(icons)


###################################################
### chunk number 10: useGood
###################################################
#line 509 "d:/Rcompile/CRANpkg/local/2.12/aylmer/inst/doc/fishervig.Rnw"
good(icons)


###################################################
### chunk number 11: calculateIconStats
###################################################
#line 516 "d:/Rcompile/CRANpkg/local/2.12/aylmer/inst/doc/fishervig.Rnw"
iconstats <- aylmer.test(icons, simulate.p.value=TRUE)


###################################################
### chunk number 12: printIconStats
###################################################
#line 526 "d:/Rcompile/CRANpkg/local/2.12/aylmer/inst/doc/fishervig.Rnw"
iconstats


###################################################
### chunk number 13: dataPurum
###################################################
#line 573 "d:/Rcompile/CRANpkg/local/2.12/aylmer/inst/doc/fishervig.Rnw"
data(purum)


###################################################
### chunk number 14: randomPurum
###################################################
#line 577 "d:/Rcompile/CRANpkg/local/2.12/aylmer/inst/doc/fishervig.Rnw"
set.seed(1)
rP <- randomprobs(purum,B=800)


###################################################
### chunk number 15: 
###################################################
#line 602 "d:/Rcompile/CRANpkg/local/2.12/aylmer/inst/doc/fishervig.Rnw"
g <- function(x) max(abs(x-t(x)),na.rm=TRUE)


###################################################
### chunk number 16: purum_gender
###################################################
#line 612 "d:/Rcompile/CRANpkg/local/2.12/aylmer/inst/doc/fishervig.Rnw"
set.seed(1)
jj7 <- aylmer.test(purum, alternative=g, simulate.p.value=TRUE,B=2000)


###################################################
### chunk number 17: print_iqd_test
###################################################
#line 622 "d:/Rcompile/CRANpkg/local/2.12/aylmer/inst/doc/fishervig.Rnw"
jj7


###################################################
### chunk number 18: plotPurum
###################################################
#line 632 "d:/Rcompile/CRANpkg/local/2.12/aylmer/inst/doc/fishervig.Rnw"
plot(rP, xlab="index", ylab="log(Prob)", type="o", pch=16, cex=0.4, axes=FALSE)
axis(side=1,pos=min(rP)-1)
axis(side=2,pos= -20)
val <-  -175.5185
segments(x0=0,x1=800,y0=val,y1=val,col="gray",lwd=2)
points(x = 1, y=rP[1],pch=16,cex=1.5)
text(x = 1, y=rP[1],"observation",pos=4)


###################################################
### chunk number 19: 
###################################################
#line 773 "d:/Rcompile/CRANpkg/local/2.12/aylmer/inst/doc/fishervig.Rnw"
data(frogs)


###################################################
### chunk number 20: CalculateFrogStats
###################################################
#line 777 "d:/Rcompile/CRANpkg/local/2.12/aylmer/inst/doc/fishervig.Rnw"
frogResults <- aylmer.test(frogs, simulate.p.value=TRUE,B=2000)


###################################################
### chunk number 21: printFrogStats
###################################################
#line 781 "d:/Rcompile/CRANpkg/local/2.12/aylmer/inst/doc/fishervig.Rnw"
frogResults


###################################################
### chunk number 22: printFrogsMatrix
###################################################
#line 793 "d:/Rcompile/CRANpkg/local/2.12/aylmer/inst/doc/fishervig.Rnw"
frogs.matrix


###################################################
### chunk number 23: 
###################################################
#line 920 "d:/Rcompile/CRANpkg/local/2.12/aylmer/inst/doc/fishervig.Rnw"
data(gear) # Table 6
aylmer.test(gear)


###################################################
### chunk number 24: calcGear
###################################################
#line 925 "d:/Rcompile/CRANpkg/local/2.12/aylmer/inst/doc/fishervig.Rnw"
jj <- aylmer.test(gear,alternative="less")$p.value
jj <- round(jj*1e8)/1e3


