###################################################
### chunk number 1: 
###################################################
#line 50 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
library(editrules)
library(deducorrect)


###################################################
### chunk number 2: 
###################################################
#line 210 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
(d <- data.frame(x=1,y=0,z=1))
E <- editmatrix("x==y-z")
sol <- correctSigns(E,d)
sol


###################################################
### chunk number 3: 
###################################################
#line 219 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
sol$corrected


###################################################
### chunk number 4: 
###################################################
#line 223 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
sol$corrections


###################################################
### chunk number 5: 
###################################################
#line 229 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
sol$status


###################################################
### chunk number 6: 
###################################################
#line 404 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
E <- editmatrix( c("X1 + X2 == X3"
                  ,"X2 == X4"
                  ,"X5 + X6 + X7 == X8"
                  ,"X3 + X8 == X9"
                  ,"X9 - X10 == X11"))


###################################################
### chunk number 7: 
###################################################
#line 412 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
(dat <- data.frame(t(c(12, 4, 15, 4, 3, 1, 8, 11, 27, 41, -13))))
violatedEdits(E,dat)


###################################################
### chunk number 8: 
###################################################
#line 420 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
set.seed(1)
sol <- correctRounding(E,dat)
cbind(sol$corrected, sol$status)
sol$corrections


###################################################
### chunk number 9: 
###################################################
#line 561 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
dat <- data.frame(x = 123, y = 192, z = 252)
(E <- editmatrix("z == x + y"))


###################################################
### chunk number 10: 
###################################################
#line 583 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
correctTypos(E, dat)$corrected


###################################################
### chunk number 11: 
###################################################
#line 590 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
E <- editmatrix( c("x1 + x2 == x3"
                  ,"x2 == x4"
                  ,"x5 + x6 + x7 == x8"
                  ,"x3 + x8 == x9"
                  ,"x9 - x10 == x11"))


###################################################
### chunk number 12: 
###################################################
#line 600 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
dat <-as.data.frame( matrix(c(
    1452, 116, 1568, 116, 323, 76, 12, 411,  1979, 1842, 137,
    1452, 116, 1568, 161, 323, 76, 12, 411,  1979, 1842, 137,
    1452, 116, 1568, 161, 323, 76, 12, 411, 19979, 1842, 137,
    1452, 116, 1568, 161,   0,  0,  0, 411, 19979, 1842, 137,
    1452, 116, 1568, 161, 323, 76, 12,   0, 19979, 1842, 137), 
    byrow=TRUE,nrow=5))
rownames(dat) <- paste("example 4.",0:4,sep="")
colnames(dat) <- paste("x",1:11,sep="")


###################################################
### chunk number 13: 
###################################################
#line 611 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
dat


###################################################
### chunk number 14: 
###################################################
#line 623 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
violatedEdits(E,dat)


###################################################
### chunk number 15: 
###################################################
#line 627 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
sol <- correctTypos(E, dat)
cbind(sol$corrected, sol$status)


###################################################
### chunk number 16: 
###################################################
#line 763 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
(dat <- data.frame(
    x = c( 3, 14, 15,  1, 17, 12.3),
    y = c(13, -4,  5,  2,  7, -2.1),
    z = c(10, 10,-10, NA, 10, 10 )))


###################################################
### chunk number 17: 
###################################################
#line 774 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
E <- editmatrix(c("z == x-y"))


###################################################
### chunk number 18: 
###################################################
#line 779 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
cbind(dat, violatedEdits(E,dat))


###################################################
### chunk number 19: 
###################################################
#line 786 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
sol <- correctSigns(E, dat)
cbind(sol$corrected, sol$status)
sol$corrections


###################################################
### chunk number 20: 
###################################################
#line 800 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
sol <- correctSigns(E, dat, eps=2)
cbind(sol$corrected, sol$status)
sol$corrections


###################################################
### chunk number 21: 
###################################################
#line 809 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
sol <- correctSigns(E, dat, eps=2, fixate="z")
cbind(sol$corrected, sol$status)
sol$corrections


###################################################
### chunk number 22: 
###################################################
#line 816 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
correctSigns(E, dat, flip=c("x","y"))


###################################################
### chunk number 23: 
###################################################
#line 821 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
sol <- correctSigns(E, dat, swap=list(c("x","y")), 
    eps=2, fixate="z")
cbind(sol$corrected, sol$status)
sol$corrections


###################################################
### chunk number 24: 
###################################################
#line 843 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
sol <- correctSigns(E, dat, flip=c(), swap=list(c("x","y")))
cbind(sol$corrected, sol$status) 
sol$corrections


###################################################
### chunk number 25: 
###################################################
#line 849 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
correctSigns(E, sol$corrected, eps=2)$status


###################################################
### chunk number 26: 
###################################################
#line 855 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
# make x and y swappable, swap a counts as one flip
correctSigns(E, dat, flip="z", swap=list(c("x","y")))

# same, but now, swapping is preferred (has lower weight)
correctSigns(E, dat, flip="z", swap=list(c("x","y")), weight=c(2,1))

# same, but now becayse x any y carry lower weight. Also allow for rounding errors
correctSigns(E, dat, flip="z", swap=list(c("x","y")), eps=2, weight=c(x=1, y=1, z=3))

# demand that solution has y>0
E <- editmatrix(c("z==x-y", "y>0"))
correctSigns(E,dat)

# demand that solution has y>0, taking acount of roundings in equalities
correctSigns(E,dat,eps=2)


###################################################
### chunk number 27: 
###################################################
#line 878 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
dat <- data.frame(
   case = c("a","b","c","d"),
   x0r = c(2100,5100,3250,5726),
   x0c = c(1950,4650,3550,5449),
   x0  = c( 150, 450, 300, 276),
   x1r = c(   0,   0, 110,  17),
   x1c = c(  10, 130,  10,  26),
   x1  = c(  10, 130, 100,  10),
   x2r = c(  20,  20,  50,   0),
   x2c = c(   5,   0,  90,  46),
   x2  = c(  15,  20,  40,  46),
   x3r = c(  50,  15,  30,   0),
   x3c = c(  10,  25,  10,   0),
   x3  = c(  40,  10,  20,   0),
   x4  = c( 195, 610,-140, 221))


###################################################
### chunk number 28: 
###################################################
#line 901 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
E <-editmatrix(c(
    "x0 == x0r - x0c",
    "x1 == x1r - x1c",
    "x2 == x2r - x2c",
    "x3 == x3r - x3c",
    "x4 == x0 + x1 + x2 + x3"))
E


###################################################
### chunk number 29: 
###################################################
#line 912 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
violatedEdits(E,dat)


###################################################
### chunk number 30: 
###################################################
#line 918 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
swap <- list(
    c("x1r","x1c"), 
    c("x2r","x2c"), 
    c("x3r","x3c"))
flip <- c("x0","x1","x2","x3","x4")


###################################################
### chunk number 31: 
###################################################
#line 941 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
cor <- correctSigns(E, dat, flip=flip, swap=swap)
cor$status


###################################################
### chunk number 32: 
###################################################
#line 948 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
cor <- correctSigns(E, dat, flip=flip, swap=swap, eps=2)
cor$status
cor$corrected


###################################################
### chunk number 33: 
###################################################
#line 1016 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
(E <- editmatrix(c(
    "t >= 1", 
    "l >= 0",
    "t == p + l",
    "p < 0.6*t")))


###################################################
### chunk number 34: 
###################################################
#line 1026 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
E <- matrix(c(
     1,   0, 0,
     0,   1, 0,
     1,  -1,-1,
    -0.6, 1, 1),
    nrow=4,
    byrow=TRUE,
    dimnames=list(
        1:4,
        c("t","l","p")
    )
)
b <- c(1,0,0,0)
ops <- c(">=", ">=", "==", ">")
(E <- as.editmatrix(E,b,ops))


###################################################
### chunk number 35: 
###################################################
#line 1049 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
E[getOps(E)==">=", ]


###################################################
### chunk number 36: 
###################################################
#line 1053 "d:/Rcompile/CRANpkg/local/2.12/deducorrect/inst/doc/deducorrect-vignette.Snw"
editmatrix(editrules(E),normalize=TRUE)


