/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.FieldBinding;
import jas.util.UnsupportedType;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class JSpinnerFieldBinding
extends FieldBinding
implements ChangeListener {
    private Object m_oldVal = new Integer(0);
    private JSpinner m_field;

    JSpinnerFieldBinding(JSpinner field) {
        this.m_field = field;
        field.addChangeListener(this);
    }

    void set(Object value) throws UnsupportedType {
        if (!this.m_oldVal.equals(value)) {
            this.m_field.setValue(value);
            this.m_oldVal = value;
        }
    }

    Object get(Class type) throws UnsupportedType {
        Object result = this.m_field.getValue();
        if (type == Float.TYPE && result instanceof Double) {
            return new Float(((Double)result).floatValue());
        }
        return result;
    }

    public void stateChanged(ChangeEvent e) {
        Object x = this.m_field.getValue();
        if (!x.equals(this.m_oldVal)) {
            this.setChanged();
        }
        this.notifyObservers();
    }

    protected void reset() {
        super.reset();
        this.m_oldVal = this.m_field.getValue();
    }
}

