/*
 * Decompiled with CFR 0.152.
 */
package criteres;

import criteres.Info;
import criteres.Qualificatif;
import criteres.Singleton;
import don.DonneeID;
import don.Groupe;
import don.Individu;
import don.Modalite;
import don.Variable;
import ihm.IHM;

public class CritereActifIllustratif
extends Qualificatif {
    private static final int ACTIF = 0;
    private static final int ILLUSTRATIF = 1;

    public Info evaluer(DonneeID obj) {
        if (obj.isActive()) {
            return new Singleton(0);
        }
        return new Singleton(1);
    }

    public String semantique(Singleton i) {
        if (i.get() == 0) {
            return IHM.getXmlLangue().getElement("CactifMF");
        }
        if (i.get() == 1) {
            return IHM.getXmlLangue().getElement("CillusMF");
        }
        return "erreur (critere) valeur inappropri\u00e9e pour Actif/Illustratif";
    }

    public String semantique() {
        return String.valueOf(IHM.getXmlLangue().getElement("CillusMF")) + IHM.getXmlLangue().getElement("ou") + IHM.getXmlLangue().getElement("CactifMF");
    }

    public int getNbSeries() {
        return 2;
    }

    public String qualifier(DonneeID obj) {
        if (obj instanceof Individu) {
            if (obj.isActive()) {
                return IHM.getXmlLangue().getElement("CactifM");
            }
            return IHM.getXmlLangue().getElement("CillusM");
        }
        if (obj instanceof Variable) {
            if (obj.isActive()) {
                return IHM.getXmlLangue().getElement("CactifF");
            }
            return IHM.getXmlLangue().getElement("CillusF");
        }
        if (obj instanceof Groupe) {
            if (obj.isActive()) {
                return IHM.getXmlLangue().getElement("CactifM");
            }
            return IHM.getXmlLangue().getElement("CillusM");
        }
        if (obj instanceof Modalite) {
            if (obj.isActive()) {
                return IHM.getXmlLangue().getElement("CactifF");
            }
            return IHM.getXmlLangue().getElement("CillusF");
        }
        return "erreur (critere) objet de type inconnu pour Actif/Illustratif";
    }

    public boolean adjectif() {
        return true;
    }
}

