###################################################
### chunk number 1: 
###################################################
#line 12 "d:/Rcompile/CRANpkg/local/2.12/flexmix/inst/doc/bootstrapping.Rnw"
options(useFancyQuotes = FALSE)
digits <- 3
Colors <- c("#E495A5", "#39BEB1")
critical_values <- function(n, p = "0.95") {
  data("qDiptab", package = "diptest")
  if (n %in% rownames(qDiptab)) {
    return(qDiptab[as.character(n), p])
  }else {
    n.approx <- as.numeric(rownames(qDiptab)[which.min(abs(n - as.numeric(rownames(qDiptab))))])
    return(sqrt(n.approx)/sqrt(n) * qDiptab[as.character(n.approx), p])
  }
}


###################################################
### chunk number 2: 
###################################################
#line 119 "d:/Rcompile/CRANpkg/local/2.12/flexmix/inst/doc/bootstrapping.Rnw"
library("flexmix")
Component_1 <- list(Model_1 = list(coef = c(1, -2), sigma = sqrt(0.1)))
Component_2 <- list(Model_1 = list(coef = c(2,  2), sigma = sqrt(0.1)))
ArtEx.mix <- FLXdist(y ~ x, k = rep(0.5, 2),
                    components = list(Component_1, Component_2))


###################################################
### chunk number 3: 
###################################################
#line 135 "d:/Rcompile/CRANpkg/local/2.12/flexmix/inst/doc/bootstrapping.Rnw"
ArtEx.data <- data.frame(x = rep(0:1, each = 100/2))
set.seed(123)
ArtEx.sim <- rflexmix(ArtEx.mix, newdata = ArtEx.data)
ArtEx.data$y <- ArtEx.sim$y[[1]]
ArtEx.data$class <- ArtEx.sim$class


###################################################
### chunk number 4: 
###################################################
#line 149 "d:/Rcompile/CRANpkg/local/2.12/flexmix/inst/doc/bootstrapping.Rnw"
par(mar = c(5, 4, 2, 0) + 0.1)
plot(y ~ x, data = ArtEx.data, pch = with(ArtEx.data, 2*class + x))
pars <- list(matrix(c(1, -2, 2,  2), ncol = 2),
             matrix(c(1,  3, 2, -3), ncol = 2))
for (i in 1:2) apply(pars[[i]], 2, abline, col = Colors[i])


###################################################
### chunk number 5: 
###################################################
#line 162 "d:/Rcompile/CRANpkg/local/2.12/flexmix/inst/doc/bootstrapping.Rnw"
set.seed(123)
ArtEx.fit <- stepFlexmix(y ~ x, data = ArtEx.data, k = 2, nrep = 5, 
                       control = list(iter = 1000, tol = 1e-8, verbose = 0))


###################################################
### chunk number 6: 
###################################################
#line 170 "d:/Rcompile/CRANpkg/local/2.12/flexmix/inst/doc/bootstrapping.Rnw"
summary(ArtEx.fit)
parameters(ArtEx.fit)


###################################################
### chunk number 7: 
###################################################
#line 180 "d:/Rcompile/CRANpkg/local/2.12/flexmix/inst/doc/bootstrapping.Rnw"
ArtEx.refit <- refit(ArtEx.fit)
summary(ArtEx.refit)


###################################################
### chunk number 8: 
###################################################
#line 204 "d:/Rcompile/CRANpkg/local/2.12/flexmix/inst/doc/bootstrapping.Rnw"
set.seed(123)
ArtEx.bs <- boot(ArtEx.fit, R = 15, sim = "parametric")
if ("boot-output.rda" %in% list.files()) load("boot-output.rda")
ArtEx.bs


###################################################
### chunk number 9: 
###################################################
#line 224 "d:/Rcompile/CRANpkg/local/2.12/flexmix/inst/doc/bootstrapping.Rnw"
print(plot(ArtEx.bs, ordering = "coef.x", col = Colors))


###################################################
### chunk number 10: 
###################################################
#line 242 "d:/Rcompile/CRANpkg/local/2.12/flexmix/inst/doc/bootstrapping.Rnw"
require("diptest")
parameters <- parameters(ArtEx.bs)
Ordering <- factor(as.vector(apply(matrix(parameters[,"coef.x"], 
                                          nrow = 2), 2, order)))
Comp1 <- parameters[Ordering == 1,]
Comp2 <- parameters[Ordering == 2,]
dip.values.art <- matrix(nrow = ncol(parameters), ncol = 3, 
                         dimnames=list(colnames(parameters),
                           c("Aggregated", "Comp 1", "Comp 2")))
dip.values.art[,"Aggregated"] <- apply(parameters, 2, dip)
dip.values.art[,"Comp 1"] <- apply(Comp1, 2, dip)
dip.values.art[,"Comp 2"] <- apply(Comp2, 2, dip)
dip.values.art


###################################################
### chunk number 11: 
###################################################
#line 297 "d:/Rcompile/CRANpkg/local/2.12/flexmix/inst/doc/bootstrapping.Rnw"
data("seizure", package = "flexmix")
model <- FLXMRglm(family = "poisson", offset = log(seizure$Hours))
control <- list(iter = 1000, tol = 1e-10, verbose = 0)
set.seed(123)
seizMix <- stepFlexmix(Seizures ~ Treatment*log(Day), 
                           data = seizure, k = 2, nrep = 5,
                           model = model, control = control)


###################################################
### chunk number 12: 
###################################################
#line 312 "d:/Rcompile/CRANpkg/local/2.12/flexmix/inst/doc/bootstrapping.Rnw"
par(mar = c(5, 4, 2, 0) + 0.1)
plot(Seizures/Hours~Day, data=seizure, pch = as.integer(seizure$Treatment))
abline(v=27.5, lty=2, col="grey")
matplot(seizure$Day, fitted(seizMix)/seizure$Hours, type="l",
        add=TRUE, col=1, lty = 1, lwd = 2)


###################################################
### chunk number 13: 
###################################################
#line 339 "d:/Rcompile/CRANpkg/local/2.12/flexmix/inst/doc/bootstrapping.Rnw"
set.seed(123)
seizMix.bs <- boot(seizMix, R = 15, sim = "parametric")
if ("boot-output.rda" %in% list.files()) load("boot-output.rda")
print(plot(seizMix.bs, ordering = "coef.(Intercept)", col = Colors))


###################################################
### chunk number 14: 
###################################################
#line 350 "d:/Rcompile/CRANpkg/local/2.12/flexmix/inst/doc/bootstrapping.Rnw"
parameters <- parameters(seizMix.bs)
Ordering <- factor(as.vector(apply(matrix(parameters[,"coef.(Intercept)"], 
                                          nrow = 2), 2, order)))
Comp1 <- parameters[Ordering == 1,]
Comp2 <- parameters[Ordering == 2,]


###################################################
### chunk number 15: 
###################################################
#line 364 "d:/Rcompile/CRANpkg/local/2.12/flexmix/inst/doc/bootstrapping.Rnw"
dip.values.art <- matrix(nrow = ncol(parameters), ncol = 3, 
                         dimnames=list(colnames(parameters),
                           c("Aggregated", "Comp 1", "Comp 2")))
dip.values.art[,"Aggregated"] <- apply(parameters, 2, dip)
dip.values.art[,"Comp 1"] <- apply(Comp1, 2, dip)
dip.values.art[,"Comp 2"] <- apply(Comp2, 2, dip)
dip.values.art


###################################################
### chunk number 16:  eval=FALSE
###################################################
## #line 386 "d:/Rcompile/CRANpkg/local/2.12/flexmix/inst/doc/bootstrapping.Rnw"
## set.seed(123)
## ArtEx.bs <- boot(ArtEx.fit, R = 200, sim = "parametric")
## set.seed(123)
## seizMix.bs <- boot(seizMix, R = 200, sim = "parametric")
## save(ArtEx.bs, seizMix.bs, file = "boot-output.rda")


