###################################################
### chunk number 1: cleanup
###################################################
#line 55 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/CNY.Rnw"
cleanup <- TRUE


###################################################
### chunk number 2: preliminaries
###################################################
#line 67 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/CNY.Rnw"
library("fxregime")
data("FXRatesCHF", package = "fxregime")


###################################################
### chunk number 3: cny-data
###################################################
#line 95 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/CNY.Rnw"
cny <- fxreturns("CNY", frequency = "daily",
  start = as.Date("2005-07-25"), end = as.Date("2009-07-31"),
  other = c("USD", "JPY", "EUR", "GBP"), data = FXRatesCHF)


###################################################
### chunk number 4: cny-fitting
###################################################
#line 104 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/CNY.Rnw"
cny_lm <- fxlm(CNY ~ USD + JPY + EUR + GBP,
  data = window(cny, end = as.Date("2005-10-31")))
summary(cny_lm)


###################################################
### chunk number 5: cny-testing
###################################################
#line 120 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/CNY.Rnw"
cny_efp <- gefp(cny_lm, fit = NULL)


###################################################
### chunk number 6: cny-hprocess eval=FALSE
###################################################
## #line 126 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/CNY.Rnw"
## plot(cny_efp, aggregate = FALSE, ylim = c(-1.85, 1.85))


###################################################
### chunk number 7: cny-hprocess1
###################################################
#line 133 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/CNY.Rnw"
#line 126 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/CNY.Rnw#from line#133#"
plot(cny_efp, aggregate = FALSE, ylim = c(-1.85, 1.85))
#line 134 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/CNY.Rnw"


###################################################
### chunk number 8: cny-sctest
###################################################
#line 143 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/CNY.Rnw"
sctest(cny_efp)


###################################################
### chunk number 9: cny-monitoring eval=FALSE
###################################################
## #line 152 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/CNY.Rnw"
## cny_mon <- fxmonitor(CNY ~ USD + JPY + EUR + GBP,
##   data = window(cny, end = as.Date("2006-05-31")),
##   start = as.Date("2005-11-01"), end = 4)
## plot(cny_mon, aggregate = FALSE)


###################################################
### chunk number 10: cny-mprocess
###################################################
#line 162 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/CNY.Rnw"
#line 152 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/CNY.Rnw#from line#162#"
cny_mon <- fxmonitor(CNY ~ USD + JPY + EUR + GBP,
  data = window(cny, end = as.Date("2006-05-31")),
  start = as.Date("2005-11-01"), end = 4)
plot(cny_mon, aggregate = FALSE)
#line 163 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/CNY.Rnw"


###################################################
### chunk number 11: cny-monitorbreak
###################################################
#line 179 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/CNY.Rnw"
cny_mon


###################################################
### chunk number 12: cny-dating eval=FALSE
###################################################
## #line 186 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/CNY.Rnw"
## cny_reg <- fxregimes(CNY ~ USD + JPY + EUR + GBP,
##   data = cny, h = 20, breaks = 10)


###################################################
### chunk number 13: cny-dating1
###################################################
#line 191 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/CNY.Rnw"
if(file.exists("cny_reg.rda")) load("cny_reg.rda") else {
#line 186 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/CNY.Rnw#from line#192#"
cny_reg <- fxregimes(CNY ~ USD + JPY + EUR + GBP,
  data = cny, h = 20, breaks = 10)
#line 193 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/CNY.Rnw"
save(cny_reg, file = "cny_reg.rda")
}
if(cleanup) file.remove("cny_reg.rda")


###################################################
### chunk number 14: cny-breaks eval=FALSE
###################################################
## #line 204 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/CNY.Rnw"
## plot(cny_reg)


###################################################
### chunk number 15: cny-breaks1
###################################################
#line 211 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/CNY.Rnw"
#line 204 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/CNY.Rnw#from line#211#"
plot(cny_reg)
#line 212 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/CNY.Rnw"


###################################################
### chunk number 16: cny-confint
###################################################
#line 228 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/CNY.Rnw"
confint(cny_reg, level = 0.9)


###################################################
### chunk number 17: cny-coef
###################################################
#line 236 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/CNY.Rnw"
coef(cny_reg)


###################################################
### chunk number 18: cny-refit
###################################################
#line 243 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/CNY.Rnw"
cny_rf <- refit(cny_reg)
lapply(cny_rf, summary)


