###################################################
### chunk number 1: cleanup
###################################################
#line 54 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/INR.Rnw"
cleanup <- TRUE


###################################################
### chunk number 2: preliminaries
###################################################
#line 66 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/INR.Rnw"
library("fxregime")
data("FXRatesCHF", package = "fxregime")


###################################################
### chunk number 3: inr-data
###################################################
#line 89 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/INR.Rnw"
inr <- fxreturns("INR", frequency = "weekly",
  start = as.Date("1993-04-01"), end = as.Date("2008-01-04"),
  other = c("USD", "JPY", "DUR", "GBP"), data = FXRatesCHF)


###################################################
### chunk number 4: inr-fitting
###################################################
#line 103 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/INR.Rnw"
inr_lm <- fxlm(INR ~ USD + JPY + DUR + GBP, data = inr)


###################################################
### chunk number 5: inr-testing eval=FALSE
###################################################
## #line 112 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/INR.Rnw"
## inr_efp <- gefp(inr_lm, fit = NULL)
## plot(inr_efp, aggregate = FALSE, ylim = c(-1.85, 1.85))


###################################################
### chunk number 6: inr-hprocess
###################################################
#line 120 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/INR.Rnw"
#line 112 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/INR.Rnw#from line#120#"
inr_efp <- gefp(inr_lm, fit = NULL)
plot(inr_efp, aggregate = FALSE, ylim = c(-1.85, 1.85))
#line 121 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/INR.Rnw"


###################################################
### chunk number 7: inr-sctest
###################################################
#line 131 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/INR.Rnw"
sctest(inr_efp)


###################################################
### chunk number 8: inr-sctest2
###################################################
#line 138 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/INR.Rnw"
sctest(inr_efp, functional = meanL2BB)


###################################################
### chunk number 9: inr-dating eval=FALSE
###################################################
## #line 154 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/INR.Rnw"
## inr_reg <- fxregimes(INR ~ USD + JPY + DUR + GBP,
##   data = inr, h = 20, breaks = 10)


###################################################
### chunk number 10: inr-dating1
###################################################
#line 159 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/INR.Rnw"
if(file.exists("inr_reg.rda")) load("inr_reg.rda") else {
#line 154 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/INR.Rnw#from line#160#"
inr_reg <- fxregimes(INR ~ USD + JPY + DUR + GBP,
  data = inr, h = 20, breaks = 10)
#line 161 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/INR.Rnw"
save(inr_reg, file = "inr_reg.rda")
}
if(cleanup) file.remove("inr_reg.rda")


###################################################
### chunk number 11: inr-breaks eval=FALSE
###################################################
## #line 170 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/INR.Rnw"
## plot(inr_reg)


###################################################
### chunk number 12: inr-breaks1
###################################################
#line 177 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/INR.Rnw"
#line 170 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/INR.Rnw#from line#177#"
plot(inr_reg)
#line 178 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/INR.Rnw"


###################################################
### chunk number 13: inr-confint
###################################################
#line 193 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/INR.Rnw"
confint(inr_reg, level = 0.9)


###################################################
### chunk number 14: inr-coef
###################################################
#line 202 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/INR.Rnw"
coef(inr_reg)


###################################################
### chunk number 15: inr-coef
###################################################
#line 228 "d:/Rcompile/CRANpkg/local/2.12/fxregime/inst/doc/INR.Rnw"
inr_rf <- refit(inr_reg)
lapply(inr_rf, summary)


