###################################################
### chunk number 1: preliminaries
###################################################
#line 97 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
set.seed(1071)
old.opts <- options(width=85, digits=5, useFancyQuotes = FALSE, continue="  ")
library(heplots)
library(candisc)


###################################################
### chunk number 2: plastic-mod
###################################################
#line 120 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
plastic.mod <- lm(cbind(tear, gloss, opacity) ~ rate*additive, data=Plastic)
Anova(plastic.mod, test.statistic="Roy")


###################################################
### chunk number 3: plastic-univar
###################################################
#line 131 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
Anova(update(plastic.mod, tear ~ .))
Anova(update(plastic.mod, gloss ~ .))
Anova(update(plastic.mod, opacity ~ .))


###################################################
### chunk number 4: plastic1a eval=FALSE
###################################################
## #line 150 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
## # Compare evidence and effect scaling 
## colors = c("red", "darkblue", "darkgreen", "brown")
## heplot(plastic.mod, size="evidence", col=colors, cex=1.25)
## heplot(plastic.mod, size="effect", add=TRUE, lwd=4, term.labels=FALSE, col=colors)


###################################################
### chunk number 5: plastic1b eval=FALSE
###################################################
## #line 174 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
## ## add interaction means
## intMeans <- termMeans(plastic.mod, 'rate:additive', abbrev.levels=2)
## #rownames(intMeans) <- apply(expand.grid(c('Lo','Hi'), c('Lo', 'Hi')), 1, paste, collapse=':')
## points(intMeans[,1], intMeans[,2], pch=18, cex=1.2, col="brown")
## text(intMeans[,1], intMeans[,2], rownames(intMeans), adj=c(0.5,1), col="brown")
## lines(intMeans[c(1,3),1], intMeans[c(1,3),2], col="brown")
## lines(intMeans[c(2,4),1], intMeans[c(2,4),2], col="brown")


###################################################
### chunk number 6: plastic1
###################################################
#line 183 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
#line 150 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw#from line#183#"
# Compare evidence and effect scaling 
colors = c("red", "darkblue", "darkgreen", "brown")
heplot(plastic.mod, size="evidence", col=colors, cex=1.25)
heplot(plastic.mod, size="effect", add=TRUE, lwd=4, term.labels=FALSE, col=colors)
#line 184 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
#line 174 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw#from line#184#"
## add interaction means
intMeans <- termMeans(plastic.mod, 'rate:additive', abbrev.levels=2)
#rownames(intMeans) <- apply(expand.grid(c('Lo','Hi'), c('Lo', 'Hi')), 1, paste, collapse=':')
points(intMeans[,1], intMeans[,2], pch=18, cex=1.2, col="brown")
text(intMeans[,1], intMeans[,2], rownames(intMeans), adj=c(0.5,1), col="brown")
lines(intMeans[c(1,3),1], intMeans[c(1,3),2], col="brown")
lines(intMeans[c(2,4),1], intMeans[c(2,4),2], col="brown")
#line 185 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"


###################################################
### chunk number 7: plastic-mod
###################################################
#line 229 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
plastic.mod


###################################################
### chunk number 8: plastic-tests
###################################################
#line 234 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
print(linearHypothesis(plastic.mod, c("rateHigh", "additiveHigh"), title="Main effects"), SSP=FALSE)

print(linearHypothesis(plastic.mod, c("rateHigh", "additiveHigh", "rateHigh:additiveHigh"), title="Groups"), SSP=FALSE)


###################################################
### chunk number 9: plastic2
###################################################
#line 244 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
heplot(plastic.mod, hypotheses=list("Group" = 
       c("rateHigh", "additiveHigh", "rateHigh:additiveHigh ")),
       col=c(colors, "purple"),
       lwd=c(2, 3, 3, 3, 2), cex=1.25)
heplot(plastic.mod, hypotheses=list("Main effects" = 
       c("rateHigh", "additiveHigh")), add=TRUE,
       col=c(colors, "darkgreen"), cex=1.25)


###################################################
### chunk number 10: plastic1-HE3D eval=FALSE
###################################################
## #line 262 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
## colors = c("pink", "darkblue", "darkgreen", "brown")
## heplot3d(plastic.mod, col=colors)


###################################################
### chunk number 11: MJdata
###################################################
#line 296 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
str(MockJury)


###################################################
### chunk number 12: MJdata1
###################################################
#line 302 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
table(MockJury$Attr)
table(MockJury$Attr, MockJury$Crime)


###################################################
### chunk number 13: jury.mod1
###################################################
#line 320 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
(jury.mod1 <- lm( cbind(phyattr, happy, independent, sophisticated) ~ Attr, data=MockJury))
Anova(jury.mod1, test="Roy")


###################################################
### chunk number 14: jury-mod1-HE
###################################################
#line 339 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
heplot(jury.mod1, main="HE plot for manipulation check")


###################################################
### chunk number 15: jury-mod1-pairs
###################################################
#line 360 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
pairs(jury.mod1)


###################################################
### chunk number 16: jury-can1a
###################################################
#line 374 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
jury.can <- candisc(jury.mod1)
jury.can


###################################################
### chunk number 17: jury-can1
###################################################
#line 381 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
opar <- par(xpd=TRUE)
heplot(jury.can, prefix="Canonical dimension", main="Canonical HE plot")
par(opar)


###################################################
### chunk number 18: jury-mod2
###################################################
#line 403 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
# influence of Attr of photo and nature of crime on Serious and Years
jury.mod2 <- lm( cbind(Serious, Years) ~ Attr * Crime, data=MockJury)
Anova(jury.mod2, test="Roy")


###################################################
### chunk number 19: jury-mod2-HE
###################################################
#line 413 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
heplot(jury.mod2)


###################################################
### chunk number 20: jury-mod3-HE
###################################################
#line 432 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
# stepdown test (ANCOVA), controlling for Serious
jury.mod3 <- lm( Years ~ Serious + Attr * Crime, data=MockJury)
t(coef(jury.mod3))
Anova(jury.mod3)


###################################################
### chunk number 21: jury-mod3-eff
###################################################
#line 455 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
library(effects)
jury.eff <- allEffects(jury.mod3)
plot(jury.eff, ask=FALSE)


###################################################
### chunk number 22: rohwer-some
###################################################
#line 505 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
some(Rohwer,n=6)


###################################################
### chunk number 23: rohwer-separate
###################################################
#line 514 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
rohwer.ses1 <- lm(cbind(SAT, PPVT, Raven) ~ n + s + ns + na + ss, data=Rohwer, subset=SES=="Hi")
Anova(rohwer.ses1)

rohwer.ses2 <- lm(cbind(SAT, PPVT, Raven) ~ n + s + ns + na + ss, data=Rohwer, subset=SES=="Lo")
Anova(rohwer.ses2)


###################################################
### chunk number 24: rohwer-coef
###################################################
#line 523 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
coef(rohwer.ses1)
coef(rohwer.ses2)


###################################################
### chunk number 25: rohwer-HE1
###################################################
#line 530 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
heplot(rohwer.ses1, ylim=c(40,110),col=c("red", "black"), lwd=2, cex=1.2)
heplot(rohwer.ses2, add=TRUE, col=c("blue", "black"), grand.mean=TRUE, error.ellipse=TRUE, lwd=2, cex=1.2)
means <- aggregate(cbind(SAT,PPVT)~SES, data=Rohwer,  mean)
text(means[,2], means[,3], labels=means[,1], pos=3, cex=2, col=c("red", "blue"))


###################################################
### chunk number 26: rohwer-mod
###################################################
#line 553 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
# MANCOVA, assuming equal slopes
rohwer.mod <- lm(cbind(SAT, PPVT, Raven) ~ SES + n + s + ns + na + ss, 
                 data=Rohwer)
Anova(rohwer.mod)


###################################################
### chunk number 27: rohwer-mod-test
###################################################
#line 569 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
(covariates <- rownames(coef(rohwer.mod))[-(1:2)])
Regr<-linearHypothesis(rohwer.mod, covariates)
print(Regr, digits=5, SSP=FALSE)


###################################################
### chunk number 28: rohwer-HE2
###################################################
#line 578 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
colors <- c("red", "blue", rep("black",5), "#969696")
heplot(rohwer.mod, col=colors,
      hypotheses=list("Regr" = c("n", "s", "ns", "na", "ss")),
      cex=1.5, lwd=c(2, rep(3,5), 4),
      main="(SAT, PPVT, Raven) ~ SES + n + s + ns + na + ss")


###################################################
### chunk number 29: rohwer-HE3
###################################################
#line 585 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
heplot(rohwer.mod, col=colors,  variables=c(1,3),
      hypotheses=list("Regr" = c("n", "s", "ns", "na", "ss")),
      cex=1.5, lwd=c(2, rep(3,5), 4),
      main="(SAT, PPVT, Raven) ~ SES + n + s + ns + na + ss")


###################################################
### chunk number 30: rohwer-HE3 eval=FALSE
###################################################
## #line 610 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
## pairs(rohwer.mod, col=colors,
##       hypotheses=list("Regr" = c("n", "s", "ns", "na", "ss")),
##       cex=1.3, lwd=c(2, rep(3,5), 4))


###################################################
### chunk number 31: rohwer-HE3D eval=FALSE
###################################################
## #line 616 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
## colors <- c("pink", "blue", rep("black",5), "#969696")
## heplot3d(rohwer.mod, col=colors,
## 	hypotheses=list("Regr" = c("n", "s", "ns", "na", "ss")))


###################################################
### chunk number 32: rohwer-mod2
###################################################
#line 635 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
rohwer.mod2 <- lm(cbind(SAT, PPVT, Raven) ~ SES * (n + s + ns + na + ss),
                  data=Rohwer)
Anova(rohwer.mod2)


###################################################
### chunk number 33: rohwer-mod2-test
###################################################
#line 645 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
(coefs <- rownames(coef(rohwer.mod2)))
print(linearHypothesis(rohwer.mod2, coefs[grep(":", coefs)]), SSP=FALSE)


###################################################
### chunk number 34: rohwer-HE4
###################################################
#line 669 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
colors <- c("red", "blue", rep("black",5), "#969696")
heplot(rohwer.mod2, col=c(colors, "brown"), 
      terms=c("SES", "n", "s", "ns", "na", "ss"), 
      hypotheses=list("Regr" = c("n", "s", "ns", "na", "ss"),
                      "Slopes" = coefs[grep(":", coefs)]))


###################################################
### chunk number 35: tidyup
###################################################
#line 696 "d:/Rcompile/CRANpkg/local/2.12/heplots/inst/doc/HE-examples.Rnw"
options(old.opts )


