###################################################
### chunk number 1: startup
###################################################
#line 111 "SweaveInput"
system ("mkdir fig")
options(SweaveHooks=list(fig=function() {
  par(mar = c (4.1, 4.1, 1, .6))

  trellis.pars <- trellis.par.get ("layout.heights")
  trellis.pars [grep ("padding", names (trellis.pars))] <- 0
  trellis.par.set(layout.heights = trellis.pars)
  
  trellis.pars <- trellis.par.get ("layout.widths")
  trellis.pars [grep ("padding", names (trellis.pars))] <- 0
  trellis.par.set(layout.widths = trellis.pars)
}))
options ("width" = 100, "digits" = 5)
library (hyperSpec)

# redefine lattice functions so that the result is printed without external print command
setMethod ("plot",
           signature (x = "hyperSpec", y = "character"),
           function (x, y, ...){
             tmp <- hyperSpec:::.plot (x, y, ...)
             if (is (tmp, "trellis"))
               print (tmp)
             invisible (tmp)
           })


plotmap <- function (...) print (hyperSpec:::plotmap (...))

setMethod ("levelplot", signature (x = "hyperSpec", data = "missing"),
   function (x, data, ...) {
	   l <- hyperSpec:::.levelplot (x = formula (spc ~ x * y), data = x, ...)
		print (l)
	}
)

setMethod ("levelplot", signature (x = "formula", data = "hyperSpec"), 
   function (x, data, ...) print (hyperSpec:::.levelplot (x, data, ...))
)

plotc <- function (...){
   call <- match.call () 
   call [[1]] <- hyperSpec:::plotc 
   print (eval (call))
}

ploterrormsg <- function (fn, pkg) {
  plot (0, 0, type = "n", axes = FALSE, bty = "n", xlab = "", ylab = "")
  text (0, 0, paste ("Function", fn, "not available:\npackage", pkg, "needed."))
}
griderrormsg <- function (fn, pkg) {
  require (grid)
  grid.text (label = paste ("Function", fn, "not available:\npackage", pkg, "needed."))
  NA
}
texterrormsg <- function (fn, pkg) {
  cat ("Function", fn, "not available:\npackage", pkg, "needed.\n")
}

nice.paste <- function (...){
  fnames <- c (...)
  
  if (length (fnames) == 2L)
    fnames <- paste (fnames, collapse = " and ")
  if (length (fnames) > 1L){
    fnames [length (fnames)] <- paste ("and", tail (fnames, 1))
    fnames <- paste (fnames, collapse = ", ")
  }

  fnames
}

check.req.pkg <- function (pkg = stop ("pkg needed"), 
                           texterrors = NULL, ploterrors = NULL, griderrors = NULL,
                           hynstext = NULL, hynsplot = NULL, hynsgrid = NULL, 
                           donothing = NULL, special = NULL, v = TRUE){
  if (v) cat ("\\item[\\Rpackage{", pkg, "}:] ", sep = "")
  
  dummies <- list ()
  
  if (pkg.exists (pkg)){
    if (v) cat ("available\n")
  } else {
    for (fn in as.character (texterrors))
      dummies <- c (dummies, bquote (.(fn) <- function (...) texterrormsg (.(fn), .(pkg))))
    for (fn in as.character (ploterrors))
      dummies <- c (dummies, bquote (.(fn) <- function (...) ploterrormsg (.(fn), .(pkg))))
    for (fn in as.character (griderrors))
      dummies <- c (dummies, bquote (.(fn) <- function (...) griderrormsg (.(fn), .(pkg))))

    for (fn in as.character (hynstext))
      assignInNamespace (x = fn, 
                         value = eval (bquote (function (...) texterrormsg (.(fn), .(pkg)))), 
                         ns = "hyperSpec")
    for (fn in as.character (hynsplot))
      assignInNamespace (x = fn, 
                         value = eval (bquote (function (...) ploterrormsg (.(fn), .(pkg)))), 
                         ns = "hyperSpec")
    for (fn in as.character (hynsgrid))
      assignInNamespace (x = fn, 
                         value = eval (bquote (function (...) griderrormsg (.(fn), .(pkg)))), 
                         ns = "hyperSpec")

    fnames <- nice.paste (texterrors, ploterrors, griderrors, hynstext, hynsplot, hynsgrid, names (special))
    if (v && length (fnames) > 0L) cat (fnames, "replaced.")
    
    for (fn in as.character (donothing))
      dummies <- c (dummies, bquote (.(fn) <- function (...) invisible (NULL)))
    
    fnames <- nice.paste (donothing)
    if (v && length (fnames) > 0L) cat (fnames, "missing.")
    
    if (v) cat ("\n")
  }
  
  invisible (dummies)
}

plotvoronoi <- function (...) print (hyperSpec:::plotvoronoi (...))

# set standardized color palettes 
seq.palette <- colorRampPalette (c ("white", "dark green"), space = "Lab")

YG.palette <- function (n = 20) rgb (colorRamp (c("#F7FCF5", "#E5F5E0", "#C7E9C0", "#A1D99B", "#74C476", 
                                             "#41AB5D", "#238B45", "#006D2C", "#00441B"), space = "Lab") 
                                # was: brewer.pal (9, "Greens")
                                (seq (1/3, 1, length.out = n)^2), maxColorValue = 255)

										  
div.palette <- colorRampPalette (c("#00008B", "#351C96", "#5235A2", "#6A4CAE", "#8164BA", "#967CC5", 
                                   "#AC95D1", "#C1AFDC", "#D5C9E8", "#E0E3E3", "#F8F8B0", "#F7E6C2", 
											  "#EFCFC6", "#E6B7AB", "#DCA091", "#D08977", "#C4725E", "#B75B46",
											  "#A9432F", "#9A2919", "#8B0000"), space = "Lab")

pkgSuggests <- function (...)
  strsplit (packageDescription (..., fields="Suggests"), ",\\s*")[[1]]

pkg.exists <- function (pkg = stop ("package name needed"), lib.loc = NULL){
  dir <- sapply (pkg, function (p) system.file (package = p, lib.loc = lib.loc))
  nzchar (dir) > 0L 
}
  
is.basepkg <- function (pkg){
  pkg.exists (pkg) && grepl ("^base$", packageDescription (pkg, fields = "Priority"))
}

pkg.or.base <- function (pkg){
  pkg [sapply (pkg, is.basepkg)] <- "base"
  
  pkg
}

citation.or.file <- function (pkg, svd.cit = sprintf ("%s.CITATION", pkg)){
  if (pkg.exists (pkg))
    citation (pkg)
  else if (file.exists (svd.cit))
    readCitationFile (file = svd.cit)
  else
    NULL
}

make.cite.keys <- function (pkg, entries){
  pkg <- pkg.or.base (pkg)

  if (! pkg.exists (pkg))
    return (pkg)
  
  if (missing (entries))
    entries <- citation.or.file (pkg)
  
  keys <- sapply (unclass (entries), attr, "key")
  
  noname <- which (sapply (keys, is.null))

  if (length (keys) == 1L && noname == 1L) {
    keys <- pkg
  } else {
    for (i in noname)
      keys [[i]] <- paste (pkg, i, sep = ".")
  }

  keys <- make.unique (unlist (keys))
  
  keys
}
  
citation.with.key <- function (pkg = "base"){
  pkg <- pkg.or.base (pkg)

  tmp <- citation.or.file (pkg)
  
  keys <- make.cite.keys (pkg, tmp)

  for (entry in seq_along (tmp))
    tmp [entry]$"key" <- keys [[entry]]

  tmp
}

cite.pkg <- function (p, entries, citefun = "cite"){
  paste ("\\\\", citefun, "{", paste (make.cite.keys (p, entries), collapse = ", "), "}", sep = "")
}

make.bib <- function (..., file = NULL) {
  pkg <- c (...)

  if (length (pkg) == 0L) {
    pkg <- loadedNamespaces()
 
    pkg <- unique (pkg.or.base (pkg))
  }
  
  l <- lapply (pkg, citation.with.key)
  l <- do.call ("c", l [! sapply (l, is.null)])

  if (!is.null (file))
    if (is.null (l))
      cat (NULL, file = file)           # touches file
    else
      cat (toBibtex (l), file = file, sep = "\n")
  
  invisible (l)
}



###################################################
### chunk number 2: mailme
###################################################
#line 337 "SweaveInput"
cat ("\\newcommand{\\mailme}{\\href{mailto:", 
     packageDescription ("hyperSpec")$Maintainer, 
	  "}{\\texttt{", 
	  packageDescription ("hyperSpec")$Maintainer,
	  "}}}\n", 
	  sep = "")


###################################################
### chunk number 3: listfunctions
###################################################
#line 346 "SweaveInput"
texListFun <- function (pattern){
  funs <- ls (envir = getNamespace ("hyperSpec"), pattern = pattern)
  funs <- paste ("\\\\Rfunction{", funs, "}", sep ="")
  nice.paste (funs)
}


###################################################
### chunk number 4: cleanup eval=FALSE
###################################################
## #line 355 "SweaveInput"
## sessionInfo ()
## rm (list = ls ())
## for (f in Sys.glob ("fig/*.pdf")) 
##   system (sprintf ("gs -sDEVICE=pdfwrite -dCompatibilityLevel=1.4 -dPDFSETTINGS=/screen -dNOPAUSE -dQUIET -dBATCH -dAutoRotatePages=/None -sOutputFile=tmp.pdf %s && mv tmp.pdf %s", f, f))


###################################################
### chunk number 5: check-required
###################################################
#line 387 "SweaveInput"
check.req.pkg ("pls", special = list (msc = function (x) {texterrormsg ("msc", "pls"); x}))
check.req.pkg ("baseline", 
               special = list (
                 baseline = function (x) {texterrormsg ("baseline", "baseline"); x},
                 getCorrected = function (x) {texterrormsg ("getCorrected", "baseline"); x}
                 ))
check.req.pkg ("ggplot2", donothing = "")
check.req.pkg ("compiler", donothing = "")
check.req.pkg ("inline", donothing = "")


###################################################
### chunk number 6:  eval=FALSE
###################################################
## #line 495 "SweaveInput"
## chk.hy (object)                         
## validObject (object)                    


###################################################
### chunk number 7:  eval=FALSE
###################################################
## #line 512 "SweaveInput"
## sweep (flu, 2, mean, `-`)


###################################################
### chunk number 8: 
###################################################
#line 518 "SweaveInput"
`+` (3, 5)


###################################################
### chunk number 9:  eval=FALSE
###################################################
## #line 528 "SweaveInput"
## wl (flu) <- new.wavelength.values


###################################################
### chunk number 10: init
###################################################
#line 536 "SweaveInput"
library ("hyperSpec")


###################################################
### chunk number 11: checkCompleteOptionTable
###################################################
#line 563 "SweaveInput"
stopifnot (all (names (hy.getOptions(TRUE)) %in% c ("log", "debuglevel", "gc")))


###################################################
### chunk number 12: print
###################################################
#line 625 "SweaveInput"
chondro
summary (chondro)


###################################################
### chunk number 13: nwl
###################################################
#line 634 "SweaveInput"
nrow (chondro)
nwl (chondro)
ncol (chondro)
dim (chondro)


###################################################
### chunk number 14: names
###################################################
#line 642 "SweaveInput"
colnames (chondro)


###################################################
### chunk number 15:  eval=FALSE
###################################################
## #line 665 "SweaveInput"
## spc <- new ("hyperSpec", spc = spectra.matrix, wavelength = wavelength.vector, data = extra.data)


###################################################
### chunk number 16: logbook
###################################################
#line 683 "SweaveInput"
logbook (flu)


###################################################
### chunk number 17: 
###################################################
#line 689 "SweaveInput"
tmp <- logentry (flu, short = "test", long = "This could also be a list of parameters")
logbook (tmp)


###################################################
### chunk number 18: 
###################################################
#line 695 "SweaveInput"
tmp <- tmp [1:3]
logbook (tmp)


###################################################
### chunk number 19: 
###################################################
#line 703 "SweaveInput"
tmp <- sweep (tmp, 2, mean, short = "centering")
logbook (tmp)


###################################################
### chunk number 20: logoff
###################################################
#line 708 "SweaveInput"
hy.setOptions (log = FALSE)


###################################################
### chunk number 21: 
###################################################
#line 714 "SweaveInput"
rm (tmp)


###################################################
### chunk number 22: selspc
###################################################
#line 760 "SweaveInput"
plot (flu, col = "gray")
plot (flu [1 : 3], add = TRUE)


###################################################
### chunk number 23: delspc
###################################################
#line 765 "SweaveInput"
plot (flu, col = "gray")
plot (flu [-3], add = TRUE)


###################################################
### chunk number 24: selspc2
###################################################
#line 769 "SweaveInput"
plot (flu, col = "gray")
plot (flu [flu$c > 0.2], add = TRUE)


###################################################
### chunk number 25: sample
###################################################
#line 778 "SweaveInput"
sample (chondro, 3)


###################################################
### chunk number 26: isample
###################################################
#line 782 "SweaveInput"
isample (chondro, 3)


###################################################
### chunk number 27: seq
###################################################
#line 788 "SweaveInput"
seq (chondro, length.out = 3, index = TRUE)
seq (chondro, by = 100)


###################################################
### chunk number 28: data
###################################################
#line 800 "SweaveInput"
colnames (chondro)
chondro [[1 : 3, 1]]
chondro [[1 : 3, -4]]
chondro [[1 : 3, "x"]]
chondro [[1 : 3, c (TRUE, FALSE)]]      # note the recycling!


###################################################
### chunk number 29: data2
###################################################
#line 809 "SweaveInput"
flu$c


###################################################
### chunk number 30: data3
###################################################
#line 815 "SweaveInput"
flu$n <- list (1 : 6, label = "sample no.")


###################################################
### chunk number 31: data2
###################################################
#line 825 "SweaveInput"
indexmatrix <- matrix (c (1 : 3, 1 : 3), ncol = 2)
indexmatrix
chondro [[indexmatrix, wl.index = TRUE]]
diag (chondro [[1 : 3, , min ~ min + 2i]])


###################################################
### chunk number 32: data2
###################################################
#line 833 "SweaveInput"
indexmatrix <- matrix (c (1 : 3, 1 : 3), ncol = 2)
indexmatrix
chondro [[indexmatrix, wl.index = TRUE]]
diag (chondro [[1 : 3, , min ~ min + 2i]])


###################################################
### chunk number 33: wl2ivec
###################################################
#line 863 "SweaveInput"
wl2i (flu, 405 : 410)


###################################################
### chunk number 34: wl2ivec2
###################################################
#line 866 "SweaveInput"
wl2i (flu, 405 ~ 410)


###################################################
### chunk number 35: wl2ivec3
###################################################
#line 869 "SweaveInput"
wl2i (chondro, 1000 : 1010)


###################################################
### chunk number 36: wl2ivec4
###################################################
#line 872 "SweaveInput"
wl2i (chondro, 1000 ~ 1010)


###################################################
### chunk number 37: wl2i.minmax
###################################################
#line 882 "SweaveInput"
wl2i (flu, min ~ 410)


###################################################
### chunk number 38: wl2i.im
###################################################
#line 890 "SweaveInput"
wl2i (flu, 450 - 2i ~ 450 + 2i)
wl2i (flu, max - 2i ~ max)


###################################################
### chunk number 39: wl2i.list
###################################################
#line 898 "SweaveInput"
wl2i (flu, c (min ~ 406.5, max - 2i ~ max))


###################################################
### chunk number 40: 
###################################################
#line 907 "SweaveInput"
plot (paracetamol [,, 2800 ~ 3200])


###################################################
### chunk number 41: 
###################################################
#line 913 "SweaveInput"
plot (paracetamol [,, 2800 : 3200, wl.index = TRUE])


###################################################
### chunk number 42: 
###################################################
#line 923 "SweaveInput"
plot (paracetamol [,, -(500 : 1000), wl.index = TRUE])


###################################################
### chunk number 43: 
###################################################
#line 932 "SweaveInput"
plot (paracetamol [,, c (min ~ 1750, 2800 ~ max)])


###################################################
### chunk number 44: merged
###################################################
#line 952 "SweaveInput"
laser
wavelengths <- wl (laser)
frequencies <- 2.998e8 / wavelengths / 1000
wl (laser) <- frequencies
labels (laser, ".wavelength") <- "f / THz"
laser
rm (laser)


###################################################
### chunk number 45: 
###################################################
#line 963 "SweaveInput"
wl (laser, "f / THz") <- frequencies


###################################################
### chunk number 46: 
###################################################
#line 967 "SweaveInput"
wl (laser) <- list (wl = frequencies, label = "f / THz")


###################################################
### chunk number 47: orderwl
###################################################
#line 975 "SweaveInput"
barb <- collapse (barbiturates [1 : 3])
wl (barb)
barb <- orderwl (barb)
wl (barb)


###################################################
### chunk number 48: 
###################################################
#line 985 "SweaveInput"
flu <- flu [,,400 ~ 407] # make a small and handy version of the flu data set
as.data.frame (flu)
colnames (as.data.frame (flu))
as.data.frame (flu) $ spc


###################################################
### chunk number 49: 
###################################################
#line 995 "SweaveInput"
flu$.
flu$..


###################################################
### chunk number 50: 
###################################################
#line 1000 "SweaveInput"
flu [[, c ("c", "spc")]]


###################################################
### chunk number 51: 
###################################################
#line 1010 "SweaveInput"
as.t.df (apply (flu, 2, mean_pm_sd))


###################################################
### chunk number 52: 
###################################################
#line 1016 "SweaveInput"
head (as.long.df (flu), 20)


###################################################
### chunk number 53: 
###################################################
#line 1024 "SweaveInput"
flu [[]]
class (flu [[]])


###################################################
### chunk number 54: 
###################################################
#line 1029 "SweaveInput"
flu [[1:3,, 406 ~ 407]]


###################################################
### chunk number 55: 
###################################################
#line 1033 "SweaveInput"
flu [[1:3, c ("file", "spc"), 406 ~ 407]]


###################################################
### chunk number 56: 
###################################################
#line 1037 "SweaveInput"
rm (flu)


###################################################
### chunk number 57: cbind
###################################################
#line 1050 "SweaveInput"
dim (flu)
dim (cbind (flu, flu))
dim (rbind (flu, flu))


###################################################
### chunk number 58: collapse
###################################################
#line 1074 "SweaveInput"
barb <- collapse (barbiturates)
wl (barb) [1 : 25]


###################################################
### chunk number 59: collapse-orderwl
###################################################
#line 1079 "SweaveInput"
barb <- orderwl (barb)
barb [[1:3, , min ~ min + 10i]]


###################################################
### chunk number 60: merge-sample
###################################################
#line 1096 "SweaveInput"
chondro.low <- sample (chondro [,, 600 ~ 1200], 700)
nrow (chondro.low)
chondro.high <- sample (chondro [,, 1400 ~ 1800], 700)
nrow (chondro.high)


###################################################
### chunk number 61: merge
###################################################
#line 1104 "SweaveInput"
chondro.merged <- merge (chondro.low, chondro.high)
nrow (chondro.merged)


###################################################
### chunk number 62: 
###################################################
#line 1111 "SweaveInput"
chondro.merged <- merge (chondro.low, chondro.high, all = TRUE)
nrow (chondro.merged)


###################################################
### chunk number 63: missing
###################################################
#line 1118 "SweaveInput"
print (levelplot (spc ~ x * y | as.factor (paste (.wavelength, "  1/cm")), 
                  chondro.merged [,,c(1000, 1650)], 
                  aspect = "iso", col.regions = matlab.palette ()))


###################################################
### chunk number 64: 
###################################################
#line 1126 "SweaveInput"
png ("fig/fig-merged.png", width = 500, height = 425, res=100)
print (plot (chondro.merged [1 : 100], "mat", col.regions = matlab.dark.palette ()))
dev.off()
rm (chondro)


###################################################
### chunk number 65: 
###################################################
#line 1139 "SweaveInput"
merged <- merge (chondro [1:7,, 610 ~ 620], chondro [5:10,, 615 ~ 625], all = TRUE)
merged$.


###################################################
### chunk number 66: approxfun
###################################################
#line 1155 "SweaveInput"
approxfun <- function (y, wl, new.wl){
  approx (wl, y, new.wl, method = "constant",
          ties = function (x) mean (x, na.rm = TRUE)
          )$y
}


###################################################
### chunk number 67: 
###################################################
#line 1164 "SweaveInput"
merged <- apply (merged, 1, approxfun, 
                 wl = wl (merged), new.wl = unique (wl (merged)), 
                 new.wavelength = "new.wl")
merged$.


###################################################
### chunk number 68: cut.wl
###################################################
#line 1208 "SweaveInput"
flu [,, min ~ 408.5]
flu [[,, c (min ~ min + 2i, max - 2i ~ max)]]


###################################################
### chunk number 69: 
###################################################
#line 1223 "SweaveInput"
tmp <- chondro
wl (tmp) <- wl (tmp) - 10


###################################################
### chunk number 70: shift-wl
###################################################
#line 1227 "SweaveInput"
plot (chondro [135])
plot (tmp [135,,], add = TRUE, col = "red")


###################################################
### chunk number 71: fun-interpolate
###################################################
#line 1241 "SweaveInput"
interpolate <- function (spc, shift, wl){
  spline (wl + shift, spc, xout = wl, method = "natural")$y
}


###################################################
### chunk number 72: 
###################################################
#line 1248 "SweaveInput"
tmp <- apply (chondro, 1, interpolate, shift = -10, wl = wl (chondro))


###################################################
### chunk number 73: shift-interp
###################################################
#line 1251 "SweaveInput"
plot (chondro [135])
plot (tmp [135], add = TRUE, col = "red")


###################################################
### chunk number 74: shift-untsch
###################################################
#line 1255 "SweaveInput"
tmp <- chondro [135,, 990 ~ 1010]
plot (tmp, lines.args = list (type = "b", pch = 19, cex = 0.5))
wl (tmp) <- wl(tmp) - 0.5
plot (tmp, lines.args = list (type = "b", pch = 19, cex = 0.5), add = TRUE, col = "red")
tmp <- chondro [135]
tmp <- apply (tmp, 1, function (x, wl, shift)
              spline (wl + shift, x, xout = wl)$y,
              wl = wl (tmp), shift = -0.5)
plot (tmp, lines.args = list (type = "b", pch = 19, cex = 0.5), add = TRUE, col = "blue")


###################################################
### chunk number 75: 
###################################################
#line 1273 "SweaveInput"
shifts <- rnorm (nrow (chondro))
tmp <- chondro [[]]
for (i in seq_len (nrow (chondro)))
  tmp [i, ] <- interpolate (tmp [i, ], shifts [i], wl = wl (chondro))
chondro [[]] <- tmp


###################################################
### chunk number 76: 
###################################################
#line 1300 "SweaveInput"

find.max <- function (y, x){
  pos <- which.max (y) + (-1:1)
  X <- x [pos] - x [pos [2]]
  Y <- y [pos] - y [pos [2]]
  
  X <- cbind (1, X, X^2)
  coef <- qr.solve (X, Y)

  - coef [2] / coef [3] / 2 + x [pos [2]]
}

bandpos <- apply (chondro [[,, 990 ~ 1020]], 1, find.max,  wl (chondro [,, 990 ~ 1020]))
refpos <- find.max (colMeans (chondro[[,, 990 ~ 1020]]),  wl (chondro [,, 990 ~ 1020]))

shift1 <- refpos - bandpos


###################################################
### chunk number 77: 
###################################################
#line 1321 "SweaveInput"
chondro <- chondro - spc.fit.poly.below (chondro [,,min+3i ~ max - 3i], chondro)
chondro <- sweep (chondro, 1, rowMeans (chondro [[]], na.rm = TRUE), "/")


###################################################
### chunk number 78: 
###################################################
#line 1327 "SweaveInput"
targetfn <- function (shift, wl, spc, targetspc){
  error <- spline (wl + shift, spc, xout = wl)$y - targetspc
  sum (error^2)
}

shift2 <- numeric (nrow (chondro))
tmp <- chondro [[]]
target <- colMeans (chondro [[]])
for (i in 1 : nrow (chondro))
  shift2 [i] <- unlist (optimize (targetfn, interval = c (-5, 5), wl = chondro@wavelength, 
                                 spc = tmp[i,], targetspc = target)$minimum)


###################################################
### chunk number 79: shift-fit
###################################################
#line 1346 "SweaveInput"
df <- data.frame (shift = c (shifts, shifts + shift1, shifts + shift2), 
                method = rep (c ("original", "find maximum", "interpolation"), 
                  each = nrow (chondro)))
plot (histogram (~ shift | method, data = df, breaks = do.breaks(range (df$shift), 25),
           layout = c (3,1)))


###################################################
### chunk number 80:  eval=FALSE
###################################################
## #line 1367 "SweaveInput"
## ir.spc <- chondro / 1500 ## fake IR data
## high.int <- apply (ir.spc > 1, 1, any) # any point above 1 is bad
## low.int <- apply (ir.spc, 1, max) < 0.1 # the maximum should be at least 0.1
## ir.spc <- ir.spc [! high.int & ! low.int] 


###################################################
### chunk number 81: 
###################################################
#line 1375 "SweaveInput"
mean_sd_filter <- function (x, n  = 5) {
  x <- x - mean (x)
  s <- n * sd (x) 
  (x <= s) & (x > -s)
}

OK <- apply (chondro [[]], 2, mean_sd_filter, n = 4) # logical matrix

spc.OK <- chondro [apply (OK, 1, all)] 


###################################################
### chunk number 82: filter
###################################################
#line 1387 "SweaveInput"

plot (chondro [! apply (OK, 1, all)])
i <- which (! OK, arr.ind = TRUE)
points (wl (chondro) [i [,2]], chondro[[!OK]], pch = 19, col = "red", cex = 0.5)


###################################################
### chunk number 83: 
###################################################
#line 1403 "SweaveInput"
spc <- chondro [1 : 3,, min ~ min + 15i]
spc [[cbind (1:3, sample (nwl (spc), 3)), wl.index = TRUE]] <- 0
spc [[]]


###################################################
### chunk number 84: 
###################################################
#line 1410 "SweaveInput"
spc [[spc < 1e-4]] <- NA
spc [[]]


###################################################
### chunk number 85: 
###################################################
#line 1421 "SweaveInput"
spc.corrected <- spc.NA.linapprox (spc)
spc.corrected [[]]


###################################################
### chunk number 86: bad
###################################################
#line 1426 "SweaveInput"
spc [[is.na (spc)]] <- 0
plot (spc)
spc [[spc < 1e-4]] <- NA
plot (spc.NA.linapprox (spc), add = TRUE, col = "blue", lines.args = list (type = "b", pch = 19, cex = 0.5))


###################################################
### chunk number 87: fig-loess
###################################################
#line 1450 "SweaveInput"
plot (paracetamol, wl.range = c (300 ~ 1800, 2800 ~ max), xoffset = 850)
p <- spc.loess (paracetamol, c(seq (300, 1800, 2), seq (2850, 3150, 2)))
plot (p, wl.range = c (300 ~ 1800, 2800 ~ max), xoffset = 850, col = "red", add = TRUE)
b <- spc.bin (paracetamol, 4)
plot (b, wl.range = c (300 ~ 1800, 2800 ~ max), xoffset = 850, 
      lines.args = list (pch = 20, cex = .3, type = "p"), col = "blue", add = TRUE)


###################################################
### chunk number 88: fig-loess-kl
###################################################
#line 1458 "SweaveInput"
plot (paracetamol [, , 1600 ~ 1670])
plot (p [, , 1600 ~ 1670], col = "red", add = TRUE)
plot (b [, , 1600 ~ 1670], col = "blue", add = TRUE)


###################################################
### chunk number 89: ofs
###################################################
#line 1495 "SweaveInput"
offsets <- apply (chondro, 1, min)
chondro.offset.corrected <- sweep (chondro, 1, offsets, "-")


###################################################
### chunk number 90: ofs2
###################################################
#line 1502 "SweaveInput"
chondro.offset.corrected <- sweep (chondro, 1, min, "-")


###################################################
### chunk number 91: bl
###################################################
#line 1521 "SweaveInput"
bl <- spc.fit.poly.below (chondro)
chondro <- chondro - bl


###################################################
### chunk number 92: do-bl
###################################################
#line 1532 "SweaveInput"
corrected <- hyperSpec::chondro [1] # start with the unchanged data set

require ("baseline")
bl <- baseline (corrected [[]], method = "modpolyfit", degree = 4)
corrected [[]] <- getCorrected (bl)


###################################################
### chunk number 93: 
###################################################
#line 1542 "SweaveInput"
baseline <- corrected 
baseline [[]] <- getBaseline (bl)
plot (hyperSpec::chondro [1], plot.args = list (ylim = range (hyperSpec::chondro [1], 0)))
plot (baseline, add = TRUE, col = "red")


###################################################
### chunk number 94: 
###################################################
#line 1550 "SweaveInput"
plot (corrected, plot.args = list (ylim = range (hyperSpec::chondro [1], 0)))


###################################################
### chunk number 95: 
###################################################
#line 1559 "SweaveInput"
rm (bl, chondro)


###################################################
### chunk number 96: normalize1
###################################################
#line 1596 "SweaveInput"
chondro <- sweep (chondro, 1, mean, "/")


###################################################
### chunk number 97: norm
###################################################
#line 1609 "SweaveInput"
factors <- 1 / apply (chondro [, , 1600 ~ 1700], 1, mean)
chondro <- sweep (chondro, 1, factors, "*")


###################################################
### chunk number 98: centre-flu
###################################################
#line 1624 "SweaveInput"
flu.centered <- sweep (flu, 2, mean, "-")
plot (flu.centered)


###################################################
### chunk number 99: perc
###################################################
#line 1639 "SweaveInput"
perc.5th <- apply (chondro, 2, quantile, 0.05)
chondro <- sweep (chondro, 2, perc.5th, "-")
plot (chondro, "spcprctl5")


###################################################
### chunk number 100: scale-sweep
###################################################
#line 1655 "SweaveInput"
scaled.chondro <- sweep (chondro, 2, var, "/")


###################################################
### chunk number 101: scale2
###################################################
#line 1660 "SweaveInput"
scaled.chondro <- chondro
scaled.chondro [[]] <- scale (scaled.chondro [[]])


###################################################
### chunk number 102: msc eval=FALSE
###################################################
## #line 1668 "SweaveInput"
## require (pls)
## chondro.msc <- chondro
## chondro.msc [[]] <- msc (chondro [[]])


###################################################
### chunk number 103: label eval=FALSE
###################################################
## #line 1682 "SweaveInput"
## labels (absorbance.spectra)$spc <- "A"


###################################################
### chunk number 104: pca
###################################################
#line 1704 "SweaveInput"
pca <- prcomp (~ spc, data = chondro$., center = FALSE)


###################################################
### chunk number 105: decomp
###################################################
#line 1712 "SweaveInput"
scores <- decomposition (chondro, pca$x, label.wavelength = "PC", 
                         label.spc = "score / a.u.")
scores


###################################################
### chunk number 106: loadings
###################################################
#line 1719 "SweaveInput"
loadings <- decomposition (chondro, t(pca$rotation), scores = FALSE, 
                           label.spc = "loading I / a.u.")
loadings


###################################################
### chunk number 107: retain.col
###################################################
#line 1732 "SweaveInput"
loadings <- decomposition (chondro, t(pca$rotation), scores = FALSE, 
                           retain.columns = TRUE, label.spc = "loading I / a.u.")
loadings[1]$..


###################################################
### chunk number 108: retain
###################################################
#line 1738 "SweaveInput"
chondro$measurement <- 1
loadings <- decomposition (chondro, t(pca$rotation), scores = FALSE, 
                           label.spc = "loading I / a.u.")
loadings[1]$..


###################################################
### chunk number 109: pca-load
###################################################
#line 1747 "SweaveInput"
plot (loadings [1:3], stacked = TRUE)


###################################################
### chunk number 110: pca-score
###################################################
#line 1752 "SweaveInput"
plotmap (scores [,,3], col.regions = div.palette (20))


###################################################
### chunk number 111: pca-smooth
###################################################
#line 1774 "SweaveInput"
smoothed <- scores [,, 1:10] %*% loadings [1:10]


###################################################
### chunk number 112: ggplot eval=FALSE
###################################################
## #line 1783 "SweaveInput"
## require (ggplot2)
## ggplot (as.long.df (chondro [1]), aes (x = .wavelength, y = spc)) + geom_line ()                           


###################################################
### chunk number 113: ggplot-do
###################################################
#line 1787 "SweaveInput"
if (require (ggplot2)){
#line 1783 "SweaveInput#from line#1788#"
require (ggplot2)
ggplot (as.long.df (chondro [1]), aes (x = .wavelength, y = spc)) + geom_line ()                           
#line 1789 "SweaveInput"
  ggsave (file = "fig/fig-ggplot-do.pdf", width = 8, height = 4)
} else {
  pdf ("fig/fig-ggplot-do.pdf", width = 8, height = 4)
  ploterrormsg (NULL, "ggplot2")
  dev.off()
}


###################################################
### chunk number 114: hca
###################################################
#line 1802 "SweaveInput"
dist <- pearson.dist (chondro [[]])
dendrogram <- hclust (dist, method = "ward")


###################################################
### chunk number 115: dend
###################################################
#line 1806 "SweaveInput"
plot (dendrogram)


###################################################
### chunk number 116: dendcut
###################################################
#line 1814 "SweaveInput"
chondro$clusters <- as.factor (cutree (dendrogram, k = 3))


###################################################
### chunk number 117: clustname
###################################################
#line 1818 "SweaveInput"
levels (chondro$clusters) <- c ("matrix", "lacuna", "cell")


###################################################
### chunk number 118: clustmap
###################################################
#line 1822 "SweaveInput"
cluster.cols <- c ("dark blue", "orange", "#C02020")
plotmap (chondro, clusters ~ x * y, col.regions = cluster.cols)


###################################################
### chunk number 119: clustmean
###################################################
#line 1843 "SweaveInput"
means <- aggregate (chondro, by = chondro$clusters, mean_pm_sd)
plot (means, col = cluster.cols, stacked = ".aggregate", fill = ".aggregate")


###################################################
### chunk number 120: split
###################################################
#line 1854 "SweaveInput"
clusters <- split (chondro, chondro$clusters)
clusters


###################################################
### chunk number 121: speed1
###################################################
#line 1871 "SweaveInput"
tmp <- chondro [1 : 50]
shifts <- rnorm (nrow (tmp))
system.time ({
  for (i in seq_len (nrow (tmp)))
    tmp [[i]] <- interpolate (tmp [[i]], shifts [i], wl = wl (tmp))
})


###################################################
### chunk number 122: speed2
###################################################
#line 1884 "SweaveInput"
hy.setOptions (log = FALSE)
tmp <- chondro [1 : 50]
system.time ({
  for (i in seq_len (nrow (tmp)))
    tmp [[i]] <- interpolate (tmp [[i]], shifts [i], wl = wl (tmp))
})
hy.setOptions (log = TRUE)


###################################################
### chunk number 123: speed3
###################################################
#line 1899 "SweaveInput"
tmp <- chondro [1 : 50]
system.time ({
  tmp.matrix <- tmp [[]]
  wl <- wl (tmp)
  for (i in seq_len (nrow (tmp)))
    tmp.matrix [i, ] <- interpolate (tmp.matrix [i, ], shifts [i], wl = wl)
  tmp [[]] <- tmp.matrix
})


###################################################
### chunk number 124: tab-fn
###################################################
#line 1948 "SweaveInput"
make.fn.table <- function (){
load ("functions.RData")
functions <- subset (functions, !internal)
functions$group <- functions$group[,drop=TRUE]

TeX.escape <- function (x){
#  x <- gsub ("^\\\\([^\\\\])", "\\\\\\\\\\1", x)
#  x <- gsub ("[^\\\\]\\\\$", "\\1\\\\\\\\", x)
  x <- gsub ("([^\\\\]|^)\\$", "\\1\\\\$", x)
  x <- gsub ("([^\\\\]|^)_", "\\1\\\\_", x)
  x <- gsub ("([^\\\\]|^)%", "\\1\\\\%", x)
  x
}

for (g in levels (functions$group)){
  cat ("\\multicolumn{2}{l}{\\emph{",g, "}}\\\\\n", sep = "")
  df <- t (functions [functions$group == g, c ("name", "description")])
  cat (paste (paste ("\\verb+", df[1,], "+", sep = ""), df[2,], sep = " & ", collapse ="\\\\\n"),"\\\\\n")
}
}
make.fn.table()


###################################################
### chunk number 125: 
###################################################
#line 1977 "SweaveInput"
make.bib (c ("baseline", "compiler", "Rcpp", "inline"), file = "introduction-pkg.bib")
print (as.matrix(Sys.info()))
#line 355 "SweaveInput#from line#1979#"
sessionInfo ()
rm (list = ls ())
for (f in Sys.glob ("fig/*.pdf")) 
  system (sprintf ("gs -sDEVICE=pdfwrite -dCompatibilityLevel=1.4 -dPDFSETTINGS=/screen -dNOPAUSE -dQUIET -dBATCH -dAutoRotatePages=/None -sOutputFile=tmp.pdf %s && mv tmp.pdf %s", f, f))
#line 1980 "SweaveInput"


