###################################################
### chunk number 1: startup
###################################################
#line 110 "SweaveInput"
system ("mkdir fig")
options(SweaveHooks=list(fig=function() {
  par(mar = c (4.1, 4.1, 1, .6))

  trellis.pars <- trellis.par.get ("layout.heights")
  trellis.pars [grep ("padding", names (trellis.pars))] <- 0
  trellis.par.set(layout.heights = trellis.pars)
  
  trellis.pars <- trellis.par.get ("layout.widths")
  trellis.pars [grep ("padding", names (trellis.pars))] <- 0
  trellis.par.set(layout.widths = trellis.pars)
}))
options ("width" = 100, "digits" = 5)
library (hyperSpec)

# redefine lattice functions so that the result is printed without external print command
setMethod ("plot",
           signature (x = "hyperSpec", y = "character"),
           function (x, y, ...){
             tmp <- hyperSpec:::.plot (x, y, ...)
             if (is (tmp, "trellis"))
               print (tmp)
             invisible (tmp)
           })


plotmap <- function (...) print (hyperSpec:::plotmap (...))

setMethod ("levelplot", signature (x = "hyperSpec", data = "missing"),
   function (x, data, ...) {
	   l <- hyperSpec:::.levelplot (x = formula (spc ~ x * y), data = x, ...)
		print (l)
	}
)

setMethod ("levelplot", signature (x = "formula", data = "hyperSpec"), 
   function (x, data, ...) print (hyperSpec:::.levelplot (x, data, ...))
)

plotc <- function (...){
   call <- match.call () 
   call [[1]] <- hyperSpec:::plotc 
   print (eval (call))
}

ploterrormsg <- function (fn, pkg) {
  plot (0, 0, type = "n", axes = FALSE, bty = "n", xlab = "", ylab = "")
  text (0, 0, paste ("Function", fn, "not available:\npackage", pkg, "needed."))
}
griderrormsg <- function (fn, pkg) {
  require (grid)
  grid.text (label = paste ("Function", fn, "not available:\npackage", pkg, "needed."))
  NA
}
texterrormsg <- function (fn, pkg) {
  cat ("Function", fn, "not available:\npackage", pkg, "needed.\n")
}

nice.paste <- function (...){
  fnames <- c (...)
  
  if (length (fnames) == 2L)
    fnames <- paste (fnames, collapse = " and ")
  if (length (fnames) > 1L){
    fnames [length (fnames)] <- paste ("and", tail (fnames, 1))
    fnames <- paste (fnames, collapse = ", ")
  }

  fnames
}

check.req.pkg <- function (pkg = stop ("pkg needed"), 
                           texterrors = NULL, ploterrors = NULL, griderrors = NULL,
                           hynstext = NULL, hynsplot = NULL, hynsgrid = NULL, 
                           donothing = NULL, special = NULL, v = TRUE){
  if (v) cat ("\\item[\\Rpackage{", pkg, "}:] ", sep = "")
  
  dummies <- list ()
  
  if (pkg.exists (pkg)){
    if (v) cat ("available\n")
  } else {
    for (fn in as.character (texterrors))
      dummies <- c (dummies, bquote (.(fn) <- function (...) texterrormsg (.(fn), .(pkg))))
    for (fn in as.character (ploterrors))
      dummies <- c (dummies, bquote (.(fn) <- function (...) ploterrormsg (.(fn), .(pkg))))
    for (fn in as.character (griderrors))
      dummies <- c (dummies, bquote (.(fn) <- function (...) griderrormsg (.(fn), .(pkg))))

    for (fn in as.character (hynstext))
      assignInNamespace (x = fn, 
                         value = eval (bquote (function (...) texterrormsg (.(fn), .(pkg)))), 
                         ns = "hyperSpec")
    for (fn in as.character (hynsplot))
      assignInNamespace (x = fn, 
                         value = eval (bquote (function (...) ploterrormsg (.(fn), .(pkg)))), 
                         ns = "hyperSpec")
    for (fn in as.character (hynsgrid))
      assignInNamespace (x = fn, 
                         value = eval (bquote (function (...) griderrormsg (.(fn), .(pkg)))), 
                         ns = "hyperSpec")

    fnames <- nice.paste (texterrors, ploterrors, griderrors, hynstext, hynsplot, hynsgrid, names (special))
    if (v && length (fnames) > 0L) cat (fnames, "replaced.")
    
    for (fn in as.character (donothing))
      dummies <- c (dummies, bquote (.(fn) <- function (...) invisible (NULL)))
    
    fnames <- nice.paste (donothing)
    if (v && length (fnames) > 0L) cat (fnames, "missing.")
    
    if (v) cat ("\n")
  }
  
  invisible (dummies)
}

plotvoronoi <- function (...) print (hyperSpec:::plotvoronoi (...))

# set standardized color palettes 
seq.palette <- colorRampPalette (c ("white", "dark green"), space = "Lab")

YG.palette <- function (n = 20) rgb (colorRamp (c("#F7FCF5", "#E5F5E0", "#C7E9C0", "#A1D99B", "#74C476", 
                                             "#41AB5D", "#238B45", "#006D2C", "#00441B"), space = "Lab") 
                                # was: brewer.pal (9, "Greens")
                                (seq (1/3, 1, length.out = n)^2), maxColorValue = 255)

										  
div.palette <- colorRampPalette (c("#00008B", "#351C96", "#5235A2", "#6A4CAE", "#8164BA", "#967CC5", 
                                   "#AC95D1", "#C1AFDC", "#D5C9E8", "#E0E3E3", "#F8F8B0", "#F7E6C2", 
											  "#EFCFC6", "#E6B7AB", "#DCA091", "#D08977", "#C4725E", "#B75B46",
											  "#A9432F", "#9A2919", "#8B0000"), space = "Lab")

pkgSuggests <- function (...)
  strsplit (packageDescription (..., fields="Suggests"), ",\\s*")[[1]]

pkg.exists <- function (pkg = stop ("package name needed"), lib.loc = NULL){
  dir <- sapply (pkg, function (p) system.file (package = p, lib.loc = lib.loc))
  nzchar (dir) > 0L 
}
  
is.basepkg <- function (pkg){
  pkg.exists (pkg) && grepl ("^base$", packageDescription (pkg, fields = "Priority"))
}

pkg.or.base <- function (pkg){
  pkg [sapply (pkg, is.basepkg)] <- "base"
  
  pkg
}

citation.or.file <- function (pkg, svd.cit = sprintf ("%s.CITATION", pkg)){
  if (pkg.exists (pkg))
    citation (pkg)
  else if (file.exists (svd.cit))
    readCitationFile (file = svd.cit)
  else
    NULL
}

make.cite.keys <- function (pkg, entries){
  pkg <- pkg.or.base (pkg)

  if (! pkg.exists (pkg))
    return (pkg)
  
  if (missing (entries))
    entries <- citation.or.file (pkg)
  
  keys <- sapply (unclass (entries), attr, "key")
  
  noname <- which (sapply (keys, is.null))

  if (length (keys) == 1L && noname == 1L) {
    keys <- pkg
  } else {
    for (i in noname)
      keys [[i]] <- paste (pkg, i, sep = ".")
  }

  keys <- make.unique (unlist (keys))
  
  keys
}
  
citation.with.key <- function (pkg = "base"){
  pkg <- pkg.or.base (pkg)

  tmp <- citation.or.file (pkg)
  
  keys <- make.cite.keys (pkg, tmp)

  for (entry in seq_along (tmp))
    tmp [entry]$"key" <- keys [[entry]]

  tmp
}

cite.pkg <- function (p, entries, citefun = "cite"){
  paste ("\\\\", citefun, "{", paste (make.cite.keys (p, entries), collapse = ", "), "}", sep = "")
}

make.bib <- function (..., file = NULL) {
  pkg <- c (...)

  if (length (pkg) == 0L) {
    pkg <- loadedNamespaces()
 
    pkg <- unique (pkg.or.base (pkg))
  }
  
  l <- lapply (pkg, citation.with.key)
  l <- do.call ("c", l [! sapply (l, is.null)])

  if (!is.null (file))
    if (is.null (l))
      cat (NULL, file = file)           # touches file
    else
      cat (toBibtex (l), file = file, sep = "\n")
  
  invisible (l)
}



###################################################
### chunk number 2: mailme
###################################################
#line 336 "SweaveInput"
cat ("\\newcommand{\\mailme}{\\href{mailto:", 
     packageDescription ("hyperSpec")$Maintainer, 
	  "}{\\texttt{", 
	  packageDescription ("hyperSpec")$Maintainer,
	  "}}}\n", 
	  sep = "")


###################################################
### chunk number 3: listfunctions
###################################################
#line 345 "SweaveInput"
texListFun <- function (pattern){
  funs <- ls (envir = getNamespace ("hyperSpec"), pattern = pattern)
  funs <- paste ("\\\\Rfunction{", funs, "}", sep ="")
  nice.paste (funs)
}


###################################################
### chunk number 4: cleanup eval=FALSE
###################################################
## #line 354 "SweaveInput"
## sessionInfo ()
## rm (list = ls ())
## for (f in Sys.glob ("fig/*.pdf")) 
##   system (sprintf ("gs -sDEVICE=pdfwrite -dCompatibilityLevel=1.4 -dPDFSETTINGS=/screen -dNOPAUSE -dQUIET -dBATCH -dAutoRotatePages=/None -sOutputFile=tmp.pdf %s && mv tmp.pdf %s", f, f))


###################################################
### chunk number 5: check-required
###################################################
#line 406 "SweaveInput"
msg <- function (...) system (sprintf ("echo '%s'", paste (...)))

required.pkgs <- c("latticeExtra", "deldir", "rgl", "ggplot2")

dummies <- check.req.pkg ("latticeExtra", griderrors = "panel.levelplot.points",
                          hynsgrid = "plotvoronoi")
for (i in seq_along (dummies))
  eval (dummies [[i]])

check.req.pkg ("deldir", hynsgrid = "plotvoronoi")

for (p in required.pkgs [! required.pkgs %in% c("latticeExtra", "deldir")])
  check.req.pkg (p, donothing = "")


###################################################
### chunk number 6: preproc-chondro
###################################################
#line 428 "SweaveInput"
chondro.preproc <- chondro - spc.fit.poly.below (chondro)
chondro.preproc <- sweep (chondro.preproc, 1, mean, "/")
chondro.preproc <- sweep (chondro.preproc, 2, apply (chondro.preproc, 2, quantile, 0.05), "-")

cluster.cols <- c ("dark blue", "orange", "#C02020")
cluster.meansd <- aggregate (chondro.preproc, chondro$clusters, mean_pm_sd)
cluster.means  <- aggregate (chondro.preproc, chondro$clusters, mean)


###################################################
### chunk number 7: plotspc
###################################################
#line 467 "SweaveInput"
plotspc (paracetamol)


###################################################
### chunk number 8: plotflu
###################################################
#line 478 "SweaveInput"
plotc (flu)


###################################################
### chunk number 9: levelplot
###################################################
#line 484 "SweaveInput"
levelplot (spc ~ x * y, chondro, aspect = "iso")


###################################################
### chunk number 10: plotmap
###################################################
#line 491 "SweaveInput"
plotmap (chondro)


###################################################
### chunk number 11: voronoi
###################################################
#line 497 "SweaveInput"
plotvoronoi (sample (chondro, 300), clusters ~ x * y)


###################################################
### chunk number 12: plotspcflu
###################################################
#line 522 "SweaveInput"
plot (flu, "spc")


###################################################
### chunk number 13: plotchomean
###################################################
#line 528 "SweaveInput"
plot (chondro.preproc, "spcmeansd")


###################################################
### chunk number 14: plotchoprctl
###################################################
#line 538 "SweaveInput"
plot (chondro.preproc, "spcprctile")


###################################################
### chunk number 15: plotchoprctl5
###################################################
#line 544 "SweaveInput"
plot (chondro.preproc, "spcprctl5")


###################################################
### chunk number 16: plotflu2
###################################################
#line 549 "SweaveInput"
plot (flu, "c")


###################################################
### chunk number 17: plotts
###################################################
#line 556 "SweaveInput"
plot (laser [,, 405], "ts")


###################################################
### chunk number 18: plotdepth
###################################################
#line 563 "SweaveInput"
depth.profile <- new ("hyperSpec",
    spc = as.matrix (rnorm (20) + 1:20),
    data = data.frame (z = 1 : 20),
    labels = list (spc = "I / a.u.", 
       z = expression (`/` (z, mu*m)),
       .wavelength = expression (lambda)))
plot (depth.profile, "depth")


###################################################
### chunk number 19: plotmat
###################################################
#line 576 "SweaveInput"
plot (laser, "mat")


###################################################
### chunk number 20: 
###################################################
#line 580 "SweaveInput"
levelplot (spc ~ .wavelength * .row, laser)


###################################################
### chunk number 21: plotmapcho2
###################################################
#line 586 "SweaveInput"
plot (chondro, "map")


###################################################
### chunk number 22: plotvoronoi
###################################################
#line 591 "SweaveInput"
plot (sample (chondro, 300), "voronoi")


###################################################
### chunk number 23: wavelength
###################################################
#line 604 "SweaveInput"
plotspc (paracetamol [,, 700 ~ 1200])


###################################################
### chunk number 24: wavelength-2
###################################################
#line 612 "SweaveInput"
plotspc (paracetamol, 
         wl.range = c (300 ~ 1800, 2800 ~ max), 
         xoffset = 750)


###################################################
### chunk number 25: abscissa
###################################################
#line 622 "SweaveInput"
plotspc (paracetamol, wl.reverse = TRUE )


###################################################
### chunk number 26: colours
###################################################
#line 628 "SweaveInput"
plotspc (flu, col = matlab.dark.palette (6))


###################################################
### chunk number 27: dots
###################################################
#line 634 "SweaveInput"
plotspc (paracetamol [,, 2800 ~ 3200], 
         lines.args = list (pch = 20, type = "p"))


###################################################
### chunk number 28: mass
###################################################
#line 641 "SweaveInput"
plot (barbiturates [[1]], lines.args = list (type = "h"))


###################################################
### chunk number 29: add
###################################################
#line 647 "SweaveInput"
plotspc (chondro [ 30,,])
plotspc (chondro [300,,], add = TRUE, col = "blue")


###################################################
### chunk number 30: sd
###################################################
#line 654 "SweaveInput"
plotspc (chondro.preproc, func = sd)


###################################################
### chunk number 31: diffline
###################################################
#line 661 "SweaveInput"
plotspc (paracetamol, 
         zeroline = list (col = "red"))


###################################################
### chunk number 32: add-line
###################################################
#line 668 "SweaveInput"
plot (laser, "spcmeansd")
abline (v = c(405.0063, 405.1121, 405.2885, 405.3591), 
        col = c("black", "blue", "red", "darkgreen"))


###################################################
### chunk number 33: stacked1
###################################################
#line 681 "SweaveInput"
plotspc (cluster.means, 
         col = cluster.cols,
         stacked = TRUE)


###################################################
### chunk number 34: stacked2
###################################################
#line 690 "SweaveInput"
plot (cluster.meansd, 
      stacked = ".aggregate",
      fill = ".aggregate",
      col = cluster.cols)


###################################################
### chunk number 35: stacked3
###################################################
#line 699 "SweaveInput"
plotspc (cluster.meansd, 
         yoffset = rep (0:2, each = 3), 
         col = rep (cluster.cols, each = 3))


###################################################
### chunk number 36: stacked4
###################################################
#line 707 "SweaveInput"
yoffsets <- apply (cluster.means [[]], 2, diff)
yoffsets <- - apply (yoffsets, 1, min) 
plot (cluster.means, yoffset = c (0, cumsum (yoffsets)), 
      col = cluster.cols)


###################################################
### chunk number 37: stacked5
###################################################
#line 715 "SweaveInput"
yoffset <- apply (chondro.preproc, 2, quantile, c(0.05, 0.95))
yoffset <- range (yoffset)
plot(chondro.preproc[1], 
     plot.args = list (ylim = c (0, 2) * yoffset),
     lines.args = list( type = "n"))
yoffset <- (0:1) * diff (yoffset)
for (i in 1 : 3){
  plot(chondro.preproc, "spcprctl5", yoffset = yoffset [i],
       col = "gray", add = TRUE)
  plot (chondro.preproc [i], yoffset = yoffset [i], 
        col = matlab.dark.palette (3) [i], add = TRUE, 
        lines.args = list (lwd = 2))
}


###################################################
### chunk number 38: lin-cal-1
###################################################
#line 742 "SweaveInput"
plotc (flu [,, 450])


###################################################
### chunk number 39: lin-cal-3
###################################################
#line 749 "SweaveInput"
plotc (flu, func = range, groups = .wavelength)


###################################################
### chunk number 40: plotc2
###################################################
#line 756 "SweaveInput"
plotc (flu [,, c (405, 445)], spc ~ c | .wavelength, 
       cex = .3, scales = list (alternating = c(1, 1)))


###################################################
### chunk number 41: plotc3
###################################################
#line 762 "SweaveInput"
 plotc (flu [,, c (405, 445)], groups = .wavelength)


###################################################
### chunk number 42: lin-cal-4
###################################################
#line 768 "SweaveInput"
plotc (flu [,, 450], 
       ylab = expression (I ["450 nm"] / a.u.),
       xlim = range (0, flu$c + .01), 
       ylim = range (0, flu$spc + 10),
       pch = 4)


###################################################
### chunk number 43: lincal-panel
###################################################
#line 779 "SweaveInput"
panelcalibration <- function (x, y, ..., clim = range (x), level = .95) {
  panel.xyplot (x, y, ...)
  lm <- lm (y ~ x)
  panel.abline (coef (lm), ...)
  cx <- seq (clim [1], clim [2], length.out = 50)
  cy <- predict (lm, data.frame (x = cx), 
                 interval = "confidence", 
                 level = level) 
  panel.lines (cx, cy [,2], col = "gray")
  panel.lines (cx, cy [,3], col = "gray")
}


###################################################
### chunk number 44: lin-cal-5
###################################################
#line 792 "SweaveInput"
plotc (flu [,,405], panel = panelcalibration,
       pch = 4, clim = c (0, 0.35), level = .99)


###################################################
### chunk number 45: plotc4
###################################################
#line 804 "SweaveInput"
 plotc (laser [,, c(405.0063, 405.1121, 405.2885, 405.3591)], 
        spc ~ t, 
        groups = .wavelength, 
        type = "b", 
        col = c ("black", "blue", "red", "darkgreen"))


###################################################
### chunk number 46: levelplot
###################################################
#line 825 "SweaveInput"
 levelplot (spc ~ x * y, chondro)


###################################################
### chunk number 47: levelplot-factor
###################################################
#line 831 "SweaveInput"
 levelplot (clusters ~ x * y, chondro)


###################################################
### chunk number 48: 
###################################################
#line 847 "SweaveInput"
plot (laser, "mat", 
      col.regions = matlab.palette (20) )


###################################################
### chunk number 49: plotmat1
###################################################
#line 852 "SweaveInput"
levelplot (spc ~ .wavelength * .row, 
           laser,
           col.regions = matlab.palette (20))


###################################################
### chunk number 50: plotmat1a
###################################################
#line 860 "SweaveInput"
levelplot (spc ~ .wavelength * t, laser)


###################################################
### chunk number 51: plotmap-barb
###################################################
#line 865 "SweaveInput"
require ("latticeExtra")
barb <- do.call (collapse, barbiturates[1:50])
barb <- orderwl (barb)
levelplot (spc ~ .wavelength * z, barb, 
           panel = panel.levelplot.points,
           cex = .33, col.symbol = NA,
           col.regions = matlab.palette)


###################################################
### chunk number 52: plotmat2
###################################################
#line 877 "SweaveInput"
plot (flu, "mat", 
      contour = TRUE, 
      labels = TRUE, 
      col = "#00000080",
      at = seq (0, 700, by = 50))


###################################################
### chunk number 53: plotmap-chondro
###################################################
#line 894 "SweaveInput"
plotmap (chondro)


###################################################
### chunk number 54: plotmap-yx
###################################################
#line 901 "SweaveInput"
plotmap (chondro, spc ~ y * x)


###################################################
### chunk number 55: plotmap-clu
###################################################
#line 906 "SweaveInput"
plotmap (chondro, clusters ~ x * y)


###################################################
### chunk number 56: plotmap-col
###################################################
#line 914 "SweaveInput"
print (plotmap (chondro, clusters ~ x * y,
                col.regions = cluster.cols))


###################################################
### chunk number 57: plotmap-wave
###################################################
#line 921 "SweaveInput"
plotmap (chondro.preproc [, , c(728, 782, 1098, 
                                1240, 1482, 1577)],
         col.regions = matlab.palette)


###################################################
### chunk number 58: plotmap-pca
###################################################
#line 928 "SweaveInput"
plotmap (chondro, 
         spc ~ y * x | x > 5, 
         col.regions = matlab.palette(20))


###################################################
### chunk number 59: plotmap-pca2
###################################################
#line 940 "SweaveInput"
pca <- prcomp (~ spc, data = chondro.preproc$.)
scores <- decomposition (chondro, pca$x, 
                         label.wavelength = "PC", 
                         label.spc = "score /  a.u.")
plotmap (scores [,,1:2], 
         spc ~ y * x | as.factor(.wavelength), 
         func = NULL,
         col.regions = matlab.palette(20))


###################################################
### chunk number 60: plotmap-pca3
###################################################
#line 953 "SweaveInput"
levelplot (spc ~ y * x | as.factor(.wavelength), 
           scores [,,1:2], 
           aspect = "iso",
           col.regions = matlab.palette(20))


###################################################
### chunk number 61: voronoi-2
###################################################
#line 961 "SweaveInput"
plotvoronoi (sample (chondro, 300), clusters ~ x * y, 
             col.regions = matlab.palette(20))


###################################################
### chunk number 62: missing
###################################################
#line 975 "SweaveInput"
mark.missing <- function (x, y, z, ...){
  panel.levelplot (x, y, z, ...)

  miss <- expand.grid (x = unique (x), y = unique (y))
  miss <- merge (miss, data.frame (x, y, TRUE), 
                 all.x = TRUE)
  miss <- miss [is.na (miss[, 3]),]
  panel.xyplot (miss [, 1], miss [, 2], pch = 4, ...)
}

plotmap (sample (chondro, 865), 
         col.regions = matlab.palette(20),
         col = "black",
         panel = mark.missing)


###################################################
### chunk number 63: rgl-plot eval=FALSE
###################################################
## #line 1011 "SweaveInput"
## laser <- laser [,,404.8 ~ 405.6] / 10000
## laser$t <- laser$t / 3600
## cols <- rep (matlab.palette (nrow (laser)), nwl (laser))
## surface3d (y = wl (laser), x = laser$t, 
##            z = laser$spc, col =  cols)
## aspect3d (c (1, 1, 0.25))
## axes3d (c ('x+-', 'y--', 'z--'))
## axes3d ('y--', nticks = 25, labels= FALSE)
## mtext3d ("t / h", 'x+-', line = 2.5)
## mtext3d ("λ / nm", 'y--', line = 2.5)
## mtext3d ("I / a.u.", edge = 'z--', line = 2.5)


###################################################
### chunk number 64: rgl-do
###################################################
#line 1025 "SweaveInput"
if (exists (".rgl") && .rgl){        # use extra argument to turn on rgl only on local machine as it doesn't work on r-forge.
  if (require (rgl)){
    open3d (windowRect=c(20,20,600, 350))  # this is needed only for automatically 
                                        # producing the snapshot
#line 1011 "SweaveInput#from line#1029#"
laser <- laser [,,404.8 ~ 405.6] / 10000
laser$t <- laser$t / 3600
cols <- rep (matlab.palette (nrow (laser)), nwl (laser))
surface3d (y = wl (laser), x = laser$t, 
           z = laser$spc, col =  cols)
aspect3d (c (1, 1, 0.25))
axes3d (c ('x+-', 'y--', 'z--'))
axes3d ('y--', nticks = 25, labels= FALSE)
mtext3d ("t / h", 'x+-', line = 2.5)
mtext3d ("λ / nm", 'y--', line = 2.5)
mtext3d ("I / a.u.", edge = 'z--', line = 2.5)
#line 1030 "SweaveInput"
     par3d (userMatrix = matrix (c (-0.52,  0.4, -0.75, 0, 
                                    -0.85, -0.28, 0.44, 0, 
                                    -0.04,  0.87, 0.49, 0, 
                                    -0.75,  0.75,     0, 1), ncol = 4L),
            scale = c (2.75, 5, 0.175),
            windowRect = c(20L, 50L, 520L, 330L),
            zoom = 0.75)
    rgl.snapshot ("fig-3D.png", fmt="png", top=TRUE )
    rgl.quit ()
  } else {
    png ("fig-3D.png")
    ploterrormsg ("", "rgl")
    dev.off ()
  }
}


###################################################
### chunk number 65: ggplotspc eval=FALSE
###################################################
## #line 1059 "SweaveInput"
## df <- as.long.df (flu, rownames = TRUE)
## ggplot (df, aes (x = .wavelength, y = spc, 
##                  colour = c, groups = .rownames)) + 
##   geom_line () +
##   xlab (labels (flu)$.wavelength) +
##   ylab (labels (flu)$spc) 


###################################################
### chunk number 66: ggplotmap eval=FALSE
###################################################
## #line 1081 "SweaveInput"
## df <- as.long.df (apply (chondro, 1, mean))
## ggplot (df,aes (x = x, y = y, fill = spc)) +
##   geom_tile() + 
##   scale_fill_continuous ("spc", matlab.palette ()) +
##   scale_x_continuous (expand = c (0, 0)) +
##   scale_y_continuous (expand = c (0, 0)) +
##   coord_equal ()


###################################################
### chunk number 67: ggplotmeansd eval=FALSE
###################################################
## #line 1092 "SweaveInput"
## df <- as.t.df (apply (chondro, 2, mean_pm_sd))
## ggplot (df, aes (x = .wavelength)) +
##   geom_ribbon (aes (ymin = mean.minus.sd, 
##                     ymax = mean.plus.sd), 
##                fill = "#00000040") +
##   geom_line (aes (y = mean)) +
##   xlab (labels (chondro)$.wavelength) +
##   ylab (labels (chondro)$spc) 


###################################################
### chunk number 68: ggplotspccut eval=FALSE
###################################################
## #line 1104 "SweaveInput"
## df <- paracetamol [,, c( min ~ 1800, 2800 ~ max)] / 1e4
## df <- as.long.df (df)
## df$range <- factor (df$.wavelength > 2000)
## ggplot (df, aes (x = .wavelength, y = spc)) +
##   geom_line () + 
##   facet_grid (. ~ range, labeller = function (...) "",
##               scales = "free", space = "free") +
##   scale_x_continuous (breaks = seq (0, 3200, 400)) +
##   opts (strip.background = theme_blank ())


###################################################
### chunk number 69: ggplot2-do
###################################################
#line 1116 "SweaveInput"
if (require (ggplot2)){
#line 1059 "SweaveInput#from line#1117#"
df <- as.long.df (flu, rownames = TRUE)
ggplot (df, aes (x = .wavelength, y = spc, 
                 colour = c, groups = .rownames)) + 
  geom_line () +
  xlab (labels (flu)$.wavelength) +
  ylab (labels (flu)$spc) 
#line 1118 "SweaveInput"
  ggsave("fig/fig-ggplotspc.pdf", width = 4, height = 2.6)
#line 1081 "SweaveInput#from line#1119#"
df <- as.long.df (apply (chondro, 1, mean))
ggplot (df,aes (x = x, y = y, fill = spc)) +
  geom_tile() + 
  scale_fill_continuous ("spc", matlab.palette ()) +
  scale_x_continuous (expand = c (0, 0)) +
  scale_y_continuous (expand = c (0, 0)) +
  coord_equal ()
#line 1120 "SweaveInput"
  ggsave("fig/fig-ggplotmap.pdf", width = 4, height = 2.6)
#line 1092 "SweaveInput#from line#1121#"
df <- as.t.df (apply (chondro, 2, mean_pm_sd))
ggplot (df, aes (x = .wavelength)) +
  geom_ribbon (aes (ymin = mean.minus.sd, 
                    ymax = mean.plus.sd), 
               fill = "#00000040") +
  geom_line (aes (y = mean)) +
  xlab (labels (chondro)$.wavelength) +
  ylab (labels (chondro)$spc) 
#line 1122 "SweaveInput"
  ggsave("fig/fig-ggplotmeansd.pdf", width = 4, height = 2.6)
#line 1104 "SweaveInput#from line#1123#"
df <- paracetamol [,, c( min ~ 1800, 2800 ~ max)] / 1e4
df <- as.long.df (df)
df$range <- factor (df$.wavelength > 2000)
ggplot (df, aes (x = .wavelength, y = spc)) +
  geom_line () + 
  facet_grid (. ~ range, labeller = function (...) "",
              scales = "free", space = "free") +
  scale_x_continuous (breaks = seq (0, 3200, 400)) +
  opts (strip.background = theme_blank ())
#line 1124 "SweaveInput"
  ggsave("fig/fig-ggplotspccut.pdf", width = 4, height = 2.6)
} else {
  for (f in c ("ggplotspc", "ggplotmap", "ggplotmeansd", "ggplotspccut")){
    pdf (sprintf ("fig/fig-%s.pdf", f), width = 4, height = 2.6) 
    ploterrormsg ("", "ggplot2")
    dev.off ()
  }
}


###################################################
### chunk number 70:  eval=FALSE
###################################################
## #line 1163 "SweaveInput"
## spc.identify (plotspc (paracetamol, wl.range = c (600 ~ 1800, 2800 ~ 3200), xoffset = 800))


###################################################
### chunk number 71:  eval=FALSE
###################################################
## #line 1172 "SweaveInput"
## map.identify (chondro)


###################################################
### chunk number 72:  eval=FALSE
###################################################
## #line 1180 "SweaveInput"
## map.sel.poly (chondro)


###################################################
### chunk number 73:  eval=FALSE
###################################################
## #line 1194 "SweaveInput"
## plot (laser, "mat")
## trellis.focus ()
## grid.locator ()


###################################################
### chunk number 74: bib
###################################################
#line 1215 "SweaveInput"
make.bib (c("latticeExtra", "rgl", "ggplot2", "playwith", "latticist", "plotrix", "deldir", "tripack"), 
          file = "plotting-pkg.bib")
print (as.matrix(Sys.info()))
#line 354 "SweaveInput#from line#1218#"
sessionInfo ()
rm (list = ls ())
for (f in Sys.glob ("fig/*.pdf")) 
  system (sprintf ("gs -sDEVICE=pdfwrite -dCompatibilityLevel=1.4 -dPDFSETTINGS=/screen -dNOPAUSE -dQUIET -dBATCH -dAutoRotatePages=/None -sOutputFile=tmp.pdf %s && mv tmp.pdf %s", f, f))
#line 1219 "SweaveInput"


