###################################################
### chunk number 1: preliminaries
###################################################
#line 36 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
options(width=80, show.signif.stars = FALSE,
        lattice.theme = function() canonical.theme("pdf", color = FALSE))
library(lattice)
library(Matrix)
library(lme4)
data("Rail", package = "MEMSS")
data("ScotsSec", package = "mlmRev")


###################################################
### chunk number 2: strRail
###################################################
#line 54 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
str(Rail)


###################################################
### chunk number 3: Raildotplot
###################################################
#line 61 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
print(dotplot(reorder(Rail,travel)~travel,Rail,xlab="Travel time (ms)",ylab="Rail"))


###################################################
### chunk number 4: Raildata
###################################################
#line 74 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
Rail


###################################################
### chunk number 5: RailfitML
###################################################
#line 140 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
Rm1ML <- lmer(travel ~ 1 + (1|Rail), Rail, REML = FALSE, verbose = TRUE)


###################################################
### chunk number 6: Railfitshow
###################################################
#line 152 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
Rm1ML


###################################################
### chunk number 7: ZXytRail
###################################################
#line 165 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
Rm1ML@Zt
as(Rail[["Rail"]], "sparseMatrix")


###################################################
### chunk number 8: fewdigits
###################################################
#line 218 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
op <- options(digits=4)


###################################################
### chunk number 9: LRm1ML
###################################################
#line 223 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
as(Rm1ML@L, "sparseMatrix")


###################################################
### chunk number 10: unfewdigits
###################################################
#line 226 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
options(op)


###################################################
### chunk number 11: devRm1ML
###################################################
#line 234 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
Rm1ML@deviance


###################################################
### chunk number 12: ldZRm1ML
###################################################
#line 243 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
L <- as(Rm1ML@L, "sparseMatrix")
2 * sum(log(diag(L)))


###################################################
### chunk number 13: lr2Rm1ML
###################################################
#line 251 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
(RX <- Rm1ML@RX)


###################################################
### chunk number 14: ldXRm1ML
###################################################
#line 258 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
2 * sum(log(diag(Rm1ML@RX)))


###################################################
### chunk number 15: dimsRm1ML
###################################################
#line 266 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
(dd <- Rm1ML@dims)


###################################################
### chunk number 16: s2Rm1ML
###################################################
#line 273 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
Rm1ML@deviance["pwrss"]/dd["n"]


###################################################
### chunk number 17: devcomp
###################################################
#line 294 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
mm <- Rm1ML
sg <- seq(0, 20, len = 101)
dev <- mm@deviance
nc <- length(dev)
nms <- names(dev)
vals <- matrix(0, nrow = length(sg), ncol = nc, dimnames = list(NULL, nms))
for (i in seq(along = sg)) {
    .Call("mer_ST_setPars", mm, sg[i], PACKAGE = "lme4")
    .Call("mer_update_L", mm, PACKAGE = "lme4")
    res <- try(.Call("mer_update_RX", mm, PACKAGE = "lme4"), silent = TRUE)
    if (inherits(res, "try-error")) {
        vals[i,] <- NA
    } else {
        .Call("mer_update_ranef", mm, PACKAGE = "lme4")
        vals[i,] <- mm@deviance
    }
}
print(xyplot(ML + ldL2 + sigmaML + pwrss + disc + usqr ~ sg, as.data.frame(vals),
             type = c("g", "l"), outer = TRUE, layout = c(1,6),
             xlab = expression(sigma[b]/sigma), ylab = NULL,
             scales = list(x = list(axs = 'i'),
             y = list(relation = "free", rot = 0)),
             strip = FALSE, strip.left = TRUE))


###################################################
### chunk number 18: leftlr2
###################################################
#line 345 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
18 * log(deviance(lm(travel ~ 1, Rail)))


###################################################
### chunk number 19: rightlr2
###################################################
#line 352 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
18 * log(deviance(lm(travel ~ Rail, Rail)))


###################################################
### chunk number 20: devcomp2
###################################################
#line 356 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
mm <- Rm1ML
sg <- seq(3.75, 8.25, len = 101)
vals <- matrix(0, nrow = length(sg), ncol = length(dev),
               dimnames = list(NULL, names(dev)))
for (i in seq_along(sg)) {
    .Call("mer_ST_setPars", mm, sg[i], PACKAGE = "lme4")
    .Call("mer_update_L", mm, PACKAGE = "lme4")
    res <- try(.Call("mer_update_RX", mm, PACKAGE = "lme4"), silent = TRUE)
    if (inherits(res, "try-error")) {
        vals[i,] <- NA
    } else {
        .Call("mer_update_ranef", mm, PACKAGE = "lme4")
        vals[i,] <- mm@deviance
    }
}
print(xyplot(ML + ldL2 + I(18 * log(pwrss)) ~ sg, as.data.frame(vals),
             type = c("g", "l"), outer = TRUE, layout = c(1,3),
             xlab = expression(sigma[b]/sigma), ylab = NULL,
             scales = list(x = list(axs = 'i'),
             y = list(relation = "free", rot = 0)),
             strip = FALSE, strip.left = TRUE))
## base <- 18 * log(deviance(lm(travel ~ Rail, Rail)))
## print(xyplot(devC + ldL2 ~ sg,
##              data.frame(ldL2 = vals[,"ldL2"], devC =
##                         vals[, "ldL2"] + mm@dims['n'] * log(vals[, "pwrss"]) - base,
##                         sg = sg), type = c("g", "l"),
##              scales = list(x = list(axs = 'i')), aspect = 1.8,
##              xlab = expression(sigma[1]), ylab = "Shifted deviance",
##              auto.key = list(text = c("deviance", "log|SZ'ZS + I|"),
##              space = "right", points = FALSE, lines = TRUE)))


###################################################
### chunk number 21: sleepxyplot
###################################################
#line 405 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
print(xyplot(Reaction ~ Days | Subject, sleepstudy, aspect = "xy",
             layout = c(6,3), type = c("g", "p", "r"),
             index.cond = function(x,y) coef(lm(y ~ x))[1],
             xlab = "Days of sleep deprivation",
             ylab = "Average reaction time (ms)"))


###################################################
### chunk number 22: sm1
###################################################
#line 433 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
print(sm1 <- lmer(Reaction ~ Days + (Days|Subject), sleepstudy))


###################################################
### chunk number 23: sm1struct
###################################################
#line 442 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
print(image(tcrossprod(sm1@A), colorkey = FALSE, sub = NULL),
      split = c(1,1,2,1), more = TRUE)
print(image(sm1@L, colorkey = FALSE, sub = NULL),
      split = c(2,1,2,1))


###################################################
### chunk number 24: A1212
###################################################
#line 471 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
as(sm1@L, "sparseMatrix")[1:2,1:2]
sm1@RX


###################################################
### chunk number 25: sm1deviance
###################################################
#line 477 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
sm1@deviance


###################################################
### chunk number 26: sm1reconstruct
###################################################
#line 485 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
sm1@RX
str(dL <- diag(as(sm1@L, "sparseMatrix")))
c(ldL2 = sum(log(dL^2)), ldRX2 = sum(log(diag(sm1@RX)^2)), log(sm1@deviance["pwrss"]))


###################################################
### chunk number 27: sm1ST
###################################################
#line 496 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
show(st <- sm1@ST[[1]])


###################################################
### chunk number 28: sm1VarCorr
###################################################
#line 506 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
show(vc <- VarCorr(sm1))


###################################################
### chunk number 29: sm1VarCorrRec
###################################################
#line 513 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
T <- st
diag(T) <- 1
S <- diag(diag(st))
T
S
T %*% S %*% S %*% t(T) * attr(vc, "sc")^2


###################################################
### chunk number 30: Oatsxy
###################################################
#line 526 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
data(Oats, package = 'MEMSS')
print(xyplot(yield ~ nitro | Block, Oats, groups = Variety, type = c("g", "b"),
             auto.key = list(lines = TRUE, space = 'top', columns = 3),
             xlab = "Nitrogen concentration (cwt/acre)",
             ylab = "Yield (bushels/acre)",
             aspect = 'xy'))


###################################################
### chunk number 31: Om1
###################################################
#line 552 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
print(Om1 <- lmer(yield ~ nitro + Variety + (1|Block/Variety), Oats), corr = FALSE)


###################################################
### chunk number 32: Om1struct
###################################################
#line 568 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
print(image(tcrossprod(Om1@A), colorkey = FALSE, sub = NULL),
       split = c(1,1,2,1), more = TRUE)
print(image(Om1@L, colorkey = FALSE, sub = NULL), split = c(2,1,2,1))


###################################################
### chunk number 33: Om1a
###################################################
#line 595 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
print(Om1a <- lmer(yield ~ nitro + (1|Block/Variety), Oats), corr = FALSE)


###################################################
### chunk number 34: Om1astruct
###################################################
#line 600 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
print(image(tcrossprod(Om1a@A), colorkey = FALSE, sub = NULL),
      split = c(1,1,2,1), more = TRUE)
print(image(Om1a@L, colorkey = FALSE, sub = NULL), split = c(2,1,2,1))


###################################################
### chunk number 35: sm2
###################################################
#line 627 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
print(sm2 <- lmer(Reaction ~ Days + (1|Subject) + (0+Days|Subject), sleepstudy), corr = FALSE)


###################################################
### chunk number 36: sm2struct
###################################################
#line 633 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
print(image(tcrossprod(sm2@A), colorkey = FALSE, sub = NULL),
      split = c(1,1,2,1), more = TRUE)
print(image(sm2@L, colorkey = FALSE, sub = NULL), split = c(2,1,2,1))


###################################################
### chunk number 37: sm2perm
###################################################
#line 650 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
str(sm2@L@perm)


###################################################
### chunk number 38: Om2
###################################################
#line 661 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
print(Om2 <- lmer(yield ~ nitro + (1|Variety:Block) + (nitro|Block), Oats), corr = FALSE)


###################################################
### chunk number 39: Om2struct
###################################################
#line 666 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
print(image(tcrossprod(Om2@A), colorkey = FALSE, sub = NULL),
      split = c(1,1,2,1), more = TRUE)
print(image(Om2@L, colorkey = FALSE, sub = NULL),
      split = c(2,1,2,1))


###################################################
### chunk number 40: Om2ALsize
###################################################
#line 706 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
length(tcrossprod(Om2@A)@x)
length(Om2@L@x)


###################################################
### chunk number 41: ScotsSec
###################################################
#line 727 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
str(ScotsSec)


###################################################
### chunk number 42: Sm1
###################################################
#line 737 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
print(Sm1 <- lmer(attain ~ verbal * sex + (1|primary) + (1|second), ScotsSec), corr = FALSE)


###################################################
### chunk number 43: Sm1dims
###################################################
#line 741 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
Sm1@dims


###################################################
### chunk number 44: Scotscrosstab
###################################################
#line 749 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
head(xtabs(~ primary + second, ScotsSec))


###################################################
### chunk number 45: Sm1struct
###################################################
#line 756 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
print(image(tcrossprod(Sm1@A), colorkey = FALSE, sub = NULL),
      split = c(1,1,2,1), more = TRUE)
print(image(Sm1@L, colorkey = FALSE, sub = NULL), split = c(2,1,2,1))


###################################################
### chunk number 46: Sm1fill
###################################################
#line 779 "d:/Rcompile/CRANpkg/local/2.12/lme4/inst/doc/Implementation.Rnw"
c(A = length(tcrossprod(Sm1@A)@x), L = length(Sm1@L@x))


