###################################################
### chunk number 1: startAnalysis
###################################################
#line 42 "d:/Rcompile/CRANpkg/local/2.12/maticce/inst/doc/maticce.Rnw"
library(maticce) # load maticce and required packages
data(carex) # load dataset
attach(carex) # attach dataset to search path
# convert the Bayes consensus to an ouchtree object...
ovales.tree <- ape2ouch(ovales.tree) 
# ... then convert the first 10 trees visited in the MCMC 
#     analysis to ouchtree objects
trees <- lapply(ovales.bayesTrees[1:10], ape2ouch) 


###################################################
### chunk number 2: paintingOne
###################################################
#line 99 "d:/Rcompile/CRANpkg/local/2.12/maticce/inst/doc/maticce.Rnw"
ou2 <- paintBranches(list(ovales.nodes[[2]]), ovales.tree)


###################################################
### chunk number 3: ov2
###################################################
#line 105 "d:/Rcompile/CRANpkg/local/2.12/maticce/inst/doc/maticce.Rnw"
plot(ovales.tree, regimes = ou2, cex = 1.2)


###################################################
### chunk number 4: runBatch
###################################################
#line 124 "d:/Rcompile/CRANpkg/local/2.12/maticce/inst/doc/maticce.Rnw"
# First, analyze with maxNodes set to 2
ha.4.2 <- runBatchHansen(ovales.tree, ovales.data, 
          ovales.nodes[1:4], maxNodes = 2, brown = T)
print(summary(ha.4.2))
# Then, analyze with maxNodes set to 4
ha.4.4 <- runBatchHansen(ovales.tree, ovales.data, 
          ovales.nodes[1:4], maxNodes = 4, brown = T)
print(summary(ha.4.4))
# Then, assess the effects of phylogenetic uncertainty by 
#   analyzing over a set of trees
ha.4.2.multi <- runBatchHansen(trees, ovales.data, 
                ovales.nodes[1:4], maxNodes = 2, brown = T)
print(summary(ha.4.2.multi))


###################################################
### chunk number 5: ouSim
###################################################
#line 144 "d:/Rcompile/CRANpkg/local/2.12/maticce/inst/doc/maticce.Rnw"
ouSim.ha.4.2 <- ouSim(ha.4.2, tree = ovales.tree)
plot(ouSim.ha.4.2, colors = ou2)


###################################################
### chunk number 6: ha
###################################################
#line 153 "d:/Rcompile/CRANpkg/local/2.12/maticce/inst/doc/maticce.Rnw"
ha.4.2[['regMatrix']][['overall']]


###################################################
### chunk number 7: haLnl
###################################################
#line 159 "d:/Rcompile/CRANpkg/local/2.12/maticce/inst/doc/maticce.Rnw"
ha.4.2[['hansens']][[1]][c(7, 11, 'brown'), ]


###################################################
### chunk number 8: haWeights
###################################################
#line 165 "d:/Rcompile/CRANpkg/local/2.12/maticce/inst/doc/maticce.Rnw"
summary(ha.4.2)[['modelsMatrix']][[1]][c(7, 11, 'brown'), ]


###################################################
### chunk number 9: multiModel
###################################################
#line 171 "d:/Rcompile/CRANpkg/local/2.12/maticce/inst/doc/maticce.Rnw"
layout(matrix(1:9, 3, 3))
for(i in 1:8) {   
  mm <- multiModel(carex[['ovales.tree']], ovales.data, 
        ovales.nodes[[i]])
  pie(mm[['IC']][['BICwi']], labels = mm[['IC']][['names']], 
    col = rainbow(length(mm[['IC']][['names']])), 
    main = paste("Node",i,"BICwi"))
  }


