###################################################
### chunk number 1: foo
###################################################
#line 28 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/bfst.Rnw"
options(keep.source = TRUE, width = 65)


###################################################
### chunk number 2: library
###################################################
#line 357 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/bfst.Rnw"
library(mcmc)


###################################################
### chunk number 3: baz
###################################################
#line 360 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/bfst.Rnw"
baz <- library(help = "mcmc")
baz <- baz$info[[1]]
baz <- baz[grep("Version", baz)]
baz <- sub("^Version: *", "", baz)
bazzer <- paste(R.version$major, R.version$minor, sep = ".")


###################################################
### chunk number 4: set-seed
###################################################
#line 373 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/bfst.Rnw"
set.seed(42)


###################################################
### chunk number 5: frequentist
###################################################
#line 387 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/bfst.Rnw"
data(logit)
out <- glm(y ~ x1 + x2 + x3 + x4, data = logit,
    family = binomial, x = TRUE)
summary(out)


###################################################
### chunk number 6: models
###################################################
#line 407 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/bfst.Rnw"
varnam <- names(coefficients(out))
varnam <- varnam[varnam != "(Intercept)"]
nvar <- length(varnam)

models <- NULL
foo <- seq(0, 2^nvar - 1) 
for (i in 1:nvar) {
    bar <- foo %/% 2^(i - 1)
    bar <- bar %% 2
    models <- cbind(bar, models, deparse.level = 0)
}
colnames(models) <- varnam
models


###################################################
### chunk number 7: neighbor
###################################################
#line 429 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/bfst.Rnw"
neighbors <- matrix(FALSE, nrow(models), nrow(models))
for (i in 1:nrow(neighbors)) {
    for (j in 1:ncol(neighbors)) {
        foo <- models[i, ]
        bar <- models[j, ]
        if (sum(foo != bar) == 1) neighbors[i, j] <- TRUE
    }
}


###################################################
### chunk number 8: ludfun
###################################################
#line 469 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/bfst.Rnw"
modmat <- out$x
y <- logit$y

ludfun <- function(state, log.pseudo.prior) {
    stopifnot(is.numeric(state))
    stopifnot(length(state) == ncol(models) + 2)
    icomp <- state[1]
    stopifnot(icomp == as.integer(icomp))
    stopifnot(1 <= icomp && icomp <= nrow(models))
    stopifnot(is.numeric(log.pseudo.prior))
    stopifnot(length(log.pseudo.prior) == nrow(models))
    beta <- state[-1]
    inies <- c(TRUE, as.logical(models[icomp, ]))
    beta.logl <- beta
    beta.logl[! inies] <- 0
    eta <- as.numeric(modmat %*% beta.logl)
    logp <- ifelse(eta < 0, eta - log1p(exp(eta)), - log1p(exp(- eta)))
    logq <- ifelse(eta < 0, - log1p(exp(eta)), - eta - log1p(exp(- eta)))
    logl <- sum(logp[y == 1]) + sum(logq[y == 0])
    logl + sum(dnorm(beta, 0, 2, log = TRUE)) + log.pseudo.prior[icomp]
}


###################################################
### chunk number 9: try1
###################################################
#line 498 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/bfst.Rnw"
state.initial <- c(nrow(models), out$coefficients)

qux <- rep(0, nrow(models))

out <- temper(ludfun, initial = state.initial, neighbors = neighbors,
    nbatch = 1000, blen = 100, log.pseudo.prior = qux)

names(out)
out$time


###################################################
### chunk number 10: what
###################################################
#line 510 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/bfst.Rnw"
ibar <- colMeans(out$ibatch)
ibar


###################################################
### chunk number 11: adjust
###################################################
#line 516 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/bfst.Rnw"
qux <- qux + pmin(log(max(ibar) / ibar), 10)
qux <- qux - min(qux)
qux


###################################################
### chunk number 12: iterate
###################################################
#line 536 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/bfst.Rnw"
qux.save <- qux
time.save <- out$time
repeat{
    out <- temper(out, log.pseudo.prior = qux)
    ibar <- colMeans(out$ibatch)
    qux <- qux + pmin(log(max(ibar) / ibar), 10)
    qux <- qux - min(qux)
    qux.save <- rbind(qux.save, qux, deparse.level = 0)
    time.save <- rbind(time.save, out$time, deparse.level = 0)
    if (max(ibar) / min(ibar) < 2) break
}
qux.save
qux
apply(time.save, 2, sum)


###################################################
### chunk number 13: accept-i-x
###################################################
#line 555 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/bfst.Rnw"
out$accepti
out$acceptx


###################################################
### chunk number 14: accept-i-min
###################################################
#line 560 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/bfst.Rnw"
min(as.vector(out$accepti), na.rm = TRUE)


###################################################
### chunk number 15: scale
###################################################
#line 566 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/bfst.Rnw"
out <- temper(out, scale = 0.5, log.pseudo.prior = qux)
time.save <- rbind(time.save, out$time, deparse.level = 0)
out$acceptx


###################################################
### chunk number 16: try6
###################################################
#line 576 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/bfst.Rnw"
out <- temper(out, blen = 10 * out$blen, log.pseudo.prior = qux)
time.save <- rbind(time.save, out$time, deparse.level = 0)
foo <- apply(time.save, 2, sum)
foo.min <- floor(foo[1] / 60)
foo.sec <- foo[1] - 60 * foo.min
c(foo.min, foo.sec)


###################################################
### chunk number 17: doit
###################################################
#line 591 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/bfst.Rnw"
log.10.unnorm.bayes <- (qux - log(colMeans(out$ibatch))) / log(10)
k <- seq(along = log.10.unnorm.bayes)[log.10.unnorm.bayes
    == min(log.10.unnorm.bayes)]
models[k, ]

log.10.bayes <- log.10.unnorm.bayes - log.10.unnorm.bayes[k]
log.10.bayes


###################################################
### chunk number 18: doit-se-one
###################################################
#line 631 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/bfst.Rnw"
fred <- var(out$ibatch) / out$nbatch
sally <- colMeans(out$ibatch)
mcse.log.10.bayes <- (1 / log(10)) * sqrt(diag(fred) / sally^2 -
    2 * fred[ , k] / (sally * sally[k]) +
    fred[k, k] / sally[k]^2)
mcse.log.10.bayes

foompter <- cbind(models, log.10.bayes, mcse.log.10.bayes)
round(foompter, 5)


###################################################
### chunk number 19: doit-too
###################################################
#line 650 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/bfst.Rnw"
ibar <- colMeans(out$ibatch)
herman <- sweep(out$ibatch, 2, ibar, "/")
herman <- sweep(herman, 1, herman[ , k], "-")
mcse.log.10.bayes.too <- (1 / log(10)) *
    apply(herman, 2, sd) /sqrt(out$nbatch)
all.equal(mcse.log.10.bayes, mcse.log.10.bayes.too)


