###################################################
### chunk number 1: foo
###################################################
#line 18 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
options(keep.source = TRUE, width = 60)
foo <- packageDescription("mcmc")


###################################################
### chunk number 2: frequentist
###################################################
#line 38 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
library(mcmc)
data(logit)
out <- glm(y ~ x1 + x2 + x3 + x4, data = logit,
    family = binomial(), x = TRUE)
summary(out)


###################################################
### chunk number 3: log.unnormalized.posterior
###################################################
#line 55 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
x <- out$x
y <- out$y

lupost <- function(beta, x, y) {
    eta <- as.numeric(x %*% beta)
    logp <- ifelse(eta < 0, eta - log1p(exp(eta)), - log1p(exp(- eta)))
    logq <- ifelse(eta < 0, - log1p(exp(eta)), - eta - log1p(exp(- eta)))
    logl <- sum(logp[y == 1]) + sum(logq[y == 0])
    return(logl - sum(beta^2) / 8)
}


###################################################
### chunk number 4: metropolis-try-1
###################################################
#line 101 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
set.seed(42)    # to get reproducible results
beta.init <- as.numeric(coefficients(out))
out <- metrop(lupost, beta.init, 1e3, x = x, y = y)
names(out)
out$accept


###################################################
### chunk number 5: metropolis-try-2
###################################################
#line 150 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
out <- metrop(out, scale = 0.1, x = x, y = y)
out$accept
out <- metrop(out, scale = 0.3, x = x, y = y)
out$accept
out <- metrop(out, scale = 0.5, x = x, y = y)
out$accept
out <- metrop(out, scale = 0.4, x = x, y = y)
out$accept


###################################################
### chunk number 6: metropolis-try-3
###################################################
#line 184 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
out <- metrop(out, nbatch = 1e4, x = x, y = y)
out$accept
out$time


###################################################
### chunk number 7: fig1too
###################################################
#line 192 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
plot(ts(out$batch))


###################################################
### chunk number 8: fig1
###################################################
#line 197 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
#line 192 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw#from line#197#"
plot(ts(out$batch))
#line 198 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"


###################################################
### chunk number 9: fig2too
###################################################
#line 208 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
acf(out$batch)


###################################################
### chunk number 10: fig2
###################################################
#line 213 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
#line 208 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw#from line#213#"
acf(out$batch)
#line 214 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"


###################################################
### chunk number 11: metropolis-try-4
###################################################
#line 251 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
out <- metrop(out, nbatch = 1e2, blen = 100,
    outfun = function(z, ...) c(z, z^2), x = x, y = y)
out$accept
out$time


###################################################
### chunk number 12: metropolis-batch
###################################################
#line 278 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
apply(out$batch, 2, mean)


###################################################
### chunk number 13: metropolis-batch-too
###################################################
#line 284 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
foo <- apply(out$batch, 2, mean)
mu <- foo[1:5]
sigmasq <- foo[6:10] - mu^2
mu
sigmasq


###################################################
### chunk number 14: metropolis-mcse-mu
###################################################
#line 294 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
mu.mcse <- apply(out$batch[ , 1:5], 2, sd) / sqrt(out$nbatch)
mu.mcse


###################################################
### chunk number 15: metropolis-mcse-sigmasq
###################################################
#line 339 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
u <- out$batch[ , 1:5]
v <- out$batch[ , 6:10]
ubar <- apply(u, 2, mean)
vbar <- apply(v, 2, mean)
deltau <- sweep(u, 2, ubar)
deltav <- sweep(v, 2, vbar)
foo <- sweep(deltau, 2, ubar, "*")
sigmasq.mcse <- sqrt(apply((deltav - 2 * foo)^2, 2, mean) / out$nbatch)
sigmasq.mcse


###################################################
### chunk number 16: metropolis-mcse-sigmasq-too
###################################################
#line 354 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
sqrt(mean(((v[ , 2] - vbar[2]) - 2 * ubar[2] * (u[ , 2] - ubar[2]))^2) /
    out$nbatch)


###################################################
### chunk number 17: metropolis-mcse-sigma
###################################################
#line 371 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
sigma <- sqrt(sigmasq)
sigma.mcse <- sigmasq.mcse / (2 * sigma)
sigma
sigma.mcse


###################################################
### chunk number 18: metropolis-try-5
###################################################
#line 383 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
out <- metrop(out, nbatch = 5e2, blen = 400, x = x, y = y)
out$accept
out$time
#line 284 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw#from line#386#"
foo <- apply(out$batch, 2, mean)
mu <- foo[1:5]
sigmasq <- foo[6:10] - mu^2
mu
sigmasq
#line 387 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
#line 294 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw#from line#387#"
mu.mcse <- apply(out$batch[ , 1:5], 2, sd) / sqrt(out$nbatch)
mu.mcse
#line 388 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
#line 339 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw#from line#388#"
u <- out$batch[ , 1:5]
v <- out$batch[ , 6:10]
ubar <- apply(u, 2, mean)
vbar <- apply(v, 2, mean)
deltau <- sweep(u, 2, ubar)
deltav <- sweep(v, 2, vbar)
foo <- sweep(deltau, 2, ubar, "*")
sigmasq.mcse <- sqrt(apply((deltav - 2 * foo)^2, 2, mean) / out$nbatch)
sigmasq.mcse
#line 389 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
#line 371 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw#from line#389#"
sigma <- sqrt(sigmasq)
sigma.mcse <- sigmasq.mcse / (2 * sigma)
sigma
sigma.mcse
#line 390 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"


###################################################
### chunk number 19: tab1
###################################################
#line 401 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
foo <- rbind(mu, mu.mcse)
dimnames(foo) <- list(c("estimate", "MCSE"),
    c("constant", paste("$x_", 1:4, "$", sep = "")))
library(xtable)
print(xtable(foo, digits = rep(4, 6),
    align = c("l", rep("c", 5))), floating = FALSE,
    caption.placement = "top",
    sanitize.colnames.function = function(x) return(x))


###################################################
### chunk number 20: tab1
###################################################
#line 418 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
foo <- rbind(sigmasq, sigmasq.mcse)
dimnames(foo) <- list(c("estimate", "MCSE"),
    c("constant", paste("$x_", 1:4, "$", sep = "")))
library(xtable)
print(xtable(foo, digits = rep(4, 6),
    align = c("l", rep("c", 5))), floating = FALSE,
    caption.placement = "top",
    sanitize.colnames.function = function(x) return(x))


###################################################
### chunk number 21: tab1
###################################################
#line 436 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
foo <- rbind(sigma, sigma.mcse)
dimnames(foo) <- list(c("estimate", "MCSE"),
    c("constant", paste("$x_", 1:4, "$", sep = "")))
library(xtable)
print(xtable(foo, digits = rep(4, 6),
    align = c("l", rep("c", 5))), floating = FALSE,
    caption.placement = "top",
    sanitize.colnames.function = function(x) return(x))


###################################################
### chunk number 22: time
###################################################
#line 451 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
cat(out$time[1], "\n")


###################################################
### chunk number 23: x
###################################################
#line 469 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
n <- 2e4
rho <- 0.99
x <- arima.sim(model = list(ar = rho), n = n)


###################################################
### chunk number 24: figgamtoo
###################################################
#line 511 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
out <- initseq(x)
plot(seq(along = out$Gamma.pos) - 1, out$Gamma.pos,
        xlab = "k", ylab = expression(Gamma[k]), type = "l")
lines(seq(along = out$Gamma.dec) - 1, out$Gamma.dec, lty = "dotted")
lines(seq(along = out$Gamma.con) - 1, out$Gamma.con, lty = "dashed")


###################################################
### chunk number 25: figgam
###################################################
#line 520 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
#line 511 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw#from line#520#"
out <- initseq(x)
plot(seq(along = out$Gamma.pos) - 1, out$Gamma.pos,
        xlab = "k", ylab = expression(Gamma[k]), type = "l")
lines(seq(along = out$Gamma.dec) - 1, out$Gamma.dec, lty = "dotted")
lines(seq(along = out$Gamma.con) - 1, out$Gamma.con, lty = "dashed")
#line 521 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"


###################################################
### chunk number 26: assvar
###################################################
#line 537 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
out$var.con
(1 + rho) / (1 - rho) * 1 / (1 - rho^2)


###################################################
### chunk number 27: batx
###################################################
#line 549 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
blen <- 5
x.batch <- apply(matrix(x, nrow = blen), 2, mean)
bout <- initseq(x.batch)


###################################################
### chunk number 28: figgambattoo
###################################################
#line 557 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
plot(seq(along = bout$Gamma.con) - 1, bout$Gamma.con,
        xlab = "k", ylab = expression(Gamma[k]), type = "l")


###################################################
### chunk number 29: figgambat
###################################################
#line 563 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
#line 557 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw#from line#563#"
plot(seq(along = bout$Gamma.con) - 1, bout$Gamma.con,
        xlab = "k", ylab = expression(Gamma[k]), type = "l")
#line 564 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"


###################################################
### chunk number 30: compvar
###################################################
#line 575 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
out$var.con
bout$var.con * blen


###################################################
### chunk number 31: ci-con
###################################################
#line 582 "d:/Rcompile/CRANpkg/local/2.12/mcmc/inst/doc/demo.Rnw"
mean(x) + c(-1, 1) * qnorm(0.975) * sqrt(out$var.con / length(x))
mean(x.batch) + c(-1, 1) * qnorm(0.975) * sqrt(bout$var.con / length(x.batch))


