###################################################
### chunk number 1: setSweaveOptions
###################################################
#line 31 "d:/Rcompile/CRANpkg/local/2.12/nloptr/inst/doc/nloptr.Rnw"
# have an (invisible) initialization noweb chunk
# to remove the default continuation prompt '>'
options(continue = " ")
options(width = 60)

# eliminate margin space above plots
options(SweaveHooks=list(fig=function()
    par(mar=c(5.1, 4.1, 1.1, 2.1))))


###################################################
### chunk number 2: installNLopt eval=FALSE
###################################################
## #line 62 "d:/Rcompile/CRANpkg/local/2.12/nloptr/inst/doc/nloptr.Rnw"
## install.packages("nloptr")


###################################################
### chunk number 3: testNLoptInstallation eval=FALSE
###################################################
## #line 66 "d:/Rcompile/CRANpkg/local/2.12/nloptr/inst/doc/nloptr.Rnw"
## library('nloptr')
## ?nloptr


###################################################
### chunk number 4: installNLoptRForge eval=FALSE
###################################################
## #line 71 "d:/Rcompile/CRANpkg/local/2.12/nloptr/inst/doc/nloptr.Rnw"
## install.packages("nloptr",repos="http://R-Forge.R-project.org")


###################################################
### chunk number 5: installNLoptRForgeSource eval=FALSE
###################################################
## #line 75 "d:/Rcompile/CRANpkg/local/2.12/nloptr/inst/doc/nloptr.Rnw"
## install.packages("nloptr",type="source",repos="http://R-Forge.R-project.org")


###################################################
### chunk number 6: loadLibrary
###################################################
#line 93 "d:/Rcompile/CRANpkg/local/2.12/nloptr/inst/doc/nloptr.Rnw"
library(nloptr)


###################################################
### chunk number 7: defineRosenbrockBanana
###################################################
#line 97 "d:/Rcompile/CRANpkg/local/2.12/nloptr/inst/doc/nloptr.Rnw"
## Rosenbrock Banana function
eval_f <- function(x) {   
    return( 100 * (x[2] - x[1] * x[1])^2 + (1 - x[1])^2 )
}

## Gradient of Rosenbrock Banana function
eval_grad_f <- function(x) { 
    return( c( -400 * x[1] * (x[2] - x[1] * x[1]) - 2 * (1 - x[1]),
                200 * (x[2] - x[1] * x[1]) ) )
}


###################################################
### chunk number 8: setRosenbrockBananaInitialValues
###################################################
#line 110 "d:/Rcompile/CRANpkg/local/2.12/nloptr/inst/doc/nloptr.Rnw"
# initial values
x0 <- c( -1.2, 1 )


###################################################
### chunk number 9: setRosenbrockBananaOptions
###################################################
#line 115 "d:/Rcompile/CRANpkg/local/2.12/nloptr/inst/doc/nloptr.Rnw"
opts <- list("algorithm"="NLOPT_LD_LBFGS",
             "xtol_rel"=1.0e-8)


###################################################
### chunk number 10: solveRosenbrockBanana
###################################################
#line 120 "d:/Rcompile/CRANpkg/local/2.12/nloptr/inst/doc/nloptr.Rnw"
# solve Rosenbrock Banana function
res <- nloptr( x0=x0, 
               eval_f=eval_f, 
               eval_grad_f=eval_grad_f,
               opts=opts)


###################################################
### chunk number 11: printRosenbrockBanana
###################################################
#line 128 "d:/Rcompile/CRANpkg/local/2.12/nloptr/inst/doc/nloptr.Rnw"
print( res )


###################################################
### chunk number 12: defineRosenbrockBananaList
###################################################
#line 132 "d:/Rcompile/CRANpkg/local/2.12/nloptr/inst/doc/nloptr.Rnw"
## Rosenbrock Banana function and gradient in one function
eval_f_list <- function(x) {
    common_term <- x[2] - x[1] * x[1]
    return( list( "objective" = 100 * common_term^2 + (1 - x[1])^2,
                  "gradient"  = c( -400 * x[1] * common_term - 2 * (1 - x[1]),
                                    200 * common_term) ) )
}


###################################################
### chunk number 13: solveRosenbrockBananaList
###################################################
#line 142 "d:/Rcompile/CRANpkg/local/2.12/nloptr/inst/doc/nloptr.Rnw"
res <- nloptr( x0=x0, 
               eval_f=eval_f_list,
               opts=opts)
print( res )


###################################################
### chunk number 14: defineTutorialObjective
###################################################
#line 165 "d:/Rcompile/CRANpkg/local/2.12/nloptr/inst/doc/nloptr.Rnw"
# objective function
eval_f0 <- function( x, a, b ){ 
    return( sqrt(x[2]) )
}

# gradient of objective function
eval_grad_f0 <- function( x, a, b ){ 
    return( c( 0, .5/sqrt(x[2]) ) )
}


###################################################
### chunk number 15: defineTutorialConstraints
###################################################
#line 177 "d:/Rcompile/CRANpkg/local/2.12/nloptr/inst/doc/nloptr.Rnw"
# constraint function
eval_g0 <- function( x, a, b ) {
    return( (a*x[1] + b)^3 - x[2] )
}

# jacobian of constraint
eval_jac_g0 <- function( x, a, b ) {
    return( rbind( c( 3*a[1]*(a[1]*x[1] + b[1])^2, -1.0 ), 
                   c( 3*a[2]*(a[2]*x[1] + b[2])^2, -1.0 ) ) )
}


###################################################
### chunk number 16: defineTutorialParameters
###################################################
#line 192 "d:/Rcompile/CRANpkg/local/2.12/nloptr/inst/doc/nloptr.Rnw"
# define parameters
a <- c(2,-1)
b <- c(0, 1)


###################################################
### chunk number 17: solveTutorialWithGradient
###################################################
#line 198 "d:/Rcompile/CRANpkg/local/2.12/nloptr/inst/doc/nloptr.Rnw"
# Solve using NLOPT_LD_MMA with gradient information supplied in separate function
res0 <- nloptr( x0=c(1.234,5.678), 
                eval_f=eval_f0, 
                eval_grad_f=eval_grad_f0,
                lb = c(-Inf,0), 
                ub = c(Inf,Inf), 
                eval_g_ineq = eval_g0,
                eval_jac_g_ineq = eval_jac_g0,                
                opts = list("algorithm" = "NLOPT_LD_MMA",
                            "print_level" = 2,
                            "check_derivatives" = TRUE,
                            "check_derivatives_print" = "all"),
                a = a, 
                b = b )
print( res0 )


###################################################
### chunk number 18: solveTutorialWithoutGradient
###################################################
#line 222 "d:/Rcompile/CRANpkg/local/2.12/nloptr/inst/doc/nloptr.Rnw"
# Solve using NLOPT_LN_COBYLA without gradient information
res1 <- nloptr( x0=c(1.234,5.678), 
                eval_f=eval_f0, 
                lb = c(-Inf,0), 
                ub = c(Inf,Inf), 
                eval_g_ineq = eval_g0, 
                opts = list("algorithm"="NLOPT_LN_COBYLA"),
                a = a, 
                b = b )
print( res1 )


###################################################
### chunk number 19: derivativeCheckerDefineFunctions
###################################################
#line 237 "d:/Rcompile/CRANpkg/local/2.12/nloptr/inst/doc/nloptr.Rnw"
g <- function( x, a ) {
    return( 
        c( x[1] - a[1], 
           x[2] - a[2],
          (x[1] - a[1])^2, 
          (x[2] - a[2])^2, 
          (x[1] - a[1])^3,
          (x[2] - a[2])^3 
        ) 
    )
}

g_grad <- function( x, a ) {
    return( 
        rbind( 
            c( 1, 0 ),
            c( 0, 1 ),
            c( 2*(x[1] - a[1]), 0 ),
            c( 2*(x[1] - a[1]), 2*(x[2] - a[2]) ),
            c( 3*(x[1] - a[2])^2, 0 ),
            c( 0, 3*(x[2] - a[2])^2 )
        )
    )
}


###################################################
### chunk number 20: derivativeCheckerPrint
###################################################
#line 264 "d:/Rcompile/CRANpkg/local/2.12/nloptr/inst/doc/nloptr.Rnw"
res <- check.derivatives( 
			.x=c(1,2), 
			func=g, 
			func_grad=g_grad, 
			check_derivatives_print='all', 
			a=c(.3, .8) )


###################################################
### chunk number 21: derivativeCheckerResult
###################################################
#line 273 "d:/Rcompile/CRANpkg/local/2.12/nloptr/inst/doc/nloptr.Rnw"
res


###################################################
### chunk number 22: printAllOptions
###################################################
#line 288 "d:/Rcompile/CRANpkg/local/2.12/nloptr/inst/doc/nloptr.Rnw"
nloptr.print.options()


