###################################################
### chunk number 1: 
###################################################
#line 131 "d:/Rcompile/CRANpkg/local/2.12/orsk/inst/doc/orsk_demo.Rnw"
options(prompt = "R> ", continue = "+  ", width = 70, useFancyQuotes = FALSE)


###################################################
### chunk number 2:  eval=FALSE
###################################################
## #line 134 "d:/Rcompile/CRANpkg/local/2.12/orsk/inst/doc/orsk_demo.Rnw"
## install.packages("orsk")


###################################################
### chunk number 3:  eval=FALSE
###################################################
## #line 138 "d:/Rcompile/CRANpkg/local/2.12/orsk/inst/doc/orsk_demo.Rnw"
## library("orsk")
## vignette("orsk_demo",package = "orsk")


###################################################
### chunk number 4:  eval=FALSE
###################################################
## #line 143 "d:/Rcompile/CRANpkg/local/2.12/orsk/inst/doc/orsk_demo.Rnw"
## edit(vignette("orsk_demo",package = "orsk"))


###################################################
### chunk number 5: 
###################################################
#line 155 "d:/Rcompile/CRANpkg/local/2.12/orsk/inst/doc/orsk_demo.Rnw"
library("orsk")


###################################################
### chunk number 6: 
###################################################
#line 158 "d:/Rcompile/CRANpkg/local/2.12/orsk/inst/doc/orsk_demo.Rnw"
### analysis of data in Table 1, upper portion
res1 <- orsk(x=2707, y=2610, a=0.37, al=0.30, au= 0.46, method="optim", d=1.1e-5)
summary(res1)
res2 <- orsk(x=2707, y=2610, a=0.37, al=0.30, au= 0.46, method="grid", d=1e-7)
summary(res2)


###################################################
### chunk number 7: 
###################################################
#line 165 "d:/Rcompile/CRANpkg/local/2.12/orsk/inst/doc/orsk_demo.Rnw"
#compare the computing speed between the two estimating methods. Time to finish the modeling
time.optim <- system.time(orsk(x=2707, y=2610, a=0.37, al=0.30, au=0.46, method="optim"))[1]
time.multi <- system.time(orsk(x=2707, y=2610, a=0.37, al=0.30, au=0.46, method="grid", d=1e-7))[1]


###################################################
### chunk number 8: 
###################################################
#line 175 "d:/Rcompile/CRANpkg/local/2.12/orsk/inst/doc/orsk_demo.Rnw"
### Figure 1 demonstrates that the number of solution converges to zero very quickly for the optim and grid search method.
nrt1 <- nrt2 <- NULL
j1 <- seq(3, 5, by=0.5)
for(k in j1){
infe1 <- try(orsk(x=2707, y=2610, a=0.37, al=0.30, au= 0.46, method="optim", d=10^(-k)))
nrt1 <- c(nrt1, dim(infe1$res)[1])
}
j2 <- seq(5, 7, by=0.5)
for(k in j2){
infe2 <- orsk(x=2707, y=2610, a=0.37, al=0.30, au= 0.46, method="grid", d=10^(-k))
nrt2 <- c(nrt2, dim(infe2$res)[1])
}
par(mfrow=c(1,2))
plot(j1, nrt1, type="l", main="Optim", xlab=expression(-log[10]*delta), ylab="Number of solution", ylim=c(0,250))
plot(j2, nrt2, type="l", main="Grid", xlab=expression(-log[10]*delta), ylab="Number of solution", ylim=c(0,250))


###################################################
### chunk number 9: 
###################################################
#line 218 "d:/Rcompile/CRANpkg/local/2.12/orsk/inst/doc/orsk_demo.Rnw"
### analysis of data in Table 3
res5 <- orsk(x=36, y=4, a=24.0, al=1.99, au= 289.6, method="optim")
summary(res5)
res6 <- orsk(x=36, y=4, a=24.0, al=1.99, au= 289.6, method="grid")
summary(res6)


