###################################################
### chunk number 1: load.library
###################################################
#line 81 "d:/Rcompile/CRANpkg/local/2.12/partitions/inst/doc/setpartitions.Rnw"


###################################################
### chunk number 2: 
###################################################
#line 82 "d:/Rcompile/CRANpkg/local/2.12/partitions/inst/doc/setpartitions.Rnw"
require(partitions)


###################################################
### chunk number 3: alleles
###################################################
#line 293 "d:/Rcompile/CRANpkg/local/2.12/partitions/inst/doc/setpartitions.Rnw"
setparts(c(2,2,1))


###################################################
### chunk number 4: use_achims_idea
###################################################
#line 305 "d:/Rcompile/CRANpkg/local/2.12/partitions/inst/doc/setpartitions.Rnw"
a <- c(1,2,3,2,1)
split(seq_along(a),a)


###################################################
### chunk number 5: 
###################################################
#line 362 "d:/Rcompile/CRANpkg/local/2.12/partitions/inst/doc/setpartitions.Rnw"
options(width=63)
m <- 9
n <- 3


###################################################
### chunk number 6: setpartsrestrictedparts
###################################################
#line 368 "d:/Rcompile/CRANpkg/local/2.12/partitions/inst/doc/setpartitions.Rnw"
jj <- setparts(restrictedparts(m,n,include.zero=FALSE))
summary(jj)


###################################################
### chunk number 7: definepenaltyfunctionF
###################################################
#line 386 "d:/Rcompile/CRANpkg/local/2.12/partitions/inst/doc/setpartitions.Rnw"
tau <- 1:9
slowest <-  function(x) max(tapply(tau, x, sum))


###################################################
### chunk number 8: show_the_best
###################################################
#line 394 "d:/Rcompile/CRANpkg/local/2.12/partitions/inst/doc/setpartitions.Rnw"
time.taken <- apply(jj,2,slowest)
minimal.time <- sum(tau)/n
jj[,time.taken == minimal.time]


###################################################
### chunk number 9: define.E.matrix
###################################################
#line 433 "d:/Rcompile/CRANpkg/local/2.12/partitions/inst/doc/setpartitions.Rnw"
E <- matrix(c(0,0,0,1,1,0,0,0,1,1,1,1,1,0,0), 5,3)
dimnames(E) <-  list(
                     evidence=paste("E",1:5,sep=""),
                     crime=paste("C",1:3,sep="")
                     )


###################################################
### chunk number 10: print.E
###################################################
#line 442 "d:/Rcompile/CRANpkg/local/2.12/partitions/inst/doc/setpartitions.Rnw"
E


###################################################
### chunk number 11: set.evidence.matrix
###################################################
#line 594 "d:/Rcompile/CRANpkg/local/2.12/partitions/inst/doc/setpartitions.Rnw"
a <- 
structure(
          c(2, 2, 4, 4, 3, 1, 2, 1, 1, 2, 2, 1, 4, 2, 1, 2, 1, 
            4, 2, 4, 2, 1, 4, 4, 1, 2, 1, 4, 2, 1, 1, 2, 1, 1, 2),
          .Dim = c(5L, 7L),
          .Dimnames = list(
            evidence=paste("E",1:5,sep=""),
            crime=paste("C",1:7,sep="")
            )
)


###################################################
### chunk number 12: show.a
###################################################
#line 610 "d:/Rcompile/CRANpkg/local/2.12/partitions/inst/doc/setpartitions.Rnw"
a


###################################################
### chunk number 13: calc.likelihoods
###################################################
#line 621 "d:/Rcompile/CRANpkg/local/2.12/partitions/inst/doc/setpartitions.Rnw"
genbeta <- function(x){gamma(sum(x))/prod(gamma(x))}

lp <- function(evidence, alpha, partition){
  r <- length(unique(partition))
  evidence <- as.factor(evidence)
  levels(evidence) <- seq_along(alpha)
  out <- 1
  for(k in unique(partition)){  #k is a perp
    thisperp <- partition==k
    evidence.thisperp <- evidence[thisperp]
    no.of.crimes.thisperp <- sum(thisperp)
    out <- out/genbeta(alpha+table(evidence.thisperp))
  }
  return(out*genbeta(alpha)^r)
}

sp <- setparts(7)
l1 <- apply(sp,2, function(x){lp(evidence=a[1,],alpha=rep(1,2),partition=x)})
l2 <- apply(sp,2, function(x){lp(evidence=a[2,],alpha=rep(1,2),partition=x)})
l3 <- apply(sp,2, function(x){lp(evidence=a[3,],alpha=rep(1,4),partition=x)})
l4 <- apply(sp,2, function(x){lp(evidence=a[4,],alpha=rep(1,4),partition=x)})
l5 <- apply(sp,2, function(x){lp(evidence=a[5,],alpha=rep(1,4),partition=x)})

likelihood <- l1*l2*l3*l4*l5
likelihood <- likelihood/max(likelihood)
support <- log(likelihood)


###################################################
### chunk number 14: plotlikelihoods
###################################################
#line 652 "d:/Rcompile/CRANpkg/local/2.12/partitions/inst/doc/setpartitions.Rnw"
par(mfcol=c(1,2))
plot(likelihood,ylab="likelihood",xlab="hypothesis")
abline(h = exp(-2))
plot(support,ylab="support",xlab="hypothesis")
abline(h = -2)


###################################################
### chunk number 15: show.maximum.likelihood
###################################################
#line 671 "d:/Rcompile/CRANpkg/local/2.12/partitions/inst/doc/setpartitions.Rnw"
sp <- setparts(7)


###################################################
### chunk number 16: 
###################################################
#line 673 "d:/Rcompile/CRANpkg/local/2.12/partitions/inst/doc/setpartitions.Rnw"
sp[,which.max(support)]


###################################################
### chunk number 17: likelihood.gt.2
###################################################
#line 687 "d:/Rcompile/CRANpkg/local/2.12/partitions/inst/doc/setpartitions.Rnw"
index <- order(support,decreasing=TRUE)
sp <- sp[,index]
support <- support[index]
dimnames(sp) <- list(
                     crime = paste("C",1:7, sep=""),
                     partition =  paste("H",1:ncol(sp),sep="")
                     )


###################################################
### chunk number 18: 
###################################################
#line 695 "d:/Rcompile/CRANpkg/local/2.12/partitions/inst/doc/setpartitions.Rnw"
 sp[, support > -2]


###################################################
### chunk number 19: show.likelihoods
###################################################
#line 701 "d:/Rcompile/CRANpkg/local/2.12/partitions/inst/doc/setpartitions.Rnw"
support[support > -2]


